/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ExtraXMLGenerator;
import com.arsdigita.cms.contenttypes.SiteProxyExtraXMLGenerator;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import java.math.BigDecimal;
import java.util.List;

public class SiteProxy
extends ContentPage {
    public static final String URL = "url";
    public static final String TITLE_ATOZ = "titleAtoZ";
    public static final String USED_IN_ATOZ = "usedInAtoZ";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.contenttypes.SiteProxy";
    public static final String TYPE = "com.arsdigita.cms.contenttypes.SiteProxy";

    public SiteProxy() {
        this("com.arsdigita.cms.contenttypes.SiteProxy");
        try {
            this.setContentType(ContentType.findByAssociatedObjectType((String)"com.arsdigita.cms.contenttypes.SiteProxy"));
        }
        catch (DataObjectNotFoundException e) {
            throw new RuntimeException("SiteProxy type not registered");
        }
    }

    public SiteProxy(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID("com.arsdigita.cms.contenttypes.SiteProxy", (Object)id));
    }

    public SiteProxy(OID id) throws DataObjectNotFoundException {
        super(id);
    }

    public SiteProxy(DataObject obj) {
        super(obj);
    }

    public SiteProxy(String type) {
        super(type);
    }

    public String getURL() {
        String url = (String)this.get(URL);
        if (url != null) {
            url.trim();
        }
        return url;
    }

    public void setURL(String url) {
        this.set(URL, url);
    }

    public String getAtoZTitle() {
        return (String)this.get(TITLE_ATOZ);
    }

    public void setAtoZTitle(String atozTitle) {
        this.set(TITLE_ATOZ, atozTitle);
    }

    public boolean isUsedInAtoZ() {
        return Boolean.TRUE.equals(this.get(USED_IN_ATOZ));
    }

    public void setUsedInAtoZ(boolean usedInAtoZ) {
        this.set(USED_IN_ATOZ, new Boolean(usedInAtoZ));
    }

    protected void initialize() {
        super.initialize();
        if (this.isNew()) {
            this.set(USED_IN_ATOZ, Boolean.FALSE);
        }
    }

    public List<ExtraXMLGenerator> getExtraXMLGenerators() {
        List generators = super.getExtraXMLGenerators();
        generators.add(new SiteProxyExtraXMLGenerator());
        return generators;
    }
}

