/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.docrepo;

import com.arsdigita.docrepo.Repository;
import com.arsdigita.docrepo.ui.RecentUpdatedDocsPortlet;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.kernel.ACSObjectInstantiator;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.loader.PackageLoader;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.portal.apportlet.AppPortletSetup;
import com.arsdigita.runtime.ScriptContext;
import com.arsdigita.web.ApplicationType;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;

public class Loader
extends PackageLoader {
    private static final Logger s_log = Logger.getLogger(Loader.class);

    public void run(ScriptContext ctx) {
        new KernelExcursion(){

            public void excurse() {
                this.setEffectiveParty(Kernel.getSystemParty());
                Loader.this.loadDocRepositoryApplicationType();
                Loader.this.setupDocRepositoryPortlet(null);
                Loader.this.setupDefaultDocRepository();
            }
        }.run();
        s_log.info((Object)"Done");
    }

    private void loadDocRepositoryApplicationType() {
        ApplicationType type = new ApplicationType("DocRepo", "com.arsdigita.docrepo.Repository");
        type.setDescription("The document repository empowers users to share documents.");
    }

    private void setupDefaultDocRepository() {
        Repository repo = Repository.create("repository", "Default Document Repository", null);
        repo.save();
    }

    private void setupDocRepositoryPortlet(ApplicationType provider) {
        AppPortletSetup setup = new AppPortletSetup((Category)s_log);
        setup.setPortletObjectType("com.arsdigita.docrepo.ui.RecentUpdatedDocsPortlet");
        setup.setTitle("Recently Updated Documents");
        setup.setDescription("Displays the most recent documents in the document repository.");
        setup.setProfile("wide");
        setup.setProviderApplicationType("com.arsdigita.docrepo.Repository");
        setup.setInstantiator((DomainObjectInstantiator)new ACSObjectInstantiator(){

            protected DomainObject doNewInstance(DataObject dataObject) {
                return new RecentUpdatedDocsPortlet(dataObject);
            }
        });
        setup.run();
    }
}

