/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.docrepo.ui;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.TabbedPane;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.ObjectNotFoundException;
import com.arsdigita.docrepo.File;
import com.arsdigita.docrepo.ui.BrowsePane;
import com.arsdigita.docrepo.ui.DRConstants;
import com.arsdigita.docrepo.ui.DRUtils;
import com.arsdigita.docrepo.ui.DocrepoBasePage;
import com.arsdigita.docrepo.ui.FileInfoHistoryPane;
import com.arsdigita.docrepo.ui.FileInfoPropertiesPane;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.templating.PresentationManager;
import com.arsdigita.templating.Templating;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.Application;
import com.arsdigita.web.BaseApplicationServlet;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Document;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class DRServlet
extends BaseApplicationServlet
implements DRConstants {
    private static final Logger s_log = Logger.getLogger(DRServlet.class);
    private final Map m_pages = new HashMap();

    public void doInit() {
        if (s_log.isDebugEnabled()) {
            s_log.info((Object)"starting RepositoryServlet doInit method ...");
        }
        this.addPage("/", this.buildDMIndexPage());
        this.addPage("/file", this.buildFileInfoPage());
    }

    protected void doService(HttpServletRequest sreq, HttpServletResponse sresp, Application app) throws ServletException, IOException {
        String url;
        int index;
        if (s_log.isDebugEnabled()) {
            s_log.info((Object)"starting doService method");
        }
        if ((index = (url = sreq.getRequestURI()).lastIndexOf("/download/")) > 0) {
            s_log.debug((Object)"Downloading");
            String str = sreq.getParameter(FILE_ID_PARAM.getName());
            if (str != null) {
                BigDecimal id = new BigDecimal(str);
                File file = null;
                try {
                    file = new File(id);
                }
                catch (DataObjectNotFoundException nfe) {
                    throw new ObjectNotFoundException("The requested file no longer exists.");
                }
                file.assertPrivilege(PrivilegeDescriptor.READ);
                String mimetype = file.getContentType();
                if (mimetype == null) {
                    mimetype = "application/octet-stream";
                }
                sresp.setContentType(mimetype);
                String transaction = sreq.getParameter("trans_id");
                InputStream is = transaction == null || transaction.equals("current") ? file.getInputStream() : DRServlet.getFileRevision(transaction);
                DRServlet.sendToOutput(is, (OutputStream)sresp.getOutputStream());
            }
        } else {
            Page page;
            s_log.debug((Object)"show repository page");
            String pathInfo = sreq.getPathInfo();
            Assert.exists((Object)pathInfo, (String)"String pathInfo");
            if (pathInfo.length() > 1 && pathInfo.endsWith("/")) {
                pathInfo = pathInfo.substring(0, pathInfo.length() - 1);
            }
            if ((page = (Page)this.m_pages.get(pathInfo)) != null) {
                Document doc = page.buildDocument(sreq, sresp);
                PresentationManager pm = Templating.getPresentationManager();
                pm.servePage(doc, sreq, sresp);
            } else {
                sresp.sendError(404, "No such page for path " + pathInfo);
            }
        }
    }

    private void addPage(String pathInfo, Page page) {
        Assert.exists((Object)pathInfo, String.class);
        Assert.exists((Object)page, Page.class);
        Assert.isTrue((boolean)pathInfo.startsWith("/"), (String)"path starts not with '/'");
        this.m_pages.put(pathInfo, page);
    }

    private Page buildDMIndexPage() {
        DocrepoBasePage page = new DocrepoBasePage();
        TabbedPane tabbedPane = new TabbedPane();
        tabbedPane.setIdAttr("page-body");
        tabbedPane.addTab((Component)WS_BROWSE_TITLE, (Component)new BrowsePane());
        page.add((Component)tabbedPane);
        page.lock();
        return page;
    }

    private Page buildFileInfoPage() {
        DocrepoBasePage p = new DocrepoBasePage(){

            @Override
            protected void buildTitle() {
                Label title = new Label();
                title.addPrintListener(new PrintListener(){

                    public void prepare(PrintEvent e) {
                        PageState state = e.getPageState();
                        Label t = (Label)e.getTarget();
                        BigDecimal fid = (BigDecimal)state.getValue((ParameterModel)DRConstants.FILE_ID_PARAM);
                        if (fid != null) {
                            t.setLabel(DRUtils.getFile(fid).getName());
                        }
                    }
                });
                this.setTitle(title);
            }
        };
        Label backLinkLabel = GO_BACK_LABEL;
        backLinkLabel.addPrintListener(new PrintListener(){

            public void prepare(PrintEvent e) {
                PageState state = e.getPageState();
                Label t = (Label)e.getTarget();
                String fixed = t.getLabel(e.getPageState());
                String url = Web.getContext().getApplication().getTitle();
                t.setLabel(fixed + " " + url);
            }
        });
        ActionLink backLink = new ActionLink((Component)backLinkLabel);
        backLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                String url = Web.getContext().getApplication().getPath();
                BigDecimal fid = (BigDecimal)state.getValue((ParameterModel)DRConstants.FILE_ID_PARAM);
                if (fid != null) {
                    url = url + "?d_id=" + fid;
                }
                try {
                    DispatcherHelper.sendRedirect((HttpServletRequest)state.getRequest(), (HttpServletResponse)state.getResponse(), (String)url);
                }
                catch (IOException iox) {
                    throw new RuntimeException("Redirect to Application failed" + iox);
                }
            }
        });
        backLink.setClassAttr("actionLink");
        p.add((Component)backLink);
        TabbedPane tb = new TabbedPane();
        tb.setIdAttr("page-body");
        tb.addTab((Component)FILE_INFO_PROPERTIES_TITLE, (Component)new FileInfoPropertiesPane(p));
        tb.addTab((Component)FILE_INFO_HISTORY_TITLE, (Component)new FileInfoHistoryPane());
        p.add((Component)tb);
        p.lock();
        return p;
    }

    private static void sendToOutput(InputStream is, OutputStream os) {
        byte[] buf = new byte[8192];
        try {
            int sz = 0;
            while ((sz = is.read(buf, 0, 8192)) != -1) {
                os.write(buf, 0, sz);
            }
        }
        catch (IOException iox) {
            iox.printStackTrace();
            throw new UncheckedWrapperException("IO Error streaming file", (Throwable)iox);
        }
        finally {
            try {
                is.close();
                os.close();
            }
            catch (IOException iox2) {}
        }
    }

    private static InputStream getFileRevision(String transaction) {
        BigDecimal transactionID = new BigDecimal(transaction);
        Session session = SessionManager.getSession();
        DataQuery query = session.retrieveQuery("com.arsdigita.docrepo.getFileRevisionBlob");
        query.setParameter("transactionID", (Object)transactionID);
        ByteArrayInputStream is = null;
        if (query.next()) {
            Object blob = query.get("content");
            is = new ByteArrayInputStream((byte[])blob);
        }
        return is;
    }
}

