/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.docrepo.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.docrepo.File;
import com.arsdigita.docrepo.Folder;
import com.arsdigita.docrepo.InvalidNameException;
import com.arsdigita.docrepo.Util;
import com.arsdigita.docrepo.ui.CancelButton;
import com.arsdigita.docrepo.ui.DRConstants;
import com.arsdigita.docrepo.ui.DRUtils;
import com.arsdigita.docrepo.ui.FileInfoPropertiesPane;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.Kernel;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;

class FileEditForm
extends Form
implements FormValidationListener,
FormProcessListener,
FormInitListener,
DRConstants {
    private static final String FILE_EDIT = "file-edit";
    private static final String FILE_EDIT_FNAME = "file-edit-name";
    private static final String FILE_EDIT_DESCRIPTION = "file-edit-description";
    private StringParameter m_FileName;
    private StringParameter m_FileDesc;
    private FileInfoPropertiesPane m_parent;

    public FileEditForm(FileInfoPropertiesPane parent) {
        super(FILE_EDIT, (Container)new ColumnPanel(2));
        this.m_parent = parent;
        this.m_FileName = new StringParameter(FILE_EDIT_FNAME);
        this.m_FileDesc = new StringParameter(FILE_EDIT_DESCRIPTION);
        this.add((Component)new Label(FILE_NAME_REQUIRED));
        TextField fnameEntry = new TextField((ParameterModel)this.m_FileName);
        fnameEntry.addValidationListener((ParameterListener)new NotEmptyValidationListener());
        this.add((Component)fnameEntry);
        this.add((Component)new Label(FILE_DESCRIPTION));
        TextArea descArea = new TextArea((ParameterModel)this.m_FileDesc);
        descArea.setRows(10);
        descArea.setCols(40);
        this.add((Component)descArea);
        Submit submit = new Submit("file-edit-save");
        submit.setButtonLabel(FILE_SAVE);
        this.add((Component)new Label());
        SimpleContainer sc = new SimpleContainer();
        sc.add((Component)submit);
        sc.add((Component)new CancelButton(CANCEL));
        this.add((Component)sc);
        this.addInitListener(this);
        this.addProcessListener(this);
        this.addValidationListener(this);
    }

    public void init(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        if (Kernel.getContext().getParty() == null) {
            Util.redirectToLoginPage(state);
        }
        FormData data = e.getFormData();
        BigDecimal id = (BigDecimal)state.getValue((ParameterModel)FILE_ID_PARAM);
        File file = DRUtils.getFile(id);
        data.put((Object)FILE_EDIT_FNAME, (Object)file.getName());
        data.put((Object)FILE_EDIT_DESCRIPTION, (Object)file.getDescription());
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        HttpServletRequest req = state.getRequest();
        FormData data = e.getFormData();
        String fname = (String)data.get((Object)FILE_EDIT_FNAME);
        String fdesc = (String)data.get((Object)FILE_EDIT_DESCRIPTION);
        File file = DRUtils.getFile((BigDecimal)state.getValue((ParameterModel)FILE_ID_PARAM));
        file.setName(file.appendExtension(fname));
        file.setDescription(fdesc);
        file.applyTag(FILE_EDIT_ACTION_DESCRIPTION.localize(req).toString());
        file.save();
        this.m_parent.displayPropertiesAndActions(state);
    }

    public void validate(FormSectionEvent event) throws FormProcessException {
        String name;
        PageState state = event.getPageState();
        FormData data = event.getFormData();
        HttpServletRequest req = state.getRequest();
        File file = DRUtils.getFile((BigDecimal)state.getValue((ParameterModel)FILE_ID_PARAM));
        if (!file.isValidNewName(name = file.appendExtension((String)data.get((Object)FILE_EDIT_FNAME)))) {
            data.addError(FILE_EDIT_FNAME, "Not a valid new name for this file");
        }
        if (!name.equals(file.getName())) {
            try {
                Folder parent = (Folder)file.getParent();
                parent.getResourceID(name);
                data.addError(FILE_EDIT_FNAME, (String)RESOURCE_EXISTS_ERROR.localize(req));
            }
            catch (DataObjectNotFoundException nfe) {
            }
            catch (InvalidNameException ex) {
                data.addError(FILE_EDIT_FNAME, ex.getMessage());
            }
        }
    }
}

