/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.docrepo.ui;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SegmentedPanel;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.docrepo.ui.DRConstants;
import com.arsdigita.docrepo.ui.DocrepoBasePage;
import com.arsdigita.docrepo.ui.FileActionPane;
import com.arsdigita.docrepo.ui.FileEditForm;
import com.arsdigita.docrepo.ui.FilePropertiesPanel;
import com.arsdigita.docrepo.ui.FileSendColleagueForm;
import com.arsdigita.docrepo.ui.VersionUploadForm;
import java.util.ArrayList;

class FileInfoPropertiesPane
extends SimpleContainer
implements DRConstants {
    private ArrayList m_componentList;
    private Component m_properties;
    private Component m_upload;
    private Component m_sendColleague;
    private Component m_edit;
    private Component m_action;
    private DocrepoBasePage m_page;

    public FileInfoPropertiesPane(DocrepoBasePage p) {
        this.m_page = p;
        SegmentedPanel main = new SegmentedPanel();
        main.setClassAttr("main");
        this.m_componentList = new ArrayList();
        this.m_properties = this.makePropertiesPane(main);
        this.m_componentList.add(this.m_properties);
        this.m_edit = this.makeEditPane(main);
        this.m_componentList.add(this.m_edit);
        this.m_action = this.makeActionPane(main);
        this.m_componentList.add(this.m_action);
        this.m_upload = this.makeUploadPane(main);
        this.m_componentList.add(this.m_upload);
        this.m_sendColleague = this.makeSendColleaguePane(main);
        this.m_componentList.add(this.m_sendColleague);
        this.add((Component)main);
    }

    private Component makePropertiesPane(SegmentedPanel main) {
        SimpleContainer container = new SimpleContainer();
        container.add((Component)new FilePropertiesPanel());
        ActionLink link = new ActionLink((Component)new Label(FILE_EDIT_LINK));
        link.setClassAttr("actionLink");
        link.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                FileInfoPropertiesPane.this.displayEditForm(state);
            }
        });
        container.add((Component)link);
        return main.addSegment((Component)FILE_PROPERTIES_HEADER, (Component)container);
    }

    private Component makeEditPane(SegmentedPanel main) {
        return main.addSegment((Component)FILE_EDIT_HEADER, (Component)new FileEditForm(this));
    }

    private Component makeActionPane(SegmentedPanel main) {
        return main.addSegment((Component)FILE_ACTION_HEADER, (Component)new FileActionPane(this));
    }

    private Component makeUploadPane(SegmentedPanel main) {
        return main.addSegment((Component)FILE_UPLOAD_HEADER, (Component)new VersionUploadForm(this));
    }

    private Component makeSendColleaguePane(SegmentedPanel main) {
        return main.addSegment((Component)FILE_SEND_COLLEAGUE_HEADER, (Component)new FileSendColleagueForm(this));
    }

    public void register(Page p) {
        for (int i = 0; i < this.m_componentList.size(); ++i) {
            p.setVisibleDefault((Component)this.m_componentList.get(i), false);
        }
        p.setVisibleDefault(this.m_properties, true);
        p.setVisibleDefault(this.m_action, true);
        p.addGlobalStateParam((ParameterModel)FILE_ID_PARAM);
        super.register(p);
    }

    private void hideAll(PageState state) {
        for (int i = 0; i < this.m_componentList.size(); ++i) {
            ((Component)this.m_componentList.get(i)).setVisible(state, false);
        }
    }

    public void displayPropertiesAndActions(PageState state) {
        this.m_page.goUnmodal(state);
        this.hideAll(state);
        this.m_properties.setVisible(state, true);
        this.m_action.setVisible(state, true);
    }

    public void displayEditForm(PageState state) {
        this.m_page.goModal(state, this.m_edit);
    }

    public void displayUploadForm(PageState state) {
        this.m_page.goModal(state, this.m_upload);
    }

    public void displaySendColleagueForm(PageState state) {
        this.m_page.goModal(state, this.m_sendColleague);
    }
}

