/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.docrepo.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Tree;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.FileUpload;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringLengthValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.dispatcher.MultipartHttpServletRequest;
import com.arsdigita.dispatcher.ObjectNotFoundException;
import com.arsdigita.docrepo.File;
import com.arsdigita.docrepo.Folder;
import com.arsdigita.docrepo.InvalidNameException;
import com.arsdigita.docrepo.Util;
import com.arsdigita.docrepo.ui.BrowsePane;
import com.arsdigita.docrepo.ui.CancelButton;
import com.arsdigita.docrepo.ui.DRConstants;
import com.arsdigita.docrepo.ui.DRUtils;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Application;
import com.arsdigita.web.Web;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class FileUploadForm
extends Form
implements FormInitListener,
FormValidationListener,
FormProcessListener,
DRConstants {
    private static final Logger s_log = Logger.getLogger(FileUploadForm.class);
    private static final String FILE_UPLOAD = "file-upload";
    private static final String FILE_UPLOAD_FORM = "file-upload-form";
    private static final String FILE_UPLOAD_INPUT_DESCRIPTION = "file-description";
    private FileUpload m_fileUpload;
    private StringParameter m_FileDesc;
    private Tree m_tree;
    private BrowsePane m_parent;

    public FileUploadForm(BrowsePane parent, Tree tree) {
        this(parent, tree, true);
    }

    public FileUploadForm(BrowsePane parent, Tree tree, boolean initListeners) {
        super(FILE_UPLOAD_FORM, (Container)new ColumnPanel(2));
        this.m_parent = parent;
        this.setMethod("post");
        this.setEncType("multipart/form-data");
        this.m_tree = tree;
        this.m_fileUpload = new FileUpload(FILE_UPLOAD);
        this.m_FileDesc = new StringParameter(FILE_UPLOAD_INPUT_DESCRIPTION);
        this.m_FileDesc.addParameterListener((ParameterListener)new StringLengthValidationListener(4000));
        this.add((Component)new Label(FILE_UPLOAD_ADD_FILE));
        this.add((Component)this.m_fileUpload);
        this.add((Component)new Label(FILE_DESCRIPTION));
        TextArea textArea = new TextArea((ParameterModel)this.m_FileDesc);
        textArea.setRows(10);
        textArea.setCols(40);
        this.add((Component)textArea);
        SimpleContainer sc = new SimpleContainer();
        Submit submit = new Submit("submit");
        submit.setButtonLabel(FILE_SUBMIT);
        sc.add((Component)submit);
        CancelButton cancel = new CancelButton(CANCEL);
        sc.add((Component)cancel);
        this.add((Component)new Label());
        this.add((Component)sc, 1);
        if (initListeners) {
            this.addInitListener(this);
            this.addProcessListener(this);
            this.addValidationListener(this);
        }
    }

    protected BigDecimal insertFile(FormSectionEvent e) throws FormProcessException {
        s_log.debug((Object)"Inserting a file into the database");
        PageState state = e.getPageState();
        FormData data = e.getFormData();
        HttpServletRequest req = state.getRequest();
        String fname = this.getFileName(e);
        String fdesc = (String)data.get((Object)FILE_UPLOAD_INPUT_DESCRIPTION);
        String fpath = (String)data.get((Object)FILE_UPLOAD);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("getFileName() -> '" + fname + "'"));
            s_log.debug((Object)("description == '" + fdesc + "'"));
            s_log.debug((Object)("path == '" + fpath + "'"));
        }
        java.io.File src = null;
        if (fpath != null && fpath.length() > 0) {
            HttpServletRequest mreq = e.getPageState().getRequest();
            Assert.isTrue((boolean)(mreq instanceof MultipartHttpServletRequest), (String)("I got a " + mreq + " when I was " + "expecting a MultipartHttpServletRequest"));
            src = ((MultipartHttpServletRequest)mreq).getFile(FILE_UPLOAD);
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("file == '" + src + "'"));
        }
        Folder parent = null;
        String selKey = (String)this.m_tree.getSelectedKey(state);
        if (selKey == null) {
            parent = DRUtils.getRootFolder(state);
        } else {
            BigDecimal folderID = new BigDecimal(selKey);
            try {
                parent = new Folder(folderID);
            }
            catch (DataObjectNotFoundException nf) {
                throw new ObjectNotFoundException((String)FOLDER_PARENTNOTFOUND_ERROR.localize(req));
            }
        }
        String mimeType = Util.guessContentType(fname, req);
        final File f1 = new File(parent);
        f1.setContent(src, fname, fdesc, mimeType);
        f1.setDescription(FILE_UPLOAD_INITIAL_TRANSACTION_DESCRIPTION.localize(req).toString());
        f1.applyTag(FILE_UPLOAD_INITIAL_TRANSACTION_DESCRIPTION.localize(req).toString());
        f1.save();
        new KernelExcursion(){

            protected void excurse() {
                Party currentParty = Kernel.getContext().getParty();
                this.setParty(Kernel.getSystemParty());
                PermissionService.grantPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.ADMIN, (ACSObject)f1, currentParty));
                Application app = Web.getContext().getApplication();
                Assert.exists((Object)app, Application.class);
                PermissionService.setContext((ACSObject)f1, (ACSObject)app);
            }
        }.run();
        return f1.getID();
    }

    public void init(FormSectionEvent e) {
        PageState state = e.getPageState();
        if (Kernel.getContext().getParty() == null) {
            Util.redirectToLoginPage(state);
        }
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        s_log.debug((Object)"Processing form submission");
        this.insertFile(e);
        if (this.m_parent != null) {
            this.m_parent.displayFolderContentPanel(e.getPageState());
        }
    }

    protected String getFileName(FormSectionEvent e) {
        FormData data = e.getFormData();
        String filename = (String)data.get((Object)FILE_UPLOAD);
        return DRUtils.extractFileName(filename, e.getPageState());
    }

    public void validate(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        FormData data = e.getFormData();
        HttpServletRequest req = state.getRequest();
        String fname = DRUtils.extractFileName(this.getFileName(e), state);
        if (fname.length() > 200) {
            data.addError(FILE_UPLOAD, "This filename is too long.  It must be fewer than 200 characters.");
        }
        Folder parent = null;
        String selKey = (String)this.m_tree.getSelectedKey(state);
        if (selKey == null) {
            parent = DRUtils.getRootFolder(state);
        } else {
            BigDecimal folderID = new BigDecimal(selKey);
            try {
                parent = new Folder(folderID);
            }
            catch (DataObjectNotFoundException nf) {
                throw new ObjectNotFoundException(FOLDER_PARENTNOTFOUND_ERROR.localize(req).toString());
            }
        }
        try {
            parent.getResourceID(fname);
            data.addError(FILE_UPLOAD, RESOURCE_EXISTS_ERROR.localize(req).toString());
        }
        catch (DataObjectNotFoundException nf) {
        }
        catch (InvalidNameException ex) {
            data.addError(FILE_UPLOAD, ex.getMessage());
        }
    }
}

