/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.docrepo.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.tree.TreeModel;
import com.arsdigita.bebop.tree.TreeNode;
import com.arsdigita.docrepo.Folder;
import com.arsdigita.docrepo.Repository;
import com.arsdigita.docrepo.ui.DRConstants;
import com.arsdigita.docrepo.ui.DRUtils;
import com.arsdigita.docrepo.ui.RepositoryTreeNode;
import com.arsdigita.docrepo.ui.RootTreeNode;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.web.Web;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;

class RepositoriesSuperTreeModel
implements TreeModel,
DRConstants {
    private static BigDecimal REPOSITORIES_ROOT_ID = new BigDecimal(0);

    RepositoriesSuperTreeModel() {
    }

    public TreeNode getRoot(PageState state) {
        Repository repository = (Repository)Web.getContext().getApplication();
        Folder root = repository.getRoot();
        return new RepositoryTreeNode(root);
    }

    public boolean hasChildren(TreeNode n, PageState state) {
        if (n instanceof RootTreeNode) {
            return true;
        }
        Session session = SessionManager.getSession();
        DataQuery query = session.retrieveQuery("com.arsdigita.docrepo.getChildren");
        BigDecimal folderID = DRUtils.getSelFolderOrRootID(state, n);
        query.setParameter("folderID", (Object)folderID);
        query.addEqualsFilter("isFolder", (Object)Boolean.TRUE);
        long s = query.size();
        query.close();
        return s > 0L;
    }

    public Iterator getChildren(TreeNode n, PageState state) {
        BigDecimal folderID = DRUtils.getSelFolderOrRootID(state, n);
        Session ssn = SessionManager.getSession();
        DataQuery query = null;
        if (folderID.equals(REPOSITORIES_ROOT_ID)) {
            Repository currentRepository = (Repository)Web.getContext().getApplication();
            Folder root = currentRepository.getRoot();
            ArrayList<RepositoryTreeNode> list = new ArrayList<RepositoryTreeNode>();
            list.add(new RepositoryTreeNode(root));
            return list.iterator();
        }
        query = ssn.retrieveQuery("com.arsdigita.docrepo.getChildren");
        query.setParameter("folderID", (Object)folderID);
        query.addEqualsFilter("isFolder", (Object)"1");
        return new RepositoryIterator(query);
    }

    private class RepositoryIterator
    implements Iterator {
        private DataQuery m_query;

        public RepositoryIterator(DataQuery query) {
            this.m_query = query;
        }

        @Override
        public boolean hasNext() {
            if (!this.m_query.isEmpty()) {
                if (this.m_query.next()) {
                    return true;
                }
                this.m_query.close();
            }
            return false;
        }

        public Object next() {
            BigDecimal id = (BigDecimal)this.m_query.get("id");
            Folder f = null;
            try {
                f = new Folder(id);
            }
            catch (DataObjectNotFoundException e) {
                throw new RuntimeException(e.getMessage());
            }
            return new RepositoryTreeNode(f);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

