/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.docrepo.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.form.CheckboxGroup;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.bebop.parameters.ArrayParameter;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.docrepo.ui.DRConstants;
import com.arsdigita.docrepo.ui.DRUtils;
import com.arsdigita.docrepo.ui.RepositoriesTableModelBuilder;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

class RepositoriesTable
implements DRConstants {
    private static String REPOSITORIES_IDS = "repositories-ids";
    private static String REPOSITORIES_SUBSCRIBED_IDS = "repositories-subscribed-ids";
    static String[] s_tableHeaders = new String[]{"", "Portal", "Files"};
    private CheckboxGroup m_checkboxGroup;
    private Hidden m_subscribed;
    private ArrayParameter m_sourcesSubscribed;
    private ArrayParameter m_sources;
    private Table m_table;
    private TableModelBuilder m_tableBuilder;
    private RequestLocal m_query = new RequestLocal(){

        protected Object initialValue(PageState s) {
            User viewer = DRUtils.getUser(s);
            Session session = SessionManager.getSession();
            DataQuery query = session.retrieveQuery("com.arsdigita.docrepo.getRepositoriesView");
            query.setParameter("userID", (Object)viewer.getID());
            Vector<Object[]> result = new Vector<Object[]>();
            while (query.next()) {
                Object[] row = new Object[]{query.get("repositoryID"), query.get("isMounted"), query.get("name"), query.get("numFiles")};
                result.add(row);
            }
            query.close();
            return result;
        }
    };

    public RepositoriesTable() {
        this.m_tableBuilder = new RepositoriesTableModelBuilder(this);
        this.m_table = new Table(this.m_tableBuilder, (Object[])s_tableHeaders);
        this.m_sources = new ArrayParameter((ParameterModel)new BigDecimalParameter(REPOSITORIES_IDS));
        this.m_checkboxGroup = new CheckboxGroup(this.m_sources);
        this.m_sourcesSubscribed = new ArrayParameter((ParameterModel)new BigDecimalParameter(REPOSITORIES_SUBSCRIBED_IDS));
        this.m_subscribed = new Hidden((ParameterModel)this.m_sourcesSubscribed);
        this.setCellRenderers();
        this.m_table.setClassAttr("AlternateTable");
    }

    public Iterator getQuery(PageState state) {
        return ((Vector)this.m_query.get(state)).iterator();
    }

    public void setQuery(PageState state, ArrayList list) {
        this.m_query.set(state, (Object)list);
    }

    Table getTable() {
        return this.m_table;
    }

    CheckboxGroup getCheckboxGroup() {
        return this.m_checkboxGroup;
    }

    Hidden getSubscribedHidden() {
        return this.m_subscribed;
    }

    Object[] getSelectedIDs(PageState s) {
        Iterator it = this.getQuery(s);
        ArrayList<String> a = new ArrayList<String>();
        BigDecimal id = null;
        while (it.hasNext()) {
            Object[] field = (Object[])it.next();
            if (1 != ((BigDecimal)field[1]).intValue()) continue;
            id = (BigDecimal)field[0];
            a.add(id.toString());
        }
        return a.toArray();
    }

    public void register(Page p) {
        this.m_table.register(p);
        p.addComponentStateParam((Component)this.m_table, (ParameterModel)this.m_sources);
        p.addComponentStateParam((Component)this.m_table, (ParameterModel)this.m_sourcesSubscribed);
    }

    public void headSelected(TableActionEvent e) {
        throw new UnsupportedOperationException();
    }

    private void setCellRenderers() {
        this.m_table.getColumn(0).setCellRenderer((TableCellRenderer)new CheckBoxRenderer());
    }

    private final class CheckBoxRenderer
    implements TableCellRenderer {
        private CheckBoxRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            BigDecimal id = (BigDecimal)key;
            String optionName = RepositoriesTable.this.m_sources.marshalElement((Object)id.abs());
            Option option = new Option(optionName, "");
            option.setGroup((OptionGroup)RepositoriesTable.this.m_checkboxGroup);
            return option;
        }
    }
}

