/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.docrepo.ui;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SegmentedPanel;
import com.arsdigita.bebop.Tree;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.docrepo.ui.DRConstants;
import com.arsdigita.docrepo.ui.DRUtils;
import com.arsdigita.docrepo.ui.RepositoriesSelectionForm;
import com.arsdigita.docrepo.ui.RepositoriesSuperTreeModel;
import com.arsdigita.docrepo.ui.RepositoriesTable;
import com.arsdigita.docrepo.ui.SuperTree;
import java.math.BigDecimal;

class RepositoryPane
extends BoxPanel
implements DRConstants,
ChangeListener {
    private Tree m_tree;
    private Component m_Repositories;

    public RepositoryPane() {
        this.setClassAttr("sidebarNavPanel");
        this.setAttribute("navbar-title", "Repositories");
        BoxPanel leftSide = new BoxPanel();
        leftSide.setClassAttr("navbar");
        this.m_tree = new SuperTree(new RepositoriesSuperTreeModel());
        this.m_tree.addChangeListener((ChangeListener)this);
        leftSide.add((Component)this.m_tree);
        this.add((Component)leftSide);
        SegmentedPanel rightSide = new SegmentedPanel();
        rightSide.setClassAttr("main");
        this.m_Repositories = this.makeRepositoriesPanel(rightSide);
        this.add((Component)rightSide);
    }

    public void register(Page p) {
        p.addGlobalStateParam((ParameterModel)ROOTFOLDER_ID_PARAM);
        p.addGlobalStateParam((ParameterModel)SEL_FOLDER_ID_PARAM);
        super.register(p);
    }

    public void stateChanged(ChangeEvent e) {
        PageState state = e.getPageState();
        String key = (String)this.m_tree.getSelectedKey(state);
        if (key == null) {
            key = DRUtils.getRootFolder(state).getID().toString();
            this.m_tree.expand(key, state);
        }
        state.setValue((ParameterModel)SEL_FOLDER_ID_PARAM, (Object)new BigDecimal(key));
    }

    private Component makeRepositoriesPanel(SegmentedPanel main) {
        RepositoriesTable table = new RepositoriesTable();
        return main.addSegment((Component)REPOSITORIES_INFORMATION_HEADER, (Component)new RepositoriesSelectionForm(table));
    }
}

