/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.cms.freeform.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.Asset;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.london.cms.freeform.FreeformContentItem;
import com.arsdigita.persistence.OID;
import com.arsdigita.toolbox.ui.DomainObjectSelectionModel;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;

public class AssetSelectionModel
implements DomainObjectSelectionModel {
    public static final String ITEM_PARAM_NAME = "item_id";
    public static final String ASSET_PARAM_NAME = "asset_id";
    public static final String RANK_PARAM_NAME = "rank";
    public static final String MIME_TYPE_PARAM_NAME = "mime_type";
    private ItemSelectionModel m_itemModel;
    private SingleSelectionModel m_assetModel;
    private SingleSelectionModel m_rankModel;
    private SingleSelectionModel m_mimeTypeModel;
    private RequestLocal m_asset = new RequestLocal();
    private RequestLocal m_item = new RequestLocal();

    public AssetSelectionModel() {
        this.m_itemModel = new ItemSelectionModel(ITEM_PARAM_NAME);
        this.m_assetModel = new ParameterSingleSelectionModel((ParameterModel)new StringParameter(ASSET_PARAM_NAME));
        this.m_rankModel = new ParameterSingleSelectionModel((ParameterModel)new StringParameter(RANK_PARAM_NAME));
        this.m_mimeTypeModel = new ParameterSingleSelectionModel((ParameterModel)new StringParameter(MIME_TYPE_PARAM_NAME));
    }

    public void register(Page p, Component c) {
        p.addComponentStateParam(c, this.m_itemModel.getStateParameter());
        p.addComponentStateParam(c, this.m_assetModel.getStateParameter());
        p.addComponentStateParam(c, this.m_rankModel.getStateParameter());
        p.addComponentStateParam(c, this.m_mimeTypeModel.getStateParameter());
    }

    public Asset getAsset(PageState state) {
        HttpServletRequest request;
        String assetId;
        String assetId2;
        Asset asset = (Asset)this.m_asset.get(state);
        if (asset == null && (assetId2 = (String)this.m_assetModel.getSelectedKey(state)) != null && assetId2.length() > 0) {
            try {
                asset = (Asset)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.cms.Asset", (Object)new BigDecimal(assetId2)));
                this.m_asset.set(state, (Object)asset);
                FreeformContentItem item = this.getFreeformContentItem(state);
                if (item != null && asset != null) {
                    String rank = item.getRank(asset);
                    this.setRank(state, rank);
                }
            }
            catch (DataObjectNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (asset == null) {
            FreeformContentItem item = this.getFreeformContentItem(state);
            String rank = this.getRank(state);
            String mimeType = this.getMimeType(state);
            if (item != null && rank != null && mimeType != null) {
                asset = item.getOneAsset(mimeType, rank);
            }
        }
        if (asset == null && (assetId = (request = state.getRequest()).getParameter(ASSET_PARAM_NAME)) != null && assetId.length() > 0) {
            try {
                asset = (Asset)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.cms.Asset", (Object)new BigDecimal(assetId)));
                this.m_asset.set(state, (Object)asset);
                FreeformContentItem item = this.getFreeformContentItem(state);
                if (item != null && asset != null) {
                    String rank = item.getRank(asset);
                    this.setRank(state, rank);
                }
            }
            catch (DataObjectNotFoundException e) {
                e.printStackTrace();
            }
        }
        return asset;
    }

    public void setAsset(PageState state, Asset asset) {
        this.m_asset.set(state, (Object)asset);
        this.m_assetModel.setSelectedKey(state, (Object)asset.getID().toString());
    }

    public FreeformContentItem getFreeformContentItem(PageState state) {
        FreeformContentItem item = (FreeformContentItem)((Object)this.m_item.get(state));
        if (item == null) {
            HttpServletRequest request;
            String itemId;
            item = (FreeformContentItem)this.m_itemModel.getSelectedObject(state);
            if (item == null && (itemId = (request = state.getRequest()).getParameter(ITEM_PARAM_NAME)) != null && itemId.length() > 0) {
                try {
                    item = (FreeformContentItem)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.london.cms.freeform.FreeformContentItem", (Object)new BigDecimal(itemId)));
                }
                catch (DataObjectNotFoundException e) {
                    e.printStackTrace();
                }
            }
            if (item != null) {
                this.m_item.set(state, (Object)item);
            }
        }
        return item;
    }

    public void setFreeformContentItem(PageState state, FreeformContentItem item) {
        this.m_item.set(state, (Object)item);
        this.m_itemModel.setSelectedObject(state, (DomainObject)item);
    }

    public String getRank(PageState state) {
        String rank = (String)this.m_rankModel.getSelectedKey(state);
        if (rank == null || rank.trim().length() == 0) {
            HttpServletRequest request = state.getRequest();
            rank = request.getParameter(RANK_PARAM_NAME);
        }
        return rank;
    }

    public void setRank(PageState state, String rank) {
        this.m_rankModel.setSelectedKey(state, (Object)rank);
    }

    public String getMimeType(PageState state) {
        String mimeType = (String)this.m_mimeTypeModel.getSelectedKey(state);
        if (mimeType == null || mimeType.trim().length() == 0) {
            HttpServletRequest request = state.getRequest();
            mimeType = request.getParameter(MIME_TYPE_PARAM_NAME);
        }
        return mimeType;
    }

    public void setMimeType(PageState state, String mimeType) {
        this.m_mimeTypeModel.setSelectedKey(state, (Object)mimeType);
    }

    public ItemSelectionModel getItemModel() {
        return this.m_itemModel;
    }

    public void setItemModel(ItemSelectionModel itemModel) {
        this.m_itemModel = itemModel;
    }

    public SingleSelectionModel getAssetModel() {
        return this.m_assetModel;
    }

    public void setAssetModel(SingleSelectionModel assetModel) {
        this.m_assetModel = assetModel;
    }

    public SingleSelectionModel getRankModel() {
        return this.m_rankModel;
    }

    public void setRankModel(SingleSelectionModel rankModel) {
        this.m_rankModel = rankModel;
    }

    public SingleSelectionModel getMimeTypeModel() {
        return this.m_mimeTypeModel;
    }

    public void setMimeTypeModel(SingleSelectionModel mimeTypeModel) {
        this.m_mimeTypeModel = mimeTypeModel;
    }

    public DomainObject getSelectedObject(PageState state) {
        return this.getAsset(state);
    }

    public void setSelectedObject(PageState state, DomainObject object) {
        this.m_assetModel.setSelectedKey(state, (Object)((Asset)object).getID().toString());
    }

    public ParameterModel getStateParameter() {
        return this.m_assetModel.getStateParameter();
    }

    public Object getSelectedKey(PageState state) {
        return this.m_assetModel.getSelectedKey(state);
    }

    public void setSelectedKey(PageState state, Object key) {
        this.m_assetModel.setSelectedKey(state, key);
    }

    public void clearSelection(PageState state) {
        this.m_assetModel.clearSelection(state);
        this.m_rankModel.clearSelection(state);
        this.m_mimeTypeModel.clearSelection(state);
    }

    public boolean isSelected(PageState state) {
        return this.m_assetModel.isSelected(state);
    }

    public void addChangeListener(ChangeListener l) {
        this.m_assetModel.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.m_assetModel.removeChangeListener(l);
    }
}

