/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.importer;

import com.arsdigita.london.importer.TagParser;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;

public abstract class AbstractTagParser
implements TagParser {
    private static Logger s_log = Logger.getLogger(TagParser.class);
    private StringBuffer m_body;
    private String m_tagName;
    private String m_tagURI;

    public AbstractTagParser(String tagName, String tagURI) {
        this.m_tagName = tagName;
        this.m_tagURI = tagURI;
    }

    @Override
    public String getTagName() {
        return this.m_tagName;
    }

    @Override
    public String getTagURI() {
        return this.m_tagURI;
    }

    @Override
    public final void startElement(String name, String uri, Attributes atts) {
        this.m_body = new StringBuffer();
        this.startTag(name, uri, atts);
    }

    @Override
    public final void characters(char[] ch, int start, int length) {
        if (this.m_body != null) {
            this.m_body.append(ch, start, length);
        } else if (s_log.isDebugEnabled()) {
            s_log.debug((Object)"Skipping chars from non-leaf tag");
        }
    }

    @Override
    public final void endElement(String name, String uri) {
        this.endTag(name, uri);
        this.m_body = null;
    }

    @Override
    public void startBlock() {
    }

    @Override
    public void startSubBlock(TagParser parser) {
    }

    protected abstract void startTag(String var1, String var2, Attributes var3);

    protected abstract void endTag(String var1, String var2);

    @Override
    public void endBlock() {
    }

    @Override
    public void endSubBlock(TagParser parser) {
    }

    protected String getTagBody() {
        return this.m_body.toString();
    }
}

