/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.importer;

import com.arsdigita.london.importer.TagParser;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.xml.XML;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ParserDispatcher
extends DefaultHandler {
    private static Logger s_log = Logger.getLogger(ParserDispatcher.class);
    private Map m_parsers = new HashMap();
    private Stack m_parserContext;

    public void execute(String importFile) {
        this.m_parserContext = new Stack();
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)("Parsing from " + importFile));
        }
        InputStream is = null;
        try {
            is = new FileInputStream(new File(importFile));
            XML.parse((InputStream)is, (DefaultHandler)this);
        }
        catch (IOException ex) {
            throw new UncheckedWrapperException("cannot load file " + importFile, (Throwable)ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    s_log.warn((Object)("Failed to close " + importFile), (Throwable)e);
                }
            }
        }
    }

    public void execute(InputSource source) {
        this.m_parserContext = new Stack();
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)"Parsing from InputSource");
        }
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setFeature("http://xml.org/sax/features/namespaces", true);
            SAXParser parser = spf.newSAXParser();
            parser.parse(source, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            throw new UncheckedWrapperException("error parsing stream", (Throwable)e);
        }
        catch (SAXException e) {
            if (e.getException() != null) {
                throw new UncheckedWrapperException("error parsing stream", (Throwable)e.getException());
            }
            throw new UncheckedWrapperException("error parsing stream", (Throwable)e);
        }
        catch (IOException e) {
            throw new UncheckedWrapperException("error parsing stream", (Throwable)e);
        }
    }

    public void addParser(TagParser parser) {
        this.m_parsers.put(this.getKey(parser), parser);
    }

    @Override
    public void startElement(String uri, String local, String qname, Attributes atts) {
        TagParser current;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Processing start element: " + qname + " " + uri + " " + local));
        }
        System.out.println("Processing start element: " + qname + " " + uri + " " + local);
        if (this.m_parsers.containsKey(this.getKey(local, uri))) {
            current = this.getCurrentParser();
            TagParser next = (TagParser)this.m_parsers.get(this.getKey(local, uri));
            if (s_log.isInfoEnabled()) {
                s_log.info((Object)("Switching from " + current + " to " + next));
            }
            if (current != null) {
                current.startSubBlock(next);
            }
            next.startBlock();
            this.m_parserContext.push(next);
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("In start, current parser is " + this.getCurrentParser()));
        }
        if ((current = this.getCurrentParser()) != null) {
            current.startElement(local, uri, atts);
        } else {
            s_log.warn((Object)("No current parser available for " + local + " " + uri));
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.getCurrentParser().characters(ch, start, length);
    }

    @Override
    public void endElement(String uri, String local, String qname) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Processing end element: " + qname + " " + uri + " " + local));
        }
        System.out.println("Processing end element: " + qname + " " + uri + " " + local);
        this.getCurrentParser().endElement(local, uri);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("In end, current parser is " + this.getCurrentParser()));
        }
        if (this.m_parsers.containsKey(this.getKey(local, uri))) {
            TagParser current = this.getCurrentParser();
            this.m_parserContext.pop();
            TagParser previous = this.m_parserContext.empty() ? null : (TagParser)this.m_parserContext.peek();
            current.endBlock();
            if (previous != null) {
                previous.endSubBlock(current);
            }
            if (s_log.isInfoEnabled()) {
                s_log.info((Object)("Reverting from " + current + " to " + previous));
            }
        }
    }

    protected String getKey(TagParser parser) {
        String name = parser.getTagName();
        String uri = parser.getTagURI();
        return this.getKey(name, uri);
    }

    protected String getKey(String name, String uri) {
        if (uri == null) {
            return name;
        }
        return name + ":" + uri;
    }

    protected TagParser getCurrentParser() {
        if (this.m_parserContext.empty()) {
            return null;
        }
        return (TagParser)this.m_parserContext.peek();
    }
}

