/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.importer.cms;

import com.arsdigita.cms.BinaryAsset;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.london.importer.DomainObjectMapper;
import com.arsdigita.london.importer.DomainObjectParser;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import sun.misc.BASE64Decoder;

public class ItemParser
extends DomainObjectParser {
    private static Logger s_log = Logger.getLogger(ItemParser.class);
    public static final String DEFAULT_DOMAIN_CLASS = "defaultDomainClass";
    public static final String ID = "id";
    public static final String IS_DELETED = "isDeleted";
    public static final String VERSION = "version";
    public static final String ANCESTORS = "ancestors";
    public static final String NAME = "name";
    public static final String OID_ATTR = "oid";
    public static final String IMAGE_ID = "imageId";
    public static final String ARTICLE_ID = "articleId";
    public static final String DEFAULT_ANCESTORS = "defaultAncestors";
    public static final String DISPLAY_NAME = "displayName";
    public static final String FILE = "file";
    public static final String ENCODING_ATTR = "encoding";
    public static final String ENCODING_BASE64 = "base64";
    public static final String INDEX_ITEM_ATTR = "indexItem";
    public static final String RELABEL_FOLDER_ATTR = "relabelFolder";
    public static final String AUTHOR_ATTR = "author";
    public static final String END_OF_LIFE_ATTR = "eol";
    static final String[] GLOBAL_OID_TYPES = new String[]{"com.arsdigita.cms.MimeType", "com.arsdigita.cms.contenttypes.IsoCountry"};
    private static final String PLAIN_ATTRIBUTE = ":..just the plain attribute!..:";
    private static final String DO_NOT_SAVE = ":..please persistence don't save!..:";
    private static final String COUNT_SUFFIX = "////";
    private Stack m_objectStack = new Stack();
    private Stack m_attributeStack = new Stack();
    private Map m_currentDataObject;
    private int m_recursionLevel = 0;
    private boolean m_write = true;
    private static List s_ignoredProps;
    private static SimpleDateFormat s_formatter;
    private static byte[] s_byteArray;
    private boolean m_begin;
    private boolean m_isIndexItem;
    private boolean m_relabelFolder;
    private String m_author;
    private Date m_archiveDate;

    public ItemParser(File lobDir, DomainObjectMapper mapper) {
        this("item", "http://www.arsdigita.com/cms/1.0", "com.arsdigita.cms.ContentItem", lobDir, mapper);
    }

    public ItemParser(String tagName, String tagURI, String objectType, File lobDir, DomainObjectMapper mapper) {
        super(tagName, tagURI, objectType, lobDir, mapper);
    }

    protected ContentItem importItem() {
        this.debugLog("Ending content item, write: " + this.m_write);
        if (this.m_write) {
            this.debugLog("--------------- About to persist ContentItem -------------------");
            System.out.println("--------------- About to persist ContentItem -------------------");
            return this.persistContentItem(this.m_currentDataObject);
        }
        return null;
    }

    @Override
    public void startBlock() {
        this.m_begin = true;
    }

    @Override
    protected void startTag(String name, String uri, Attributes atts) {
        this.m_attributeStack.push(this.copyAttributes(atts));
        if (this.m_begin) {
            this.m_begin = false;
            OID oid = OID.valueOf((String)atts.getValue(OID_ATTR));
            this.m_write = !this.getObjectMapper().objectExists(oid);
            this.beginContentItem(oid, atts);
        } else {
            if (!this.m_write) {
                return;
            }
            Assert.exists((Object)this.m_currentDataObject, DataObject.class);
            OID currentOID = (OID)this.m_currentDataObject.get(OID_ATTR);
            ObjectType ot = currentOID.getObjectType();
            if (ot == null) {
                throw new UncheckedWrapperException("no object type " + currentOID);
            }
            Property prop = ot.getProperty(name);
            if (prop == null) {
                throw new UncheckedWrapperException("no property " + name + " for " + ot.getQualifiedName());
            }
            if (prop.isAttribute()) {
                this.beginAttribute(this.m_currentDataObject, prop);
            } else {
                OID oid = OID.valueOf((String)atts.getValue(OID_ATTR));
                if (prop.isCollection()) {
                    this.beginAssociation(this.m_currentDataObject, oid, prop);
                } else if (prop.isRole()) {
                    this.beginRole(this.m_currentDataObject, oid, prop);
                } else {
                    s_log.error((Object)("Unknown property type: " + prop));
                }
            }
        }
    }

    @Override
    public void endBlock() {
        ContentItem item = this.importItem();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("End block " + item));
        }
        if (item != null) {
            this.setDomainObject((DomainObject)item);
        }
    }

    protected void beginAssociation(Map parentObject, OID oid, Property property) {
        this.debugLog("Starting association: " + property.getName());
        this.m_objectStack.push(parentObject);
        this.m_currentDataObject = this.getDataObject(oid);
    }

    protected void beginRole(Map parentObject, OID oid, Property property) {
        this.debugLog("Starting role: " + property.getName());
        this.m_objectStack.push(parentObject);
        this.m_currentDataObject = this.getDataObject(oid);
    }

    protected void beginContentItem(OID oid, Attributes atts) {
        this.m_objectStack.clear();
        this.m_recursionLevel = 0;
        this.m_isIndexItem = false;
        this.m_relabelFolder = false;
        this.m_author = null;
        this.m_archiveDate = null;
        if (this.m_write) {
            this.m_currentDataObject = this.getDataObject(oid);
            this.m_isIndexItem = "true".equals(atts.getValue(INDEX_ITEM_ATTR));
            this.m_relabelFolder = "true".equals(atts.getValue(RELABEL_FOLDER_ATTR));
            this.m_author = atts.getValue(AUTHOR_ATTR);
            String eol = atts.getValue(END_OF_LIFE_ATTR);
            if (eol != null && eol.trim().length() > 0) {
                ParsePosition pos = new ParsePosition(0);
                this.m_archiveDate = s_formatter.parse(eol.trim(), pos);
            }
            this.m_objectStack.push(this.m_currentDataObject);
        }
        this.debugLog("Start of content item " + oid + " encountered, write=" + this.m_write);
    }

    protected void beginAttribute(Map objectMap, Property prop) {
        this.m_objectStack.push(PLAIN_ATTRIBUTE);
    }

    @Override
    protected void endTag(String name, String uri) {
        if (this.getTagName().equals(name)) {
            s_log.debug((Object)"All done here");
            return;
        }
        if (this.m_write) {
            if (PLAIN_ATTRIBUTE.equals(this.m_objectStack.peek())) {
                Property prop = ((OID)this.m_currentDataObject.get(OID_ATTR)).getObjectType().getProperty(name);
                this.endAttribute(this.m_currentDataObject, prop, this.getTagBody());
            } else {
                Map parentObject = (Map)this.m_objectStack.peek();
                Property prop = ((OID)parentObject.get(OID_ATTR)).getObjectType().getProperty(name);
                if (prop.isCollection()) {
                    this.endAssociation(parentObject, this.m_currentDataObject, prop);
                } else if (prop.isRole()) {
                    this.endRole(parentObject, this.m_currentDataObject, prop);
                } else {
                    s_log.error((Object)("Unknown property type: " + prop));
                }
            }
        }
        if (!this.m_attributeStack.empty()) {
            this.m_attributeStack.pop();
        }
    }

    public boolean isIndexItem() {
        return this.m_isIndexItem;
    }

    public boolean relabelFolder() {
        return this.m_isIndexItem && this.m_relabelFolder;
    }

    public String getAuthor() {
        return this.m_author;
    }

    public Date getArchiveDate() {
        return (Date)this.m_archiveDate.clone();
    }

    private ContentItem persistContentItem(Map itemMap) {
        OID srcOid = (OID)itemMap.get(OID_ATTR);
        String type = srcOid.getObjectType().getQualifiedName();
        DataObject itemDataObject = SessionManager.getSession().create(type);
        ContentItem item = (ContentItem)this.createACSObject(itemDataObject, itemMap);
        if (item != null && item.getLanguage() == null) {
            item.setLanguage("en");
        }
        this.getObjectMapper().setObject(srcOid, (DomainObject)item);
        this.setAllProperties((ACSObject)item, itemDataObject, itemMap, 0);
        s_log.info((Object)("Created item " + item.getOID() + " from " + srcOid));
        return item;
    }

    protected void endAttribute(Map dataObject, Property prop, String value) {
        this.m_objectStack.pop();
        this.debugLog("Ending attribute: " + prop.getName() + ": " + this.getTagBody());
        this.setProperty(dataObject, prop, value);
    }

    protected void endAssociation(Map parentObject, Map childObject, Property property) {
        String propName = property.getName();
        this.debugLog("Ending association: " + propName + ": " + childObject);
        Integer assocCount = (Integer)parentObject.get(propName + COUNT_SUFFIX);
        int count = 0;
        if (assocCount != null) {
            count = assocCount;
        }
        parentObject.put(propName + COUNT_SUFFIX, ++count);
        parentObject.put(propName + COUNT_SUFFIX + count, childObject);
        this.m_currentDataObject = parentObject;
        this.m_objectStack.pop();
    }

    protected void endRole(Map parentObject, Map childObject, Property property) {
        String propName = property.getName();
        this.debugLog("Ending role: " + propName + ": " + childObject);
        if (!((OID)childObject.get(OID_ATTR)).getObjectType().getQualifiedName().equals("com.arsdigita.cms.ContentType")) {
            parentObject.put(propName + COUNT_SUFFIX + "1", childObject);
        }
        this.m_currentDataObject = parentObject;
        this.m_objectStack.pop();
    }

    private void setAllProperties(ACSObject acs, DataObject dataObject, Map objectMap, int recursionLevel) {
        this.m_recursionLevel = recursionLevel;
        this.debugLog("setAll on " + dataObject.getOID() + ": " + objectMap);
        for (String key : objectMap.keySet()) {
            if (s_ignoredProps.contains(key)) {
                this.debugLog("Ignoring property: " + key);
                continue;
            }
            int pos = key.indexOf(COUNT_SUFFIX);
            if (pos > -1 && key.length() > pos + COUNT_SUFFIX.length()) {
                String propName = key.substring(0, pos);
                this.debugLog("Compound property: " + propName);
                Map childObjectMap = (Map)objectMap.get(key);
                DataObject childObject = null;
                boolean recurse = true;
                OID childOid = (OID)childObjectMap.get(OID_ATTR);
                String type = childOid.getObjectType().getQualifiedName();
                ACSObject childAcs = null;
                if (childObjectMap.containsKey(DO_NOT_SAVE)) {
                    childObject = SessionManager.getSession().retrieve(childOid);
                    recurse = false;
                } else {
                    childObject = SessionManager.getSession().create(type);
                    childAcs = this.createACSObject(childObject, childObjectMap);
                    this.getObjectMapper().setObject(childOid, (DomainObject)childAcs);
                }
                Property prop = dataObject.getObjectType().getProperty(propName);
                if (prop.isCollection()) {
                    DataAssociation assoc = (DataAssociation)dataObject.get(propName);
                    assoc.add(childObject);
                } else {
                    dataObject.set(propName, (Object)childObject);
                }
                if (!recurse) continue;
                this.setAllProperties(childAcs, childObject, childObjectMap, recursionLevel + 1);
                this.m_recursionLevel = recursionLevel;
                continue;
            }
            if (pos != -1) continue;
            dataObject.set(key, objectMap.get(key));
            this.debugLog("Simple property: " + key + ": " + objectMap.get(key));
        }
        this.finalizeACSObject(acs, dataObject, objectMap);
    }

    private void finalizeACSObject(ACSObject acs, DataObject dobj, Map objMap) {
        this.debugLog("finalizing ACS: " + acs.getClass() + ": " + acs);
        if (acs instanceof BinaryAsset && dobj.get("mimeType") == null) {
            MimeType mime;
            String mimeString = "application/octet-stream";
            String filename = (String)dobj.get(NAME);
            this.debugLog("Guessing mime type for file: " + filename);
            if (filename != null && (mime = MimeType.guessMimeTypeFromFile((String)filename)) != null) {
                mimeString = mime.getMimeType();
            }
            this.debugLog("Guessed mime type: " + mimeString);
            OID mimeOid = new OID("com.arsdigita.cms.MimeType");
            mimeOid.set("mimeType", (Object)mimeString);
            DataObject mimeObj = SessionManager.getSession().retrieve(mimeOid);
            this.debugLog("Guessing mimetype from filename: " + filename + ", mime=" + mimeOid);
            dobj.set("mimeType", (Object)mimeObj);
        }
        if (dobj.getObjectType().getProperty(DISPLAY_NAME) != null && dobj.get(DISPLAY_NAME) == null) {
            dobj.set(DISPLAY_NAME, (Object)(dobj.getObjectType().getQualifiedName() + " " + dobj.getOID().get(ID).toString()));
            this.debugLog("finalizing DISPLAY_NAME: " + dobj.get(DISPLAY_NAME));
        }
        if (dobj.getObjectType().getProperty(NAME) != null && dobj.get(NAME) == null) {
            dobj.set(NAME, (Object)(dobj.getObjectType().getName() + "-" + dobj.getOID().get(ID).toString()));
            this.debugLog("finalizing NAME: " + dobj.get(NAME));
        }
    }

    private Map getDataObject(OID srcOid) {
        String type = srcOid.getObjectType().getQualifiedName();
        HashMap<String, Object> newDataObject = new HashMap<String, Object>();
        newDataObject.put(OID_ATTR, srcOid);
        if (Arrays.asList(GLOBAL_OID_TYPES).contains(type)) {
            DataObject dobj = SessionManager.getSession().retrieve(srcOid);
            if (dobj == null) {
                s_log.error((Object)("Global OID not found in db: " + srcOid));
                return null;
            }
            this.debugLog("Data Object retrieved from db: " + srcOid);
            newDataObject.put(DO_NOT_SAVE, Boolean.TRUE);
            return newDataObject;
        }
        if ("com.arsdigita.cms.ContentType".equals(type)) {
            newDataObject.put(DO_NOT_SAVE, Boolean.TRUE);
            return newDataObject;
        }
        DomainObject destination = this.getObjectMapper().getObject(srcOid);
        this.debugLog("finding mapped destination oid: " + destination);
        if (destination != null) {
            newDataObject.put(OID_ATTR, destination.getOID());
            newDataObject.put(DO_NOT_SAVE, Boolean.TRUE);
        }
        return newDataObject;
    }

    private ACSObject createACSObject(DataObject dobj, Map properties) {
        String domainClass = (String)properties.get(DEFAULT_DOMAIN_CLASS);
        if (domainClass == null) {
            domainClass = dobj.getOID().getObjectType().getQualifiedName();
        }
        this.debugLog("Creating " + domainClass + " ...");
        try {
            Class<?> classDef = Class.forName(domainClass);
            Constructor<?> constructor = classDef.getConstructor(DataObject.class);
            ACSObject object = (ACSObject)constructor.newInstance(dobj);
            this.debugLog("Successfully created " + object.getOID());
            return object;
        }
        catch (InvocationTargetException e) {
            throw new UncheckedWrapperException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new UncheckedWrapperException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new UncheckedWrapperException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new UncheckedWrapperException((Throwable)e);
        }
        catch (Exception e) {
            throw new UncheckedWrapperException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProperty(Map dobj, Property prop, String value) {
        String key = prop.getName();
        Class propertyClass = prop.getJavaClass();
        if (s_ignoredProps.contains(key)) {
            this.debugLog("Ignoring property: " + key);
            return;
        }
        if (propertyClass.equals(String.class)) {
            dobj.put(key, value);
        } else if (propertyClass.equals(Date.class)) {
            ParsePosition pos = new ParsePosition(0);
            Date date = s_formatter.parse(value.trim(), pos);
            dobj.put(key, date);
        } else if (propertyClass.equals(Integer.class)) {
            dobj.put(key, Integer.valueOf(value));
        } else if (propertyClass.equals(BigDecimal.class)) {
            dobj.put(key, new BigDecimal(value));
        } else if (propertyClass.equals(Boolean.class)) {
            dobj.put(key, Boolean.valueOf(value));
        } else if (propertyClass.equals(s_byteArray.getClass())) {
            OID srcOid = (OID)dobj.get(OID_ATTR);
            String filename = srcOid.get(ID).toString() + "-" + key + ".raw";
            Map atts = (Map)this.m_attributeStack.peek();
            if (atts != null && atts.get(FILE) != null) {
                filename = (String)atts.get(FILE);
                if (!dobj.containsKey(NAME)) {
                    dobj.put(NAME, filename);
                }
            }
            if (atts != null && atts.get(ENCODING_ATTR) != null) {
                String encoding = (String)atts.get(ENCODING_ATTR);
                if (ENCODING_BASE64.equals(encoding)) {
                    BASE64Decoder decoder = new BASE64Decoder();
                    try {
                        byte[] content = decoder.decodeBuffer(value);
                        dobj.put(key, content);
                        this.debugLog("Successfully loaded base64 encoded BLOB, length: " + content.length + " bytes");
                        return;
                    }
                    catch (IOException ioe) {
                        throw new UncheckedWrapperException((Throwable)ioe);
                    }
                }
                s_log.error((Object)("Don't know how to handle encoding: " + encoding));
                return;
            }
            File lobFile = new File(this.getLobDirectory(), filename);
            FileInputStream in = null;
            try {
                in = new FileInputStream(lobFile);
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                int length = -1;
                try {
                    while ((length = in.read(buffer)) != -1) {
                        os.write(buffer, 0, length);
                    }
                }
                catch (IOException ioe) {
                    throw new UncheckedWrapperException((Throwable)ioe);
                }
                byte[] content = os.toByteArray();
                dobj.put(key, content);
                this.debugLog("Successfully loaded file " + lobFile + ", length: " + content.length + " bytes");
            }
            catch (FileNotFoundException e) {
                s_log.error((Object)("Lob file: " + lobFile + " does not exist!"), (Throwable)e);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    s_log.warn((Object)("Failed to close " + lobFile), (Throwable)e);
                }
            }
        } else {
            s_log.warn((Object)("Don't know how to handle property " + key + ", type: " + propertyClass.getName()));
        }
    }

    private void debugLog(String logString) {
        s_log.debug((Object)(this.getPadding() + logString));
    }

    private String getPadding() {
        int level = this.m_recursionLevel;
        if (level == 0) {
            level = this.m_objectStack.size();
        }
        String padString = "   ";
        StringBuffer padding = new StringBuffer(level * padString.length());
        for (int i = 0; i < level; ++i) {
            padding.append(padString);
        }
        return padding.toString();
    }

    protected Map copyAttributes(Attributes atts) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < atts.getLength(); ++i) {
            map.put(atts.getQName(i), atts.getValue(i));
        }
        return map;
    }

    static {
        s_formatter = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
        s_byteArray = new byte[0];
        s_log.debug((Object)"Static initalizer starting...");
        s_ignoredProps = new ArrayList();
        s_ignoredProps.add(ID);
        s_ignoredProps.add(OID_ATTR);
        s_ignoredProps.add(IS_DELETED);
        s_ignoredProps.add(VERSION);
        s_ignoredProps.add(ANCESTORS);
        s_ignoredProps.add(IMAGE_ID);
        s_ignoredProps.add(ARTICLE_ID);
        s_ignoredProps.add(DEFAULT_ANCESTORS);
        s_ignoredProps.add(DO_NOT_SAVE);
        s_log.debug((Object)"Static initalizer finished.");
    }
}

