/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.SimpleAddress;
import com.arsdigita.cms.contenttypes.ui.SimpleAddressPropertyForm;
import com.arsdigita.cms.contenttypes.util.SimpleAddressGlobalizationUtil;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.SimpleEditStep;
import com.arsdigita.cms.ui.workflow.WorkflowLockedComponentAccess;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ui.DomainObjectSelectionModel;
import com.arsdigita.toolbox.ui.ComponentAccess;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;
import java.text.DateFormat;

public class SimpleAddressPropertiesStep
extends SimpleEditStep {
    public static final String EDIT_SHEET_NAME = "edit";

    public SimpleAddressPropertiesStep(ItemSelectionModel itemModel, AuthoringKitWizard parent) {
        super(itemModel, parent);
        this.setDefaultEditKey(EDIT_SHEET_NAME);
        SimpleAddressPropertyForm editSheet = new SimpleAddressPropertyForm(itemModel, this);
        this.add(EDIT_SHEET_NAME, "Edit", (ComponentAccess)new WorkflowLockedComponentAccess((Component)editSheet, itemModel), editSheet.getSaveCancelSection().getCancelButton());
        this.setDisplayComponent(SimpleAddressPropertiesStep.getAddressPropertySheet(itemModel));
    }

    public static Component getAddressPropertySheet(ItemSelectionModel itemModel) {
        DomainObjectPropertySheet sheet = new DomainObjectPropertySheet((DomainObjectSelectionModel)itemModel);
        sheet.add((String)SimpleAddressGlobalizationUtil.globalize("cms.contenttypes.ui.name").localize(), "name");
        sheet.add((String)SimpleAddressGlobalizationUtil.globalize("cms.contenttypes.ui.title").localize(), "title");
        if (!ContentSection.getConfig().getHideLaunchDate()) {
            sheet.add((String)SimpleAddressGlobalizationUtil.globalize("cms.ui.authoring.page_launch_date").localize(), "launchDate", new DomainObjectPropertySheet.AttributeFormatter(){

                public String format(DomainObject item, String attribute, PageState state) {
                    ContentPage page = (ContentPage)item;
                    if (page.getLaunchDate() != null) {
                        return DateFormat.getDateInstance(1).format(page.getLaunchDate());
                    }
                    return (String)SimpleAddressGlobalizationUtil.globalize("cms.ui.unknown").localize();
                }
            });
        }
        sheet.add((String)SimpleAddressGlobalizationUtil.globalize("cms.contenttypes.ui.simpleaddress.address").localize(), "address");
        if (!SimpleAddress.getConfig().getHideCountryCodeSelection()) {
            sheet.add((String)SimpleAddressGlobalizationUtil.globalize("cms.contenttypes.ui.simpleaddress.iso_country_code").localize(), "isoCountryCode", new DomainObjectPropertySheet.AttributeFormatter(){

                public String format(DomainObject item, String attribute, PageState state) {
                    SimpleAddress address = (SimpleAddress)item;
                    if (address.getCountryIsoCode() != null) {
                        return address.getCountryIsoCode();
                    }
                    return (String)SimpleAddressGlobalizationUtil.globalize("cms.ui.unknown").localize();
                }
            });
        }
        if (!SimpleAddress.getConfig().getHidePostalCode()) {
            sheet.add((String)SimpleAddressGlobalizationUtil.globalize("cms.contenttypes.ui.simpleaddress.postal_code").localize(), "postalCode");
        }
        sheet.add((String)SimpleAddressGlobalizationUtil.globalize("cms.contenttypes.ui.simpleaddress.phone").localize(), "phone");
        sheet.add((String)SimpleAddressGlobalizationUtil.globalize("cms.contenttypes.ui.simpleaddress.mobile").localize(), "mobile");
        sheet.add((String)SimpleAddressGlobalizationUtil.globalize("cms.contenttypes.ui.simpleaddress.fax").localize(), "fax");
        sheet.add((String)SimpleAddressGlobalizationUtil.globalize("cms.contenttypes.ui.simpleaddress.email").localize(), "email");
        sheet.add((String)SimpleAddressGlobalizationUtil.globalize("cms.contenttypes.ui.simpleaddress.uri").localize(), "uri");
        sheet.add((String)SimpleAddressGlobalizationUtil.globalize("cms.contenttypes.ui.simpleaddress.notes").localize(), "notes");
        return sheet;
    }
}

