/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui.authoring;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.GlossaryItem;
import com.arsdigita.cms.contenttypes.ui.GlossaryItemWidgetBuilder;
import com.arsdigita.cms.ui.authoring.CreationSelector;
import com.arsdigita.cms.ui.authoring.PageCreate;
import com.arsdigita.kernel.ACSObject;

public class GlossaryItemCreate
extends PageCreate {
    public static final String DEFINITION = "definition";
    private CreationSelector m_parent;

    public GlossaryItemCreate(ItemSelectionModel itemModel, CreationSelector parent) {
        super(itemModel, parent);
        this.m_parent = parent;
    }

    protected void addWidgets() {
        super.addWidgets();
        GlossaryItemWidgetBuilder builder = new GlossaryItemWidgetBuilder();
        this.add((Component)builder.makeDefinitionLabel());
        this.add((Component)builder.makeDefinitionArea());
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        FormData data = e.getFormData();
        PageState state = e.getPageState();
        Folder f = this.m_parent.getFolder(state);
        GlossaryItem item = (GlossaryItem)this.createContentPage(state);
        item.setLanguage((String)data.get((Object)"language"));
        item.setName((String)data.get((Object)"name"));
        item.setTitle((String)data.get((Object)"title"));
        item.setDefinition((String)data.get((Object)DEFINITION));
        item.save();
        ContentBundle bundle = new ContentBundle((ContentItem)item);
        bundle.setParent((ACSObject)f);
        bundle.setContentSection(this.m_parent.getContentSection(state));
        bundle.save();
        this.getWorkflowSection().applyWorkflow(state, (ContentItem)item);
        this.m_parent.editItem(state, (ContentItem)item);
    }
}

