/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.AuthoringKitStepAssociation;
import com.arsdigita.cms.AuthoringStep;
import com.arsdigita.cms.AuthoringStepCollection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import java.math.BigDecimal;

public class AuthoringKit
extends ACSObject {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.AuthoringKit";
    protected static final String CREATE_COMPONENT = "createComponent";
    protected static final String CONTENT_TYPE = "contentType";
    protected static final String STEPS = "authoringSteps";
    private static final String LAST_STEP_QUERY = "com.arsdigita.cms.getLastAuthoringStepOrder";
    private static final String LAST_STEP_ORDER = "stepOrder";
    private static final String LAST_STEP_KIT_ID = "kitId";

    public AuthoringKit() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public AuthoringKit(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public AuthoringKit(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public AuthoringKit(DataObject obj) {
        super(obj);
    }

    protected AuthoringKit(String type) {
        super(type);
    }

    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public String getCreateComponent() {
        return (String)this.get(CREATE_COMPONENT);
    }

    public void setCreateComponent(String component) {
        this.set(CREATE_COMPONENT, component);
    }

    public ContentType getContentType() {
        DataObject type = (DataObject)this.get(CONTENT_TYPE);
        if (type == null) {
            return null;
        }
        return new ContentType(type);
    }

    protected void setContentType(ContentType type) {
        this.setAssociation(CONTENT_TYPE, (DomainObject)type);
    }

    public AuthoringStep createStep(String label, String description, String component, BigDecimal ordering) {
        return this.createStep(label, null, description, null, component, ordering);
    }

    public AuthoringStep createStep(String labelKey, String labelBundle, String descriptionKey, String descriptionBundle, String component, BigDecimal ordering) {
        AuthoringStep step = new AuthoringStep();
        step.setLabelKey(labelKey);
        step.setLabelBundle(labelBundle);
        step.setDescriptionKey(descriptionKey);
        step.setDescriptionBundle(descriptionBundle);
        step.setComponent(component);
        step.save();
        this.addStep(step, ordering);
        return step;
    }

    public boolean addStep(AuthoringStep step, BigDecimal ordering) {
        try {
            OID oid = new OID("com.arsdigita.cms.AuthoringKitStepAssociation");
            oid.set(LAST_STEP_KIT_ID, (Object)this.getID());
            oid.set("stepId", (Object)step.getID());
            AuthoringKitStepAssociation assn = new AuthoringKitStepAssociation(oid);
            assn.setOrdering(ordering);
            assn.save();
            return false;
        }
        catch (DataObjectNotFoundException e) {
            AuthoringKitStepAssociation assn = new AuthoringKitStepAssociation();
            assn.setKit(this);
            assn.setStep(step);
            assn.setOrdering(ordering);
            assn.save();
            return true;
        }
    }

    public AuthoringStep createStep(String label, String description, String component) {
        BigDecimal order = new BigDecimal(this.getLastOrdering().intValue() + 1);
        return this.createStep(label, description, component, order);
    }

    public BigDecimal getOrdering(AuthoringStep step) {
        try {
            OID oid = new OID("com.arsdigita.cms.AuthoringKitStepAssociation");
            oid.set(LAST_STEP_KIT_ID, (Object)this.getID());
            oid.set("stepId", (Object)step.getID());
            AuthoringKitStepAssociation assn = new AuthoringKitStepAssociation(oid);
            return assn.getOrdering();
        }
        catch (DataObjectNotFoundException e) {
            return null;
        }
    }

    public BigDecimal getLastOrdering() {
        DataQuery q = SessionManager.getSession().retrieveQuery(LAST_STEP_QUERY);
        q.setParameter(LAST_STEP_KIT_ID, (Object)this.getID());
        q.next();
        BigDecimal i = (BigDecimal)q.get(LAST_STEP_ORDER);
        q.close();
        return i;
    }

    public boolean removeStep(AuthoringStep step) {
        try {
            OID oid = new OID("com.arsdigita.cms.AuthoringKitStepAssociation");
            oid.set(LAST_STEP_KIT_ID, (Object)this.getID());
            oid.set("stepId", (Object)step.getID());
            AuthoringKitStepAssociation assn = new AuthoringKitStepAssociation(oid);
            assn.delete();
            return true;
        }
        catch (DataObjectNotFoundException e) {
            return false;
        }
    }

    public AuthoringStepCollection getSteps() {
        DataAssociation da = (DataAssociation)this.get(STEPS);
        AuthoringStepCollection steps = new AuthoringStepCollection((DataCollection)da.cursor());
        steps.setOrder("link.ordering");
        return steps;
    }
}

