/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.form.DHTMLEditor;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ExtraXMLGenerator;
import com.arsdigita.cms.dispatcher.DefaultTemplateResolver;
import com.arsdigita.cms.dispatcher.ItemResolver;
import com.arsdigita.cms.dispatcher.MultilingualItemResolver;
import com.arsdigita.cms.dispatcher.TemplateResolver;
import com.arsdigita.cms.lifecycle.PublishLifecycleListener;
import com.arsdigita.cms.publishToFile.PublishToFileConfig;
import com.arsdigita.cms.ui.authoring.ItemCategoryExtension;
import com.arsdigita.cms.ui.authoring.ItemCategoryForm;
import com.arsdigita.runtime.AbstractConfig;
import com.arsdigita.util.StringUtils;
import com.arsdigita.util.parameter.BooleanParameter;
import com.arsdigita.util.parameter.EnumerationParameter;
import com.arsdigita.util.parameter.ErrorList;
import com.arsdigita.util.parameter.IntegerParameter;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.ResourceParameter;
import com.arsdigita.util.parameter.SpecificClassParameter;
import com.arsdigita.util.parameter.StringArrayParameter;
import com.arsdigita.util.parameter.StringParameter;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;

public final class CMSConfig
extends AbstractConfig {
    private static final Logger s_log = Logger.getLogger(CMSConfig.class);
    private static CMSConfig s_config;
    private static Map s_skipAssetSteps;
    private final Parameter m_categoryAuthoringAddForm = new SpecificClassParameter("com.arsdigita.cms.category_authoring_add_form", 1, ItemCategoryForm.class, SimpleComponent.class);
    private final Parameter m_defaultItemTemplatePath = new StringParameter("com.arsdigita.cms.default_item_template_path", 1, (Object)"/default/item.jsp");
    private final Parameter m_defaultFolderTemplatePath = new StringParameter("com.arsdigita.cms.default_folder_template_path", 1, (Object)"/default/folder.jsp");
    private final Parameter m_templateRootPath = new StringParameter("com.arsdigita.cms.template_root_path", 1, (Object)"/templates/ccm-cms/content-section");
    private final Parameter m_itemAdapters = new ResourceParameter("com.arsdigita.cms.item_adapters", 1, (Object)"/WEB-INF/resources/cms-item-adapters.xml");
    private final Parameter m_useStreamlinedCreation = new BooleanParameter("com.arsdigita.cms.use_streamlined_creation", 1, (Object)Boolean.TRUE);
    private final Parameter m_dhtmlEditorConfig = new DHTMLEditorConfigParameter("com.arsdigita.cms.dhtml_editor_config", 1, new DHTMLEditor.Config("Xinha.Config", "/assets/xinha/CCMcmsXinhaConfig.js"));
    private final Parameter m_dhtmlEditorPlugins = new StringArrayParameter("com.arsdigita.cms.dhtml_editor_plugins", 0, null);
    private final Parameter m_dhtmlEditorHiddenButtons = new StringArrayParameter("com.arsdigita.cms.dhtml_editor_hidden_buttons", 0, null);
    private final Parameter m_hideAdminTabs = new BooleanParameter("com.arsdigita.cms.hide_admin_tabs", 1, (Object)Boolean.FALSE);
    private final Parameter m_hideFolderIndexCheckbox = new BooleanParameter("com.arsdigita.cms.hide_folder_index_checkbox", 1, (Object)Boolean.FALSE);
    private final Parameter m_hideLaunchDate = new BooleanParameter("com.arsdigita.cms.hide_launch_date", 1, (Object)Boolean.TRUE);
    private final Parameter m_requireLaunchDate = new BooleanParameter("com.arsdigita.cms.require_launch_date", 1, (Object)Boolean.FALSE);
    private final Parameter m_hideTemplatesTab = new BooleanParameter("com.arsdigita.cms.hide_templates_tab", 1, (Object)Boolean.FALSE);
    private final Parameter m_hideTextAssetUploadFile = new BooleanParameter("com.arsdigita.cms.hide_text_asset_upload_file", 1, (Object)Boolean.FALSE);
    private final Parameter m_hideTimezone = new BooleanParameter("com.arsdigita.cms.hide_timezone", 1, (Object)Boolean.FALSE);
    private final Parameter m_hideUDCTUI = new BooleanParameter("com.arsdigita.cms.hide_udct_ui", 1, (Object)Boolean.FALSE);
    private final Parameter m_publishLifecycleListenerClass = new StringParameter("com.arsdigita.cms.publish_lifecycle_listener_class", 0, (Object)PublishLifecycleListener.class.getName());
    private final Parameter m_saveTextCleansWordTags = new BooleanParameter("com.arsdigita.cms.save_text_cleans_word_tags", 0, (Object)Boolean.FALSE);
    private final Parameter m_hideAdditionalResourceFields = new BooleanParameter("com.arsdigita.cms.contentassets.ui.RelatedLinkPropertyForm.hideAdditionalResourceFields", 1, (Object)Boolean.FALSE);
    private final Parameter m_disableFileAssetExtraction = new BooleanParameter("com.arsdigita.cms.search.disableFileAssetExtraction", 1, (Object)Boolean.FALSE);
    private final Parameter m_deleteWorkflowAfterPublication = new BooleanParameter("com.arsdigita.cms.delete_workflow_after_publication", 1, (Object)Boolean.TRUE);
    private final Parameter m_soonExpiredTimespanDays = new IntegerParameter("com.arsdigita.cms.soon_expired_timespan_days", 1, (Object)new Integer(14));
    private final Parameter m_soonExpiredTimespanMonths = new IntegerParameter("com.arsdigita.cms.soon_expired_timespan_months", 1, (Object)new Integer(1));
    private final Parameter m_unpublishedNotFound = new BooleanParameter("com.arsdigita.cms.unpublished_not_found", 1, (Object)Boolean.TRUE);
    private final Parameter m_linksOnlyInSameSubsite = new BooleanParameter("com.arsdigita.cms.browse_links_in_same_subsite_only", 1, (Object)Boolean.FALSE);
    private final Parameter m_categoryAuthoringExtension = new SpecificClassParameter("com.arsdigita.cms.category_authoring_extension", 1, ItemCategoryExtension.class, ItemCategoryExtension.class);
    private final Parameter m_hideResetLifecycleLink = new BooleanParameter("com.arsdigita.cms.hide_reset_lifecycle_link", 0, (Object)Boolean.TRUE);
    private final Parameter m_scoreTitleAndKeywords = new BooleanParameter("com.arsdigita.cms.search.score_title_and_keywords", 0, (Object)Boolean.FALSE);
    private final Parameter m_titleWeight = new IntegerParameter("com.arsdigita.cms.search.intermedia.title_weight", 0, (Object)new Integer(1));
    private final Parameter m_keywordWeight = new IntegerParameter("com.arsdigita.cms.search.intermedia.keyword_weight", 0, (Object)new Integer(1));
    private final Parameter m_limitToContentSection = new BooleanParameter("com.arsdigita.cms.search.limitToContentSection", 0, (Object)Boolean.TRUE);
    private final Parameter m_skipAssetSteps = new StringArrayParameter("com.arsdigita.cms.skip_asset_steps", 0, null);
    private final Parameter m_mandatoryDescriptions = new BooleanParameter("com.arsdigita.cms.mandatory_descriptions", 0, (Object)Boolean.FALSE);
    private final Parameter m_deleteLifecycleWhenComplete = new BooleanParameter("com.arsdigita.cms.delete_lifecycle_when_complete", 0, (Object)Boolean.FALSE);
    private final Parameter m_hasContactsAuthoringStep = new BooleanParameter("com.arsdigita.cms.has_contacts_authoring_step", 1, (Object)Boolean.FALSE);
    private final Parameter m_categoryTreeOrdering = new EnumerationParameter("com.arsdigita.cms.category_tree_order", 0, (Object)"sortKey");
    private final Parameter m_allowCategoryCreateUseContext = new BooleanParameter("com.arsdigita.cms.allow_category_create_use_context", 1, (Object)Boolean.FALSE);
    private final Parameter m_allowContentCreateInSectionListing = new BooleanParameter("com.arsdigita.cms.allow_content_create_in_section_listing", 1, (Object)Boolean.TRUE);
    private final Parameter m_hideLegacyPublicSiteLink = new BooleanParameter("com.arsdigita.cms.hide_legacy_public_site_link", 1, (Object)Boolean.TRUE);
    private final Parameter m_deleteWorkflowNotificationsWhenSent = new BooleanParameter("com.arsdigita.cms.delete_workflow_notification_when_sent", 0, (Object)Boolean.FALSE);
    private final Parameter m_deleteExpiryNotificationsWhenSent = new BooleanParameter("com.arsdigita.cms.delete_expiry_notification_when_sent", 0, (Object)Boolean.FALSE);
    private final Parameter m_defaultNotificationTime = new IntegerParameter("com.arsdigita.cms.default_notification_time", 1, (Object)new Integer(0));
    private final Parameter m_notifyAuthorOnLifecycle = new BooleanParameter("com.arsdigita.cms.notify_author_on_lifecycle", 0, (Object)Boolean.TRUE);
    private final StringParameter m_contentCenterMap = new StringParameter("com.arsdigita.cms.loader.content_center_map", 1, (Object)"/WEB-INF/resources/content-center-map.xml");
    private final Parameter m_defaultItemResolverClass = new SpecificClassParameter("com.arsdigita.cms.default_item_resolver_class", 1, MultilingualItemResolver.class, ItemResolver.class);
    private final Parameter m_defaultTemplateResolverClass = new SpecificClassParameter("com.arsdigita.cms.default_template_resolver_class", 1, DefaultTemplateResolver.class, TemplateResolver.class);
    private final Parameter m_itemSearchDefaultTab = new StringParameter("com.arsdigita.cms.item_search.default_tab", 1, (Object)"flatBrowse");
    private final Parameter m_itemSearchFlatBrowsePanePageSize = new IntegerParameter("com.arsdigita.cms.item_search.flat_browse_pane.page_size", 1, (Object)20);
    private final Parameter m_folderBrowseListSize = new IntegerParameter("com.arsdigita.cms.folder_browse_list_size", 1, (Object)20);
    private final Parameter m_folderAtoZShowLimit = new IntegerParameter("com.arsdigita.cms.folder_atoz_show_limit", 1, (Object)100);
    private final Parameter m_useOldStyleItemLifecycleItemPane = new BooleanParameter("com.arsdigita.cms.lifecycle.use_old_style_item_lifecycle_item_pane", 1, (Object)false);
    private final Parameter m_threadPublishing = new BooleanParameter("com.arsdigita.cms.lifecycle.threaded_publishing", 1, (Object)true);
    private final Parameter m_publishingFailureSender = new StringParameter("cms.arsdigita.cms.lifecycle.threaded_publishing.notify_on_error.from", 1, (Object)"");
    private final Parameter m_publishingFailureReceiver = new StringParameter("cms.arsdigita.cms.lifecycle.threaded_publishing.notify_on_error.to", 1, (Object)"");
    private final Parameter m_imageBrowserThumbnailMaxWidth = new IntegerParameter("com.arsdigita.cms.image_browser.thumbnail_max_width", 1, (Object)50);
    private final Parameter m_imageBrowserThumbnailMaxHeight = new IntegerParameter("com.arsdigita.cms.image_browser.thumbnail_max_height", 1, (Object)50);
    private final Parameter m_attachPersonOrgaUnitsStep = new BooleanParameter("com.arsdigita.cms.contenttypes.genericperson.attach_person_orgaunits_step", 1, (Object)Boolean.TRUE);
    protected static HashMap extraXMLGenerators;

    public static synchronized CMSConfig getInstance() {
        if (s_config == null) {
            s_config = new CMSConfig();
            s_config.load();
        }
        return s_config;
    }

    public CMSConfig() {
        ((EnumerationParameter)this.m_categoryTreeOrdering).put("SortKey", (Object)"sortKey");
        ((EnumerationParameter)this.m_categoryTreeOrdering).put("Alphabetical", (Object)"name");
        this.register(this.m_templateRootPath);
        this.register(this.m_defaultItemTemplatePath);
        this.register(this.m_defaultFolderTemplatePath);
        this.register(this.m_categoryAuthoringAddForm);
        this.register(this.m_itemAdapters);
        this.register(this.m_useStreamlinedCreation);
        this.register(this.m_dhtmlEditorConfig);
        this.register(this.m_dhtmlEditorPlugins);
        this.register(this.m_dhtmlEditorHiddenButtons);
        this.register(this.m_hideTemplatesTab);
        this.register(this.m_hideAdminTabs);
        this.register(this.m_hideTimezone);
        this.register(this.m_hideLaunchDate);
        this.register(this.m_requireLaunchDate);
        this.register(this.m_hideUDCTUI);
        this.register(this.m_hideFolderIndexCheckbox);
        this.register(this.m_defaultNotificationTime);
        this.register(this.m_publishLifecycleListenerClass);
        this.register(this.m_notifyAuthorOnLifecycle);
        this.register(this.m_saveTextCleansWordTags);
        this.register(this.m_hideAdditionalResourceFields);
        this.register(this.m_disableFileAssetExtraction);
        this.register(this.m_deleteWorkflowAfterPublication);
        this.register(this.m_soonExpiredTimespanMonths);
        this.register(this.m_soonExpiredTimespanDays);
        this.register(this.m_unpublishedNotFound);
        this.register(this.m_linksOnlyInSameSubsite);
        this.register(this.m_categoryAuthoringExtension);
        this.register(this.m_hideResetLifecycleLink);
        this.register(this.m_keywordWeight);
        this.register(this.m_limitToContentSection);
        this.register(this.m_titleWeight);
        this.register(this.m_scoreTitleAndKeywords);
        this.register(this.m_skipAssetSteps);
        this.register(this.m_mandatoryDescriptions);
        this.register(this.m_deleteLifecycleWhenComplete);
        this.register(this.m_deleteExpiryNotificationsWhenSent);
        this.register(this.m_deleteWorkflowNotificationsWhenSent);
        this.register(this.m_categoryTreeOrdering);
        this.register(this.m_hasContactsAuthoringStep);
        this.register(this.m_hideTextAssetUploadFile);
        this.register(this.m_allowCategoryCreateUseContext);
        this.register(this.m_allowContentCreateInSectionListing);
        this.register(this.m_hideLegacyPublicSiteLink);
        this.register((Parameter)this.m_contentCenterMap);
        this.register(this.m_defaultItemResolverClass);
        this.register(this.m_defaultTemplateResolverClass);
        this.register(this.m_itemSearchDefaultTab);
        this.register(this.m_folderBrowseListSize);
        this.register(this.m_folderAtoZShowLimit);
        this.register(this.m_useOldStyleItemLifecycleItemPane);
        this.register(this.m_threadPublishing);
        this.register(this.m_publishingFailureSender);
        this.register(this.m_publishingFailureReceiver);
        this.register(this.m_imageBrowserThumbnailMaxWidth);
        this.register(this.m_imageBrowserThumbnailMaxHeight);
        this.register(this.m_itemSearchFlatBrowsePanePageSize);
        this.register(this.m_attachPersonOrgaUnitsStep);
        this.loadInfo();
    }

    public final String getTemplateRoot() {
        return (String)this.get(this.m_templateRootPath);
    }

    public final String getDefaultItemTemplatePath() {
        return (String)this.get(this.m_defaultItemTemplatePath);
    }

    public final String getDefaultFolderTemplatePath() {
        return (String)this.get(this.m_defaultFolderTemplatePath);
    }

    public final Class getDefaultItemResolverClass() {
        return (Class)this.get(this.m_defaultItemResolverClass);
    }

    public final Class getDefaultTemplateResolverClass() {
        return (Class)this.get(this.m_defaultTemplateResolverClass);
    }

    public final Class getCategoryAuthoringAddForm() {
        return (Class)this.get(this.m_categoryAuthoringAddForm);
    }

    public final InputStream getItemAdapters() {
        return (InputStream)this.get(this.m_itemAdapters);
    }

    public final String getDefaultContentSection() {
        return ContentSection.getDefaultSection().getName();
    }

    public final boolean getUseStreamlinedCreation() {
        return (Boolean)this.get(this.m_useStreamlinedCreation);
    }

    public final DHTMLEditor.Config getDHTMLEditorConfig() {
        return (DHTMLEditor.Config)this.get(this.m_dhtmlEditorConfig);
    }

    public final String[] getDHTMLEditorPlugins() {
        return (String[])this.get(this.m_dhtmlEditorPlugins);
    }

    public final String[] getDHTMLEditorHiddenButtons() {
        return (String[])this.get(this.m_dhtmlEditorHiddenButtons);
    }

    public final boolean getHideTemplatesTab() {
        return (Boolean)this.get(this.m_hideTemplatesTab);
    }

    public final boolean getHideAdminTabs() {
        return (Boolean)this.get(this.m_hideAdminTabs);
    }

    public final boolean getHideTimezone() {
        return (Boolean)this.get(this.m_hideTimezone);
    }

    public final boolean getHideLaunchDate() {
        return (Boolean)this.get(this.m_hideLaunchDate);
    }

    public final boolean getRequireLaunchDate() {
        return (Boolean)this.get(this.m_requireLaunchDate);
    }

    public final boolean getHideUDCTUI() {
        return (Boolean)this.get(this.m_hideUDCTUI);
    }

    public final boolean getHideFolderIndexCheckbox() {
        return (Boolean)this.get(this.m_hideFolderIndexCheckbox);
    }

    public final int getDefaultNotificationTime() {
        return (Integer)this.get(this.m_defaultNotificationTime);
    }

    public final String getPublishLifecycleListenerClass() {
        return (String)this.get(this.m_publishLifecycleListenerClass);
    }

    public final boolean getNotifyAuthorOnLifecycle() {
        return (Boolean)this.get(this.m_notifyAuthorOnLifecycle);
    }

    public final boolean getSaveTextCleansWordTags() {
        return (Boolean)this.get(this.m_saveTextCleansWordTags);
    }

    public final boolean isHideAdditionalResourceFields() {
        return (Boolean)this.get(this.m_hideAdditionalResourceFields);
    }

    public final boolean getDisableFileAssetExtraction() {
        return (Boolean)this.get(this.m_disableFileAssetExtraction);
    }

    public final boolean getDeleteWorkflowAfterPublication() {
        return (Boolean)this.get(this.m_deleteWorkflowAfterPublication);
    }

    public final boolean getLinksOnlyInSameSubsite() {
        return (Boolean)this.get(this.m_linksOnlyInSameSubsite);
    }

    public final int getSoonExpiredMonths() {
        return (Integer)this.get(this.m_soonExpiredTimespanMonths);
    }

    public final int getSoonExpiredDays() {
        return (Integer)this.get(this.m_soonExpiredTimespanDays);
    }

    public final boolean isUnpublishedNotFound() {
        return (Boolean)this.get(this.m_unpublishedNotFound);
    }

    public final Class getCategoryAuthoringExtension() {
        return (Class)this.get(this.m_categoryAuthoringExtension);
    }

    public final boolean getDisableItemPfs() {
        return PublishToFileConfig.getConfig().isItemPfsDisabled();
    }

    public final Class getPublishToFileClass() {
        return PublishToFileConfig.getConfig().getPublishListenerClass();
    }

    public String getContentCenterMap() {
        return (String)this.get((Parameter)this.m_contentCenterMap);
    }

    public static void registerExtraXMLGenerator(String type, ExtraXMLGenerator gen) {
        LinkedList gens = (LinkedList)extraXMLGenerators.get(type);
        if (gens == null) {
            gens = new LinkedList();
            extraXMLGenerators.put(type, gens);
        }
        gens.add(gen.getClass());
    }

    public static Iterator getExtraXMLGeneratorsIterator() {
        return extraXMLGenerators.entrySet().iterator();
    }

    public final boolean hideResetLifecycleLink() {
        return (Boolean)this.get(this.m_hideResetLifecycleLink);
    }

    public Integer getKeywordSearchWeight() {
        return (Integer)this.get(this.m_keywordWeight);
    }

    public final boolean limitToContentSection() {
        return (Boolean)this.get(this.m_limitToContentSection);
    }

    public Integer getTitleSearchWeight() {
        return (Integer)this.get(this.m_titleWeight);
    }

    public boolean scoreKeywordsAndTitle() {
        return (Boolean)this.get(this.m_scoreTitleAndKeywords);
    }

    public Collection getAssetStepsToSkip(ContentType type) {
        Object skipSteps;
        s_log.debug((Object)("getting asset steps to skip for type " + type.getClassName()));
        if (s_skipAssetSteps == null) {
            s_log.debug((Object)"loading skipsteps");
            s_skipAssetSteps = new HashMap();
            skipSteps = (String[])this.get(this.m_skipAssetSteps);
            if (skipSteps != null) {
                s_log.debug((Object)(((String[])skipSteps).length + " entries in parameter"));
                for (int i = 0; i < ((String[])skipSteps).length; ++i) {
                    String[] pair = StringUtils.split((String)skipSteps[i], (char)':');
                    s_log.debug((Object)("parameter read - type = " + pair[0] + " - step = " + pair[1]));
                    HashSet<String> typeSteps = (HashSet<String>)s_skipAssetSteps.get(pair[0]);
                    if (typeSteps == null) {
                        typeSteps = new HashSet<String>();
                        s_skipAssetSteps.put(pair[0], typeSteps);
                    }
                    typeSteps.add(pair[1]);
                }
            }
        }
        if ((skipSteps = (String[])s_skipAssetSteps.get(type.getClassName())) == null) {
            s_log.debug((Object)"no steps to skip");
            skipSteps = new HashSet();
        }
        return skipSteps;
    }

    public boolean mandatoryDescriptions() {
        return (Boolean)this.get(this.m_mandatoryDescriptions);
    }

    public boolean deleteFinishedLifecycles() {
        return (Boolean)this.get(this.m_deleteLifecycleWhenComplete);
    }

    public boolean deleteExpiryNotifications() {
        return (Boolean)this.get(this.m_deleteExpiryNotificationsWhenSent);
    }

    public boolean deleteWorkflowNotifications() {
        return (Boolean)this.get(this.m_deleteWorkflowNotificationsWhenSent);
    }

    public String getCategoryTreeOrder() {
        return (String)this.get(this.m_categoryTreeOrdering);
    }

    public boolean getHasContactsAuthoringStep() {
        return (Boolean)this.get(this.m_hasContactsAuthoringStep);
    }

    public final boolean getHideTextAssetUploadFile() {
        return (Boolean)this.get(this.m_hideTextAssetUploadFile);
    }

    public final boolean getAllowCategoryCreateUseContext() {
        return (Boolean)this.get(this.m_allowCategoryCreateUseContext);
    }

    public final boolean getAllowContentCreateInSectionListing() {
        return (Boolean)this.get(this.m_allowContentCreateInSectionListing);
    }

    public final boolean getHideLegacyPublicSiteLink() {
        return (Boolean)this.get(this.m_hideLegacyPublicSiteLink);
    }

    public String getItemSearchDefaultTab() {
        return (String)this.get(this.m_itemSearchDefaultTab);
    }

    public Integer getFolderBrowseListSize() {
        return (Integer)this.get(this.m_folderBrowseListSize);
    }

    public Integer getFolderAtoZShowLimit() {
        return (Integer)this.get(this.m_folderAtoZShowLimit);
    }

    public Boolean getUseOldStyleItemLifecycleItemPane() {
        return (Boolean)this.get(this.m_useOldStyleItemLifecycleItemPane);
    }

    public Boolean getThreadedPublishing() {
        return (Boolean)this.get(this.m_threadPublishing);
    }

    public String getPublicationFailureSender() {
        return (String)this.get(this.m_publishingFailureSender);
    }

    public String getPublicationFailureReceiver() {
        return (String)this.get(this.m_publishingFailureReceiver);
    }

    public Integer getImageBrowserThumbnailMaxWidth() {
        return (Integer)this.get(this.m_imageBrowserThumbnailMaxWidth);
    }

    public Integer getImageBrowserThumbnailMaxHeight() {
        return (Integer)this.get(this.m_imageBrowserThumbnailMaxHeight);
    }

    public Integer getItemSearchFlatBrowsePanePageSize() {
        return (Integer)this.get(this.m_itemSearchFlatBrowsePanePageSize);
    }

    public Boolean getAttachPersonOrgaUnitsStep() {
        return (Boolean)this.get(this.m_attachPersonOrgaUnitsStep);
    }

    static {
        s_skipAssetSteps = null;
        extraXMLGenerators = new HashMap();
    }

    private class DHTMLEditorConfigParameter
    extends StringParameter {
        public DHTMLEditorConfigParameter(String name, int multiplicity, Object defaultObj) {
            super(name, multiplicity, defaultObj);
        }

        protected Object unmarshal(String value, ErrorList errors) {
            return DHTMLEditor.Config.valueOf((String)value);
        }
    }
}

