/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.util.Assert;
import org.apache.log4j.Logger;

public final class CMSContext {
    private static final Logger s_log = Logger.getLogger(CMSContext.class);
    private ContentSection m_section = null;
    private ContentItem m_item = null;
    private SecurityManager m_security = null;

    CMSContext() {
    }

    public final String getDebugInfo() {
        String info = "Current state of " + this + ":\n" + "           getContentSection() -> " + (Object)((Object)this.getContentSection()) + "\n" + "              getContentItem() -> " + this.getContentItem() + "\n" + "          getSecurityManager() -> " + this.getSecurityManager();
        return info;
    }

    final CMSContext copy() {
        CMSContext result = new CMSContext();
        result.m_section = this.m_section;
        result.m_item = this.m_item;
        result.m_security = this.m_security;
        return result;
    }

    public final boolean hasContentSection() {
        return this.m_section != null;
    }

    public final ContentSection getContentSection() {
        return this.m_section;
    }

    public final void setContentSection(ContentSection section) {
        this.m_section = section;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Content section set to " + (Object)((Object)section)));
        }
    }

    public final boolean hasContentItem() {
        return this.m_item != null;
    }

    public final ContentItem getContentItem() {
        if (s_log.isDebugEnabled() && this.m_item == null) {
            s_log.debug((Object)"Content item is null");
        }
        return this.m_item;
    }

    public final void setContentItem(ContentItem item) {
        this.m_item = item;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Content item set to " + item));
        }
    }

    public final boolean hasSecurityManager() {
        return this.m_security != null;
    }

    public final SecurityManager getSecurityManager() {
        Assert.exists((Object)this.m_security, SecurityManager.class);
        return this.m_security;
    }

    public final void setSecurityManager(SecurityManager security) {
        this.m_security = security;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Security manager set to " + security));
        }
    }
}

