/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.categorization.Category;
import com.arsdigita.cms.CategoryTemplateCollection;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.Template;
import com.arsdigita.cms.TemplateMapping;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;

public class CategoryTemplateMapping
extends TemplateMapping {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.CategoryTemplateMapping";
    public static final String CATEGORY = "category";
    public static final String SECTION = "contentSection";
    public static final String CONTENT_TYPE = "contentType";

    public CategoryTemplateMapping() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public CategoryTemplateMapping(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public CategoryTemplateMapping(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public CategoryTemplateMapping(DataObject obj) {
        super(obj);
    }

    public CategoryTemplateMapping(String type) {
        super(type);
    }

    @Override
    public final ContentSection getContentSection() {
        return (ContentSection)DomainObjectFactory.newInstance((DataObject)((DataObject)this.get(SECTION)));
    }

    public final void setContentSection(ContentSection sec) {
        Assert.exists((Object)((Object)sec));
        this.setAssociation(SECTION, (DomainObject)sec);
    }

    public Category getCategory() {
        return (Category)DomainObjectFactory.newInstance((DataObject)((DataObject)this.get(CATEGORY)));
    }

    public void setCategory(Category cat) {
        Assert.exists((Object)cat);
        this.setAssociation(CATEGORY, (DomainObject)cat);
    }

    @Override
    public ACSObject getParent() {
        return this.getContentType();
    }

    public ContentType getContentType() {
        DataObject obj = (DataObject)this.get(CONTENT_TYPE);
        if (obj == null) {
            return null;
        }
        return (ContentType)DomainObjectFactory.newInstance((DataObject)obj);
    }

    public void setContentType(ContentType t) {
        Assert.exists((Object)((Object)t));
        this.setAssociation(CONTENT_TYPE, (DomainObject)t);
    }

    @Override
    public Boolean isDefault() {
        return (Boolean)this.get("isDefault");
    }

    @Override
    public void setDefault(Boolean b) {
        Assert.exists((Object)b);
        this.set("isDefault", b);
    }

    public static CategoryTemplateMapping getMapping(Category category, ContentType type, Template template, String useContext) {
        CategoryTemplateCollection c = CategoryTemplateMapping.getTemplates(category, type, useContext);
        c.addEqualsFilter("template.id", template.getID());
        if (!c.next()) {
            return null;
        }
        CategoryTemplateMapping m = (CategoryTemplateMapping)c.getDomainObject();
        Assert.isTrue((!c.next() ? 1 : 0) != 0);
        c.close();
        return m;
    }

    public static Template getDefaultTemplate(Category category, ContentType type, String useContext) {
        CategoryTemplateCollection c = CategoryTemplateMapping.getTemplates(category, type, useContext);
        c.addEqualsFilter("isDefault", new Boolean(true));
        if (!c.next()) {
            return null;
        }
        CategoryTemplateMapping m = (CategoryTemplateMapping)c.getDomainObject();
        Assert.isTrue((!c.next() ? 1 : 0) != 0);
        c.close();
        return m.getTemplate();
    }

    public static CategoryTemplateCollection getTemplates(Category category, ContentType type, String useContext) {
        CategoryTemplateCollection c = CategoryTemplateMapping.getTemplates(category, type);
        c.addEqualsFilter("useContext", useContext);
        return c;
    }

    public static CategoryTemplateCollection getTemplates(Category category, ContentType type) {
        CategoryTemplateCollection c = CategoryTemplateMapping.getTemplates(category);
        c.addEqualsFilter("contentType.id", type.getID());
        return c;
    }

    public static CategoryTemplateCollection getTemplates(Category category) {
        DataCollection da = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        CategoryTemplateCollection c = new CategoryTemplateCollection(da);
        c.addEqualsFilter("category.id", category.getID());
        c.addOrder("contentType.label");
        c.addOrder("useContext");
        c.addOrder("template.name");
        return c;
    }
}

