/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ContentTypeWorkflowTemplate;
import com.arsdigita.cms.CustomCopy;
import com.arsdigita.cms.ItemCollection;
import com.arsdigita.cms.ItemCopier;
import com.arsdigita.cms.lifecycle.Lifecycle;
import com.arsdigita.cms.lifecycle.LifecycleDefinition;
import com.arsdigita.cms.util.LanguageUtil;
import com.arsdigita.domain.AbstractDomainObjectObserver;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectObserver;
import com.arsdigita.globalization.GlobalizationHelper;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Web;
import com.arsdigita.workflow.simple.Workflow;
import com.arsdigita.workflow.simple.WorkflowTemplate;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ContentBundle
extends ContentItem {
    private static final Logger s_log = Logger.getLogger(ContentBundle.class);
    private static DomainObjectObserver s_instancesObserver = new AbstractDomainObjectObserver(){

        public void add(DomainObject dom, String name, DataObject dobj) {
            if (ContentBundle.INSTANCES.equals(name) && dobj != null) {
                PermissionService.setContext((OID)dobj.getOID(), (OID)dom.getOID());
            }
        }
    };
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.ContentBundle";
    public static final String INSTANCES = "instances";
    public static final String ATOZ_ALIASING_PROVIDERS = "atozAliasingProviders";
    public static final String DEFAULT_LANGUAGE = "defaultLanguage";
    private boolean m_wasNew = false;

    @Override
    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public ContentBundle(ContentItem primary) {
        super(BASE_DATA_OBJECT_TYPE);
        Assert.exists((Object)primary, ContentItem.class);
        this.setDefaultLanguage(primary.getLanguage());
        this.setContentType(primary.getContentType());
        this.addInstance(primary);
        super.setName(primary.getName());
    }

    public ContentBundle(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public ContentBundle(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public ContentBundle(DataObject object) {
        super(object);
    }

    public ContentBundle(String type) {
        super(type);
    }

    @Override
    protected ContentItem makeCopy() {
        ContentBundle newItem = (ContentBundle)super.makeCopy();
        WorkflowTemplate template = ContentTypeWorkflowTemplate.getWorkflowTemplate(newItem.getContentSection(), newItem.getContentType());
        if (template != null) {
            s_log.debug((Object)"Setting up new workflow template");
            ItemCollection instances = this.getInstances();
            while (instances.next()) {
                ContentItem instance = instances.getContentItem();
                s_log.debug((Object)("Item id is: " + instance.getID()));
                Workflow workflow = template.instantiateNewWorkflow();
                workflow.setObjectID(instance.getID());
                workflow.start(Web.getContext().getUser());
                workflow.save();
            }
        }
        return newItem;
    }

    public final String getDefaultLanguage() {
        return (String)this.get(DEFAULT_LANGUAGE);
    }

    public final void setDefaultLanguage(String language) {
        if (Assert.isEnabled()) {
            Assert.exists((Object)language, String.class);
            Assert.isTrue((language.length() == 2 ? 1 : 0) != 0, (String)(language + " is not an ISO639 language code"));
        }
        this.set(DEFAULT_LANGUAGE, language);
    }

    public void addInstance(ContentItem instance) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Adding " + instance + " to bundle " + this));
        }
        if (Assert.isEnabled()) {
            Assert.exists((Object)instance, ContentItem.class);
            Assert.isFalse((boolean)this.hasInstance(instance.getLanguage()), (String)("The bundle already contains an instance for the language " + instance.getLanguage()));
        }
        instance.setParent((ACSObject)this);
        instance.setContentSection(this.getContentSection());
        if (Assert.isEnabled()) {
            Assert.isEqual((Object)this, (Object)instance.getParent());
        }
    }

    public void removeInstance(ContentItem instance) {
        if (Assert.isEnabled()) {
            Assert.exists((Object)instance, ContentItem.class);
            Assert.isEqual((Object)this, (Object)instance.getParent());
            Assert.isNotEqual((Object)instance, (Object)this.getPrimaryInstance());
        }
        instance.setParent(null);
        if (Assert.isEnabled()) {
            Assert.isTrue((instance.getParent() == null ? 1 : 0) != 0);
        }
    }

    public final ContentItem getPrimaryInstance() {
        return this.getInstance(this.getDefaultLanguage());
    }

    public final ItemCollection getInstances() {
        return new ItemCollection((DataCollection)this.instances());
    }

    public final ContentItem getInstance(Locale locale) {
        return this.getInstance(locale.getLanguage(), false);
    }

    public final ContentItem getInstance(Locale locale, boolean allowLanguageIndependent) {
        return this.getInstance(locale.getLanguage(), allowLanguageIndependent);
    }

    public final ContentItem getInstance(String language) {
        return this.getInstance(language, Kernel.getConfig().languageIndependentItems());
    }

    public final ContentItem getInstance(String language, boolean allowLanguageIndependent) {
        if (Assert.isEnabled()) {
            Assert.exists((Object)language, String.class);
            Assert.isTrue((language.length() == 2 ? 1 : 0) != 0, (String)(language + " does not look like a valid language " + "code"));
        }
        ContentItem contentItem = null;
        DataAssociationCursor instances = this.instances();
        instances.addEqualsFilter("language", (Object)language);
        if (instances.next()) {
            contentItem = (ContentItem)DomainObjectFactory.newInstance((DataObject)instances.getDataObject());
        }
        instances.close();
        if (contentItem == null && allowLanguageIndependent) {
            contentItem = this.getInstance(GlobalizationHelper.LANG_INDEPENDENT, false);
        }
        return contentItem;
    }

    public final boolean hasInstance(ContentItem instance) {
        Assert.exists((Object)instance, ContentItem.class);
        DataAssociationCursor instances = this.instances();
        instances.addEqualsFilter("id", (Object)instance.getID());
        return !instances.isEmpty();
    }

    public final boolean hasInstance(String language) {
        return this.hasInstance(language, false);
    }

    public final boolean hasInstance(String language, boolean allowLanguageIndependent) {
        if (Assert.isEnabled()) {
            Assert.exists((Object)language, String.class);
            Assert.isTrue((language.length() == 2 ? 1 : 0) != 0, (String)(language + " is not an ISO639 language code"));
        }
        DataAssociationCursor instances = this.instances();
        if (!allowLanguageIndependent) {
            instances.addEqualsFilter("language", (Object)language);
        } else {
            instances.addFilter(String.format("(%s = '%s' or %s = '%s')", "language", language, "language", GlobalizationHelper.LANG_INDEPENDENT));
        }
        return !instances.isEmpty();
    }

    public final Collection<String> getLanguages() {
        ItemCollection items = this.getInstances();
        ArrayList<String> list = new ArrayList<String>();
        while (items.next()) {
            list.add(items.getLanguage());
        }
        items.close();
        if (Assert.isEnabled()) {
            Assert.isTrue((!list.isEmpty() || this.getInstances().isEmpty() ? 1 : 0) != 0);
        }
        return list;
    }

    @Deprecated
    public ContentItem negotiate(Locale[] locales) {
        Assert.exists((Object)locales);
        String supportedLanguages = LanguageUtil.getSupportedLanguages();
        DataAssociationCursor instancesCursor = this.instances();
        DataObject dataObject = null;
        int bestMatch = 0;
        DataObject matchingInstance = null;
        String language = null;
        while (instancesCursor.next()) {
            dataObject = instancesCursor.getDataObject();
            language = (String)dataObject.get("language");
            if (!supportedLanguages.contains(language)) continue;
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("negotiate: language= " + language));
            }
            if (language != null) {
                if (language.equals("--") && matchingInstance == null) {
                    bestMatch = locales.length;
                    matchingInstance = dataObject;
                } else {
                    for (int i = 0; i < locales.length; ++i) {
                        if (!language.equals(locales[i].getLanguage()) || i >= bestMatch && matchingInstance != null) continue;
                        bestMatch = i;
                        matchingInstance = dataObject;
                        if (!s_log.isDebugEnabled()) continue;
                        s_log.debug((Object)("negotiate: bestMatch= " + i + ", language= " + language));
                    }
                }
            }
            if (bestMatch != 0 || matchingInstance == null) continue;
            s_log.debug((Object)"negotiate: best possible match found, exiting");
            break;
        }
        instancesCursor.close();
        if (matchingInstance != null) {
            return (ContentItem)DomainObjectFactory.newInstance(matchingInstance);
        }
        s_log.info((Object)"negotiate: no match found!");
        return null;
    }

    @Deprecated
    public ContentItem negotiate(Enumeration locales) {
        String supportedLanguages = LanguageUtil.getSupportedLanguages();
        Assert.exists((Object)locales);
        Locale loc = null;
        ArrayList<String> languageCodes = new ArrayList<String>();
        int i = 0;
        while (locales.hasMoreElements()) {
            loc = (Locale)locales.nextElement();
            if (supportedLanguages.contains(loc.getLanguage())) {
                languageCodes.add(loc.getLanguage());
            }
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("negotiate: pref " + i + ": " + loc.getLanguage()));
            }
            ++i;
        }
        if (supportedLanguages.contains("--")) {
            languageCodes.add("--");
        }
        DataAssociationCursor instances = this.instances();
        DataObject dataObject = null;
        int bestMatch = 0;
        DataObject match = null;
        String language = null;
        while (instances.next()) {
            dataObject = instances.getDataObject();
            language = (String)dataObject.get("language");
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("negotiate: language= " + language));
            }
            if (language != null) {
                for (int i2 = 0; i2 < languageCodes.size(); ++i2) {
                    if (!language.equals((String)languageCodes.get(i2)) || i2 >= bestMatch && match != null) continue;
                    bestMatch = i2;
                    match = dataObject;
                    if (!s_log.isDebugEnabled()) continue;
                    s_log.debug((Object)("negotiate: bestMatch= " + i2 + ", language= " + language));
                }
            }
            if (bestMatch != 0 || match == null) continue;
            s_log.debug((Object)"negotiate: best possible match found, exiting");
            break;
        }
        instances.close();
        return (ContentItem)DomainObjectFactory.newInstance(match);
    }

    @Override
    protected void beforeSave() {
        super.beforeSave();
        ContentItem primary = this.getPrimaryInstance();
        Assert.exists((Object)((Object)this.getContentType()), ContentType.class);
        if (primary != null) {
            primary.setContentSection(this.getContentSection());
        }
    }

    @Override
    protected boolean canPublishToFS() {
        return false;
    }

    @Override
    protected void publishToFS() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ContentItem publish(LifecycleDefinition definition, Date start) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Lifecycle getLifecycle() {
        return null;
    }

    @Override
    public void setLifecycle(Lifecycle lifecycle) {
    }

    @Override
    public boolean copyProperty(CustomCopy source, Property property, ItemCopier copier) {
        if (copier.getCopyType() == 1) {
            if (INSTANCES.equals(property.getName())) {
                return true;
            }
            if (ATOZ_ALIASING_PROVIDERS.equals(property.getName())) {
                return true;
            }
        }
        return super.copyProperty(source, property, copier);
    }

    @Override
    public boolean copyServices(ContentItem source) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Copying services on bundle " + this.getName() + " " + this.getID() + " using source " + source.getID()));
        }
        CategoryCollection categories = source.getCategoryCollection();
        while (categories.next()) {
            Category category = categories.getCategory();
            category.addChild((ACSObject)this, categories.getSortKey());
            category.save();
        }
        categories.close();
        return true;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.addObserver(s_instancesObserver);
        this.m_wasNew = this.isNew();
    }

    protected void afterSave() {
        if (this.m_wasNew) {
            this.getPrimaryInstance().setContentSection(this.getContentSection());
        }
        super.afterSave();
    }

    private DataAssociationCursor instances() {
        DataAssociationCursor cursor = ((DataAssociation)super.get(INSTANCES)).cursor();
        return cursor;
    }

    private DataAssociationCursor instances(String version) {
        DataAssociationCursor cursor = this.instances();
        cursor.addEqualsFilter("version", (Object)version);
        return cursor;
    }
}

