/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.RelationAttributeCollection;
import com.arsdigita.cms.RelationAttributeInterface;
import com.arsdigita.cms.contenttypes.GenericAddress;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectTraversal;
import com.arsdigita.domain.DomainObjectTraversalAdapter;
import com.arsdigita.domain.DomainObjectXMLRenderer;
import com.arsdigita.globalization.GlobalizationHelper;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.xml.Element;
import org.apache.log4j.Logger;

public class ContentItemXMLRenderer
extends DomainObjectXMLRenderer {
    private static final Logger logger = Logger.getLogger(ContentItemXMLRenderer.class);
    private String m_propertyName = "";
    private String m_keyName = "";
    private String m_relationAttribute = "";

    public ContentItemXMLRenderer(Element root) {
        super(root);
    }

    protected void walk(DomainObjectTraversalAdapter adapter, DomainObject obj, String path, String context, DomainObject linkObject) {
        Object nObj = obj;
        if (nObj instanceof ContentBundle) {
            nObj = ((ContentBundle)obj).getInstance(GlobalizationHelper.getNegotiatedLocale(), true);
        }
        super.walk(adapter, nObj, path, context, linkObject);
    }

    protected void handleAttribute(DomainObject obj, String path, Property property) {
        String propertyName = property.getName();
        if (obj instanceof GenericAddress && propertyName.equals("isoCountryCode")) {
            super.handleAttribute(obj, path, property);
            Element element = this.newElement(this.m_element, "country");
            element.setText(GenericAddress.getCountryNameFromIsoCode(((GenericAddress)obj).getIsoCountryCode()));
            return;
        }
        if (!this.m_relationAttribute.isEmpty()) {
            String key = "";
            if (obj instanceof RelationAttributeInterface && ((RelationAttributeInterface)obj).hasRelationAttributeProperty(propertyName)) {
                RelationAttributeInterface relationAttributeObject = (RelationAttributeInterface)obj;
                key = relationAttributeObject.getRelationAttributeKey(propertyName);
            }
            if (obj instanceof DomainObjectTraversal.LinkDomainObject && propertyName.equals(this.m_keyName)) {
                key = (String)((DomainObjectTraversal.LinkDomainObject)obj).get(this.m_keyName);
            }
            if (!key.isEmpty()) {
                logger.debug((Object)String.format("Getting relation attribute value for key '%s' of relation attribute '%s'", key, this.m_relationAttribute));
                RelationAttributeCollection relationAttributeCollection = new RelationAttributeCollection(this.m_relationAttribute, key);
                relationAttributeCollection.addLanguageFilter(GlobalizationHelper.getNegotiatedLocale().getLanguage());
                if (relationAttributeCollection.size() > 0L) {
                    relationAttributeCollection.next();
                    Element element = this.newElement(this.m_element, this.m_keyName);
                    element.setText(relationAttributeCollection.getName());
                    Element elementId = this.newElement(this.m_element, this.m_keyName + "Id");
                    elementId.setText(relationAttributeCollection.getKey());
                    relationAttributeCollection.close();
                }
                return;
            }
        }
        super.handleAttribute(obj, path, property);
    }

    protected void beginAssociation(DomainObject obj, String path, Property property) {
        super.beginAssociation(obj, path, property);
        String propertyName = property.getName();
        if (obj instanceof RelationAttributeInterface && ((RelationAttributeInterface)obj).hasRelationAttributeProperty(propertyName)) {
            RelationAttributeInterface relationAttributeObject = (RelationAttributeInterface)obj;
            this.m_propertyName = propertyName;
            this.m_keyName = relationAttributeObject.getRelationAttributeKeyName(propertyName);
            this.m_relationAttribute = relationAttributeObject.getRelationAttributeName(propertyName);
        }
    }

    protected void endAssociation(DomainObject obj, String path, Property property) {
        this.m_propertyName = "";
        this.m_keyName = "";
        this.m_relationAttribute = "";
        super.endAssociation(obj, path, property);
    }
}

