/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.categorization.Category;
import com.arsdigita.cms.CMSConfig;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSectionCollection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ContentTypeCollection;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.SectionLocaleCollection;
import com.arsdigita.cms.dispatcher.ItemResolver;
import com.arsdigita.cms.dispatcher.PageResolver;
import com.arsdigita.cms.dispatcher.Resource;
import com.arsdigita.cms.dispatcher.ResourceMapping;
import com.arsdigita.cms.dispatcher.ResourceType;
import com.arsdigita.cms.dispatcher.TemplateResolver;
import com.arsdigita.cms.dispatcher.XMLGenerator;
import com.arsdigita.cms.lifecycle.LifecycleDefinition;
import com.arsdigita.cms.lifecycle.LifecycleDefinitionCollection;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.globalization.Locale;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.persistence.CompoundFilter;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.FilterFactory;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.Application;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import com.arsdigita.workflow.simple.TaskCollection;
import com.arsdigita.workflow.simple.WorkflowTemplate;
import java.math.BigDecimal;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class ContentSection
extends Application {
    private static final Logger s_log = Logger.getLogger(ContentSection.class);
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.ContentSection";
    public static final String PACKAGE_TYPE = "content-section";
    protected static final String ID = "id";
    protected static final String PACKAGE = "package";
    protected static final String NAME = "label";
    protected static final String ROOT_FOLDER = "rootFolder";
    protected static final String TEMPLATES_FOLDER = "templatesFolder";
    protected static final String STAFF_GROUP = "staffGroup";
    protected static final String VIEWERS_GROUP = "viewersGroup";
    protected static final String DEFAULT_LOCALE = "defaultLocale";
    protected static final String LOCALES = "locales";
    protected static final String PAGE_RESOLVER_CLASS = "pageResolverClass";
    protected static final String ITEM_RESOLVER_CLASS = "itemResolverClass";
    protected static final String TEMPLATE_RESOLVER_CLASS = "templateResolverClass";
    protected static final String XML_GENERATOR_CLASS = "xmlGeneratorClass";
    protected static final String CONTENT_TYPES = "associatedContentTypes";
    protected static final String CREATABLE_CONTENT_TYPES = "creatableContentTypes";
    protected static final String CONTENT_TYPES_NOT_ASSOC = "notAssociatedContentTypes";
    protected static final String LIFECYCLE_DEFINITIONS = "associatedLifecycleDefinitions";
    protected static final String WF_TEMPLATES = "associatedWorkflowTemplates";
    private static final String ITEM_QUERY = "com.arsdigita.cms.ItemsInSection";
    private static final String SECTION_ID = "sectionId";
    private static final CMSConfig s_config = new CMSConfig();
    PageResolver m_pageResolver = null;
    ItemResolver m_itemResolver = null;
    TemplateResolver m_templateResolver = null;
    XMLGenerator m_xmlGenerator = null;

    public ContentSection(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public ContentSection(DataObject obj) {
        super(obj);
    }

    public ContentSection(BigDecimal id) throws DataObjectNotFoundException {
        super(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public static CMSConfig getConfig() {
        return s_config;
    }

    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public Object get(String key) {
        return super.get(key);
    }

    public void set(String key, Object value) {
        super.set(key, value);
    }

    protected void afterSave() {
        super.afterSave();
        Folder root = this.getRootFolder();
        root.setContentSection(this);
        root.save();
    }

    public String getName() {
        return this.getTitle();
    }

    public String getDisplayName() {
        return this.getName();
    }

    public void setName(String name) {
        this.set(NAME, name);
    }

    public String getURL() {
        String sURL = null;
        HttpServletRequest sreq = Web.getRequest();
        sURL = sreq != null ? URL.there((HttpServletRequest)sreq, (Application)this, (String)"/", null).toString() : URL.there((Application)this, (String)"/", null).toString();
        return sURL;
    }

    public String getFullPath() {
        return URL.getDispatcherPath() + this.getPath();
    }

    public Folder getRootFolder() {
        DataObject folder = (DataObject)this.get(ROOT_FOLDER);
        Assert.exists((Object)folder, (String)"root folder");
        return new Folder(folder);
    }

    public void setRootFolder(Folder root) {
        Assert.exists((Object)root, (String)"root folder");
        if (!this.isNew()) {
            Folder oldRoot = this.getRootFolder();
            oldRoot.setContentSection(null);
            oldRoot.save();
        }
        this.setAssociation(ROOT_FOLDER, (DomainObject)root);
    }

    public Folder getTemplatesFolder() {
        DataObject folder = (DataObject)this.get(TEMPLATES_FOLDER);
        if (folder == null) {
            return null;
        }
        return new Folder(folder);
    }

    public void setTemplatesFolder(Folder folder) {
        this.setAssociation(TEMPLATES_FOLDER, (DomainObject)folder);
    }

    public Category getRootCategory() {
        Category category = Category.getRootForObject((ACSObject)this);
        Assert.exists((Object)category, (String)"root category");
        return category;
    }

    public void setRootCategory(Category root) {
        Assert.exists((Object)root, (String)"root category");
        Category.setRootForObject((ACSObject)this, (Category)root);
    }

    public Group getStaffGroup() {
        DataObject group = (DataObject)this.get(STAFF_GROUP);
        Assert.exists((Object)group, (String)"staff group");
        return new Group(group);
    }

    public void setStaffGroup(Group group) {
        Assert.exists((Object)group, (String)"staff group");
        this.setAssociation(STAFF_GROUP, (DomainObject)group);
    }

    public Group getViewersGroup() {
        DataObject group = (DataObject)this.get(VIEWERS_GROUP);
        Assert.exists((Object)group, (String)"viewers group");
        return new Group(group);
    }

    public void setViewersGroup(Group group) {
        Assert.exists((Object)group, (String)"viewers group");
        this.setAssociation(VIEWERS_GROUP, (DomainObject)group);
    }

    public String getPageResolverClassName() {
        String prc = (String)this.get(PAGE_RESOLVER_CLASS);
        Assert.exists((Object)prc, (String)"Page Resolver class");
        return prc;
    }

    public PageResolver getPageResolver() {
        if (this.m_pageResolver == null) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"The page resolver hasn't been loaded yet; loading it now");
            }
            try {
                Class<?> prc = Class.forName(this.getPageResolverClassName());
                this.m_pageResolver = (PageResolver)prc.newInstance();
                this.m_pageResolver.setContentSectionID(this.getID());
            }
            catch (ClassNotFoundException cnfe) {
                throw new UncheckedWrapperException((Throwable)cnfe);
            }
            catch (InstantiationException ie) {
                throw new UncheckedWrapperException((Throwable)ie);
            }
            catch (IllegalAccessException iae) {
                throw new UncheckedWrapperException((Throwable)iae);
            }
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Returning page resolver " + this.m_pageResolver));
        }
        return this.m_pageResolver;
    }

    public void setPageResolverClassName(String className) {
        this.set(PAGE_RESOLVER_CLASS, className);
        this.m_pageResolver = null;
    }

    public String getItemResolverClassName() {
        String irc = (String)this.get(ITEM_RESOLVER_CLASS);
        Assert.exists((Object)irc, (String)"Content Item Resolver class");
        s_log.debug((Object)("Content Item Resolver Class is " + irc));
        return irc;
    }

    public ItemResolver getItemResolver() {
        if (this.m_itemResolver == null) {
            try {
                Class<?> irc = Class.forName(this.getItemResolverClassName());
                this.m_itemResolver = (ItemResolver)irc.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new UncheckedWrapperException((Throwable)cnfe);
            }
            catch (InstantiationException ie) {
                throw new UncheckedWrapperException((Throwable)ie);
            }
            catch (IllegalAccessException iae) {
                throw new UncheckedWrapperException((Throwable)iae);
            }
        }
        return this.m_itemResolver;
    }

    public void setItemResolverClass(String className) {
        this.set(ITEM_RESOLVER_CLASS, className);
        this.m_itemResolver = null;
    }

    public String getTemplateResolverClassName() {
        String trc = (String)this.get(TEMPLATE_RESOLVER_CLASS);
        Assert.exists((Object)trc, (String)"Template Resolver class");
        return trc;
    }

    public TemplateResolver getTemplateResolver() {
        if (this.m_templateResolver == null) {
            try {
                Class<?> trc = Class.forName(this.getTemplateResolverClassName());
                this.m_templateResolver = (TemplateResolver)trc.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new UncheckedWrapperException((Throwable)cnfe);
            }
            catch (InstantiationException ie) {
                throw new UncheckedWrapperException((Throwable)ie);
            }
            catch (IllegalAccessException iae) {
                throw new UncheckedWrapperException((Throwable)iae);
            }
        }
        return this.m_templateResolver;
    }

    public void setTemplateResolverClass(String className) {
        this.set(TEMPLATE_RESOLVER_CLASS, className);
        this.m_templateResolver = null;
    }

    public String getXMLGeneratorClassName() {
        String xgc = (String)this.get(XML_GENERATOR_CLASS);
        Assert.exists((Object)xgc, (String)"XML Generator class");
        return xgc;
    }

    public XMLGenerator getXMLGenerator() {
        if (this.m_xmlGenerator == null) {
            try {
                Class<?> xgc = Class.forName(this.getXMLGeneratorClassName());
                this.m_xmlGenerator = (XMLGenerator)xgc.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                throw new UncheckedWrapperException((Throwable)cnfe);
            }
            catch (InstantiationException ie) {
                throw new UncheckedWrapperException((Throwable)ie);
            }
            catch (IllegalAccessException iae) {
                throw new UncheckedWrapperException((Throwable)iae);
            }
        }
        return this.m_xmlGenerator;
    }

    public void setXMLGeneratorClass(String className) {
        this.set(XML_GENERATOR_CLASS, className);
        this.m_xmlGenerator = null;
    }

    public Locale getDefaultLocale() {
        DataObject obj = (DataObject)this.get(DEFAULT_LOCALE);
        if (obj == null) {
            return null;
        }
        return new Locale(obj);
    }

    public void setDefaultLocale(Locale locale) {
        this.setAssociation(DEFAULT_LOCALE, (DomainObject)locale);
    }

    public SectionLocaleCollection getLocales() {
        DataAssociation da = (DataAssociation)this.get(LOCALES);
        return new SectionLocaleCollection((DataCollection)da);
    }

    public void addLocale(Locale locale) {
        this.addLocale(locale, false);
    }

    public void addLocale(Locale locale, boolean isDefault) {
        DataAssociation da = (DataAssociation)this.get(LOCALES);
        locale.addToAssociation(da);
        if (isDefault) {
            this.setDefaultLocale(locale);
        }
    }

    public void removeLocale(Locale locale) {
        DataAssociation da = (DataAssociation)this.get(LOCALES);
        locale.removeFromAssociation(da);
    }

    public ContentTypeCollection getContentTypes() {
        return this.getContentTypes(false);
    }

    public ContentTypeCollection getContentTypes(boolean hidden) {
        DataAssociation da = (DataAssociation)this.get(CONTENT_TYPES);
        ContentTypeCollection types = new ContentTypeCollection((DataCollection)da);
        types.addFilter("mode != 'I'");
        if (!hidden) {
            types.addFilter("mode != 'H'");
        }
        return types;
    }

    public ContentTypeCollection getDescendantsOfContentType(ContentType ct) {
        ContentTypeCollection ctc = this.getContentTypes();
        FilterFactory ff = ctc.getFilterFactory();
        CompoundFilter or = ff.or();
        or.addFilter(ff.equals(ID, (Object)ct.getID()));
        try {
            StringTokenizer strTok = new StringTokenizer(ct.getDescendants(), "/");
            while (strTok.hasMoreElements()) {
                or.addFilter(ff.equals(ID, (Object)((String)strTok.nextElement())));
            }
        }
        catch (Exception ex) {
            s_log.error((Object)"WTF? The selected content type does not exist in the table???");
        }
        ctc.addFilter((Filter)or);
        return ctc;
    }

    public ContentTypeCollection getCreatableContentTypes() {
        return this.getCreatableContentTypes(false);
    }

    public ContentTypeCollection getCreatableContentTypes(boolean hidden) {
        DataAssociation da = (DataAssociation)this.get(CREATABLE_CONTENT_TYPES);
        ContentTypeCollection types = new ContentTypeCollection((DataCollection)da);
        types.addFilter("mode != 'I'");
        if (!hidden) {
            types.addFilter("mode != 'H'");
        }
        return types;
    }

    public void addContentType(ContentType type) {
        if (!this.hasContentType(type)) {
            DataAssociation da = (DataAssociation)this.get(CONTENT_TYPES);
            type.addToAssociation(da);
        }
    }

    public void removeContentType(ContentType type) {
        DataAssociation da = (DataAssociation)this.get(CONTENT_TYPES);
        type.removeFromAssociation(da);
    }

    private boolean hasContentType(ContentType type) {
        DataAssociation da = (DataAssociation)this.get(CONTENT_TYPES);
        DataAssociationCursor cursor = da.cursor();
        cursor.addEqualsFilter(ID, (Object)type.getID());
        return cursor.size() > 0L;
    }

    public ContentTypeCollection getNotAssociatedContentTypes() {
        DataAssociation da = (DataAssociation)this.get(CONTENT_TYPES_NOT_ASSOC);
        ContentTypeCollection types = new ContentTypeCollection((DataCollection)da);
        types.addFilter("mode != 'I'");
        return types;
    }

    public LifecycleDefinitionCollection getLifecycleDefinitions() {
        return new LifecycleDefinitionCollection((DataCollection)this.getLifecycleDefinitionsAssociation());
    }

    public void addLifecycleDefinition(LifecycleDefinition definition) {
        definition.addToAssociation(this.getLifecycleDefinitionsAssociation());
    }

    public void removeLifecycleDefinition(LifecycleDefinition definition) {
        definition.removeFromAssociation(this.getLifecycleDefinitionsAssociation());
    }

    private DataAssociation getLifecycleDefinitionsAssociation() {
        return (DataAssociation)this.get(LIFECYCLE_DEFINITIONS);
    }

    public TaskCollection getWorkflowTemplates() {
        TaskCollection tasks = new TaskCollection((DataCollection)this.getWorkflowTemplatesAssociation());
        tasks.addOrder("label asc");
        return tasks;
    }

    public void addWorkflowTemplate(WorkflowTemplate template) {
        this.addWorkflowTemplate(template, false);
    }

    public void addWorkflowTemplate(WorkflowTemplate template, boolean isDefault) {
        DataObject link = template.addToAssociation(this.getWorkflowTemplatesAssociation());
        link.set("isDefault", (Object)isDefault);
    }

    public void removeWorkflowTemplate(WorkflowTemplate template) {
        template.removeFromAssociation(this.getWorkflowTemplatesAssociation());
    }

    public void setDefaultWorkflowTemplate(String wf) {
        TaskCollection taskColl = this.getWorkflowTemplates();
        while (taskColl.next()) {
            if (((WorkflowTemplate)taskColl.getTask()).getLabel().equals(wf)) {
                ((DataObject)taskColl.get("link")).set("isDefault", (Object)true);
                continue;
            }
            ((DataObject)taskColl.get("link")).set("isDefault", (Object)false);
        }
    }

    public void setDefaultWorkflowTemplate(WorkflowTemplate wf) {
        TaskCollection taskColl = this.getWorkflowTemplates();
        while (taskColl.next()) {
            if (((WorkflowTemplate)taskColl.getTask()).equals((Object)wf)) {
                ((DataObject)taskColl.get("link")).set("isDefault", (Object)true);
                continue;
            }
            ((DataObject)taskColl.get("link")).set("isDefault", (Object)false);
        }
    }

    public WorkflowTemplate getDefaultWorkflowTemplate() {
        TaskCollection taskColl = this.getWorkflowTemplates();
        while (taskColl.next()) {
            if (!((Boolean)taskColl.get("link.isDefault")).booleanValue()) continue;
            WorkflowTemplate wf = (WorkflowTemplate)taskColl.getTask();
            taskColl.close();
            return wf;
        }
        taskColl = this.getWorkflowTemplates();
        if (taskColl.next()) {
            WorkflowTemplate wf = (WorkflowTemplate)taskColl.getTask();
            ((DataObject)taskColl.get("link")).set("isDefault", (Object)true);
            taskColl.close();
            return wf;
        }
        return null;
    }

    private DataAssociation getWorkflowTemplatesAssociation() {
        return (DataAssociation)this.get(WF_TEMPLATES);
    }

    public static ContentSection getSectionForPath(String path) throws DataObjectNotFoundException {
        return (ContentSection)ContentSection.retrieveApplicationForPath((String)path);
    }

    public static ContentSection getContentSection(ContentItem item) throws DataObjectNotFoundException {
        return item.getContentSection();
    }

    public static ContentSection getContentSection(Folder folder) throws DataObjectNotFoundException {
        return folder.getContentSection();
    }

    public static ContentSectionCollection getAllSections() {
        DataCollection da = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        return new ContentSectionCollection(da);
    }

    public static ContentSection getDefaultSection() {
        ContentSectionCollection sections = ContentSection.getAllSections();
        sections.addOrder(ID);
        sections.next();
        ContentSection section = (ContentSection)sections.getDomainObject();
        if (sections.isFirst()) {
            sections.close();
            s_log.debug((Object)("Default section is " + section.getName()));
            return section;
        }
        sections.close();
        s_log.debug((Object)("Section found: " + section.getName() + ", but not first."));
        return null;
    }

    public static String getDefaultSectionName() {
        return ContentSection.getDefaultSection().getBaseDataObjectType();
    }

    public static ContentSection create(String name) {
        Folder folder = ContentSection.createRootFolder(name);
        Category category = ContentSection.createRootCategory(name);
        Group staff = ContentSection.createStaffGroup(name);
        String prc = "com.arsdigita.cms.dispatcher.SimplePageResolver";
        String irc = "com.arsdigita.cms.dispatcher.MultilingualItemResolver";
        String xgc = "com.arsdigita.cms.dispatcher.SimpleXMLGenerator";
        String trc = "com.arsdigita.cms.dispatcher.DefaultTemplateResolver";
        ContentSection section = ContentSection.create(name, folder, category, staff, prc, irc, xgc, trc);
        PermissionService.setContext((OID)folder.getOID(), (OID)section.getOID());
        ContentSection.createDefaultResources(section);
        return section;
    }

    public static ContentSection create(String name, Folder folder, Category category, Group staff, String prc, String irc, String xgc) {
        String trc = "com.arsdigita.cms.dispatcher.DefaultTemplateResolver";
        return ContentSection.create(name, folder, category, staff, prc, irc, xgc, trc);
    }

    public static ContentSection create(String name, Folder folder, Category category, Group staff, String prc, String irc, String xgc, String trc) {
        Group viewers = new Group();
        viewers.setName(name + " Viewers");
        viewers.save();
        Folder templates = new Folder();
        templates.setName("templates");
        templates.setLabel((String)GlobalizationUtil.globalize("cms.templates").localize());
        templates.save();
        ContentSection section = (ContentSection)Application.createApplication((String)BASE_DATA_OBJECT_TYPE, (String)name, (String)name, null);
        section.initialize(name, folder, category, staff, prc, irc, xgc, trc, templates, viewers);
        return section;
    }

    protected static void createDefaultResources(ContentSection section) {
        ResourceType rt = ResourceType.findResourceType("xml");
        Resource r = rt.createInstance("com.arsdigita.cms.ui.ContentSectionPage");
        r.save();
        ResourceMapping rm = r.createInstance(section, "admin");
        rm.save();
        rm = r.createInstance(section, "admin/index");
        rm.save();
        r = rt.createInstance("com.arsdigita.cms.ui.ContentItemPage");
        r.save();
        rm = r.createInstance(section, "admin/item");
        rm.save();
    }

    protected static Folder createRootFolder(String name) {
        Folder root = new Folder();
        root.setName("/");
        root.setLabel((String)GlobalizationUtil.globalize("cms.installer.root_folder").localize());
        root.save();
        return root;
    }

    protected static Category createRootCategory(String name) {
        Category root = new Category("/", "Root Category");
        root.save();
        return root;
    }

    private static Group createStaffGroup(String name) {
        Group staff = new Group();
        staff.setName(name + " Administration");
        staff.save();
        return staff;
    }

    public ContentSection initialize(String name, Folder folder, Category category, Group staff, String prc, String irc, String xgc, String trc, Folder templates, Group viewers) {
        this.setName(name);
        this.setRootFolder(folder);
        this.setRootCategory(category);
        this.setStaffGroup(staff);
        this.setPageResolverClassName(prc);
        this.setItemResolverClass(irc);
        this.setXMLGeneratorClass(xgc);
        this.setTemplateResolverClass(trc);
        this.setTemplatesFolder(templates);
        this.setViewersGroup(viewers);
        this.save();
        return this;
    }

    public Folder.ItemCollection getItems() {
        DataQuery dq = SessionManager.getSession().retrieveQuery(ITEM_QUERY);
        dq.setParameter(SECTION_ID, (Object)this.getID());
        return new Folder.ItemCollection(dq);
    }

    public String getServletPath() {
        return "/templates/servlet/content-section";
    }

    static {
        s_log.debug((Object)"Static initializer starting...");
        s_config.load();
        s_log.debug((Object)"Static initializer finished...");
    }
}

