/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.caching.CacheTable;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentSectionCollection;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.dispatcher.ContentItemDispatcher;
import com.arsdigita.cms.dispatcher.ItemResolver;
import com.arsdigita.cms.dispatcher.TemplateResolver;
import com.arsdigita.cms.lifecycle.Lifecycle;
import com.arsdigita.cms.publishToFile.LocalRequestPassword;
import com.arsdigita.dispatcher.AccessDeniedException;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.globalization.GlobalizationHelper;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.ACSObjectCache;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelContext;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.AbstractTransactionListener;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.persistence.TransactionListener;
import com.arsdigita.util.Assert;
import com.arsdigita.util.Classes;
import com.arsdigita.versioning.Versions;
import com.arsdigita.web.Application;
import com.arsdigita.web.ApplicationFileResolver;
import com.arsdigita.web.BaseApplicationServlet;
import com.arsdigita.web.LoginSignal;
import com.arsdigita.web.Web;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ContentSectionServlet
extends BaseApplicationServlet {
    private static final Logger s_log = Logger.getLogger(ContentSectionServlet.class);
    private static final String[] WELCOME_FILES = new String[]{"index.jsp", "index.html"};
    public static final String PREVIEW = "/preview";
    public static final String FILE_SUFFIX = ".jsp";
    public static final String INDEX_FILE = "/index";
    public static final String CONTENT_ITEM = "com.arsdigita.cms.dispatcher.item";
    public static final String CONTENT_SECTION = "com.arsdigita.cms.dispatcher.section";
    public static final String XML_SUFFIX = ".xml";
    public static final String XML_MODE = "xmlMode";
    public static final String MEDIA_TYPE = "templateContext";
    private static final String CACHE_KEY_DELIMITER = "%";
    private ContentItemDispatcher m_disp = new ContentItemDispatcher();
    public static Map s_itemResolverCache = Collections.synchronizedMap(new HashMap());
    private static Map s_itemURLCacheMap = null;
    private static boolean s_cacheItems = true;
    private String m_templatePath;
    private ApplicationFileResolver m_resolver;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String templatePath = config.getInitParameter("template-path");
        this.m_templatePath = templatePath == null ? ContentSection.getConfig().getTemplateRoot() : config.getInitParameter("template-path");
        Assert.exists((Object)this.m_templatePath, String.class);
        Assert.isTrue((boolean)this.m_templatePath.startsWith("/"), (String)"template-path must start with '/'");
        Assert.isTrue((!this.m_templatePath.endsWith("/") ? 1 : 0) != 0, (String)"template-path must not end with '/'");
        String resolverName = config.getInitParameter("file-resolver");
        this.m_resolver = resolverName == null ? Web.getConfig().getApplicationFileResolver() : (ApplicationFileResolver)Classes.newInstance((String)resolverName);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Template path is " + this.m_templatePath + " with resolver " + this.m_resolver.getClass().getName()));
        }
    }

    protected void doService(HttpServletRequest sreq, HttpServletResponse sresp, Application app) throws ServletException, IOException {
        ItemResolver itemResolver;
        ContentItem item;
        ContentSection section = (ContentSection)app;
        String requestUri = sreq.getRequestURI();
        RequestContext ctx = DispatcherHelper.getRequestContext();
        String url = ctx.getRemainingURLPart();
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)("Resolving item URL " + url));
        }
        if ((item = this.getItem(section, url, itemResolver = this.getItemResolver(section))) != null) {
            String param = sreq.getParameter("transID");
            if (param != null) {
                Session ssn = SessionManager.getSession();
                TransactionContext txn = ssn.getTransactionContext();
                txn.addTransactionListener((TransactionListener)new AbstractTransactionListener(){

                    public void beforeCommit(TransactionContext txn) {
                        Assert.fail((String)"uncommittable transaction");
                    }
                });
                Kernel.getContext().getTransaction().setCommitRequested(false);
                BigInteger transID = new BigInteger(param);
                Versions.rollback((OID)item.getOID(), (BigInteger)transID);
            }
            this.serveItem(sreq, sresp, section, item);
        } else {
            if (s_log.isInfoEnabled()) {
                s_log.info((Object)"NOT serving content item");
            }
            sreq.setAttribute(CONTENT_SECTION, (Object)section);
            RequestDispatcher rd = this.m_resolver.resolve(this.m_templatePath, sreq, sresp, app);
            if (rd != null) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Got dispatcher " + rd));
                }
                sreq = DispatcherHelper.restoreOriginalRequest((HttpServletRequest)sreq);
                rd.forward((ServletRequest)sreq, (ServletResponse)sresp);
            } else {
                sresp.sendError(404, requestUri + " not found on this server.");
            }
        }
    }

    private void serveItem(HttpServletRequest sreq, HttpServletResponse sresp, ContentSection section, ContentItem item) throws ServletException, IOException {
        int maxAge;
        Date endDate;
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)"serving content item");
        }
        RequestContext ctx = DispatcherHelper.getRequestContext();
        String url = ctx.getRemainingURLPart();
        ItemResolver itemResolver = this.getItemResolver(section);
        ACSObjectCache.set((ServletRequest)sreq, (ACSObject)item);
        sreq.setAttribute(CONTENT_ITEM, (Object)item);
        TemplateResolver templateResolver = this.m_disp.getTemplateResolver(section);
        String templateURL = url;
        if (!templateURL.startsWith("/")) {
            templateURL = "/" + templateURL;
        }
        if (templateURL.startsWith(PREVIEW)) {
            templateURL = templateURL.substring(PREVIEW.length());
        }
        String sTemplateContext = itemResolver.getTemplateFromURL(templateURL);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("setting template context to " + sTemplateContext));
        }
        templateResolver.setTemplateContext(sTemplateContext, sreq);
        Lifecycle cycle = item.getLifecycle();
        int expires = DispatcherHelper.getDefaultCacheExpiry();
        if (cycle != null && (endDate = cycle.getEndDate()) != null && (maxAge = (int)((endDate.getTime() - System.currentTimeMillis()) / 1000L)) < expires) {
            expires = maxAge;
        }
        if (s_cacheItems && item.isLiveVersion()) {
            SecurityManager sm = new SecurityManager(section);
            if (sm.canAccess((User)null, "public_pages", item)) {
                DispatcherHelper.cacheForWorld((HttpServletResponse)sresp, (int)expires);
            } else {
                DispatcherHelper.cacheForUser((HttpServletResponse)sresp, (int)expires);
            }
        } else {
            DispatcherHelper.cacheDisable((HttpServletResponse)sresp);
        }
        this.m_disp.dispatch(sreq, sresp, ctx);
    }

    public static ContentSection getContentSection(HttpServletRequest request) {
        return (ContentSection)((Object)request.getAttribute(CONTENT_SECTION));
    }

    public ItemResolver getItemResolver(ContentSection section) {
        String path = section.getPath();
        ItemResolver ir = (ItemResolver)s_itemResolverCache.get(path);
        if (ir == null) {
            ir = section.getItemResolver();
            s_itemResolverCache.put(path, ir);
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("using ItemResolver " + ir.getClass().getName()));
        }
        return ir;
    }

    public ContentItem getItem(ContentSection section, String url, ItemResolver itemResolver) {
        ContentItem item;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("getting item at url " + url));
        }
        HttpServletRequest request = Web.getRequest();
        if (url.endsWith(XML_SUFFIX)) {
            request.setAttribute(XML_MODE, (Object)Boolean.TRUE);
            s_log.debug((Object)"StraightXML Requested");
            url = "/" + url.substring(0, url.length() - XML_SUFFIX.length());
        } else {
            request.setAttribute(XML_MODE, (Object)Boolean.FALSE);
            if (url.endsWith(FILE_SUFFIX)) {
                url = "/" + url.substring(0, url.length() - FILE_SUFFIX.length());
            } else if (url.endsWith("/")) {
                url = "/" + url.substring(0, url.length() - 1);
            }
        }
        if (!url.startsWith("/")) {
            url = "/" + url;
        }
        SecurityManager sm = new SecurityManager(section);
        boolean hasPermission = true;
        boolean preview = false;
        if (url.startsWith(PREVIEW)) {
            url = url.substring(PREVIEW.length());
            preview = true;
        }
        if (preview) {
            if (s_log.isInfoEnabled()) {
                s_log.info((Object)"Trying to get item for PREVIEW");
            }
            if ((item = itemResolver.getItem(section, url, "preview")) != null) {
                hasPermission = sm.canAccess(request, "preview_pages", item);
            }
        } else {
            if (s_log.isInfoEnabled()) {
                s_log.info((Object)"Trying to get LIVE item");
            }
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Trying to get content item for URL " + url + " from cache"));
            }
            String lang = GlobalizationHelper.getNegotiatedLocale().getLanguage();
            item = ContentSectionServlet.itemURLCacheGet(section, url, lang);
            item = null;
            if (item == null) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)"Did not find content item in cache, so trying to retrieve and cache...");
                }
                item = itemResolver.getItem(section, url, "live");
                ContentSectionServlet.itemURLCachePut(section, url, lang, item);
            } else if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"Found content item in cache");
            }
            if (s_log.isDebugEnabled() && item != null) {
                s_log.debug((Object)("Sanity check: item.getPath() is " + item.getPath()));
            }
            if (item != null) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)"Content Item is not null");
                }
                if (hasPermission = sm.canAccess(request, "public_pages", item)) {
                    // empty if block
                }
            }
        }
        if (item == null && url.endsWith(INDEX_FILE)) {
            if (item == null && s_log.isInfoEnabled()) {
                s_log.info((Object)"no item found");
            }
            url = url.substring(0, url.length() - INDEX_FILE.length());
            if (s_log.isInfoEnabled()) {
                s_log.info((Object)("Attempting to match folder " + url));
            }
            if ((item = itemResolver.getItem(section, url, "live")) != null) {
                hasPermission = sm.canAccess(request, "public_pages", item);
            }
        }
        if (!hasPermission && !LocalRequestPassword.validLocalRequest(request)) {
            Party user = Kernel.getContext().getParty();
            if (user == null) {
                throw new LoginSignal(request);
            }
            throw new AccessDeniedException();
        }
        return item;
    }

    public ContentItem getItem(ContentSection section, String url) {
        ItemResolver itemResolver = this.getItemResolver(section);
        return this.getItem(section, url, itemResolver);
    }

    private static synchronized void itemURLCachePut(ContentSection section, String sURL, String lang, BigDecimal itemID) {
        ContentSectionServlet.getItemURLCache(section).put(sURL + CACHE_KEY_DELIMITER + lang, (Object)itemID);
    }

    public static synchronized void itemURLCachePut(ContentSection section, String sURL, String lang, ContentItem item) {
        if (sURL == null || item == null) {
            return;
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("adding cached entry for url " + sURL + " and language " + lang));
        }
        ContentSectionServlet.itemURLCachePut(section, sURL, lang, item.getID());
    }

    public static synchronized void itemURLCacheRemove(ContentSection section, String sURL, String lang) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("removing cached entry for url " + sURL + "and language " + lang));
        }
        ContentSectionServlet.getItemURLCache(section).remove(sURL + CACHE_KEY_DELIMITER + lang);
    }

    public static ContentItem itemURLCacheGet(ContentSection section, String sURL, String lang) {
        BigDecimal itemID = (BigDecimal)ContentSectionServlet.getItemURLCache(section).get(sURL + CACHE_KEY_DELIMITER + lang);
        if (itemID == null) {
            return null;
        }
        try {
            return (ContentItem)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.cms.ContentItem", (Object)itemID));
        }
        catch (DataObjectNotFoundException donfe) {
            return null;
        }
    }

    private static synchronized CacheTable getItemURLCache(ContentSection section) {
        Assert.exists((Object)((Object)section), ContentSection.class);
        if (s_itemURLCacheMap == null) {
            ContentSectionServlet.initializeItemURLCache();
        }
        return (CacheTable)s_itemURLCacheMap.get(section.getPath());
    }

    private static synchronized void initializeItemURLCache() {
        ContentSectionCollection sections = ContentSection.getAllSections();
        s_itemURLCacheMap = new HashMap();
        while (sections.next()) {
            ContentSection section = sections.getContentSection();
            String idStr = section.getID().toString();
            String path = section.getPath();
            CacheTable itemURLCache = new CacheTable("ContentSectionServletItemURLCache" + idStr);
            s_itemURLCacheMap.put(path, itemURLCache);
        }
    }

    public static boolean checkAdminAccess(HttpServletRequest request, ContentSection section) {
        KernelContext kernelContext = Kernel.getContext();
        if (!(kernelContext.getParty() instanceof User)) {
            return false;
        }
        User user = (User)kernelContext.getParty();
        SecurityManager sm = new SecurityManager(section);
        return sm.canAccess((Party)user, "admin_pages");
    }
}

