/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.AuthoringKit;
import com.arsdigita.cms.ContentTypeCollection;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.PersistentForm;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.CompoundFilter;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.DataQueryDataCollectionAdapter;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.FilterFactory;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.Web;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class ContentType
extends ACSObject {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.ContentType";
    public static final String OBJECT_TYPE = "associatedObjectType";
    public static final String LABEL = "label";
    public static final String DESCRIPTION = "description";
    public static final String CLASSNAME = "className";
    public static final String MODE = "mode";
    public static final String AUTHORING_KIT = "authoringKit";
    public static final String ITEM_FORM_ID = "itemFormID";
    public static final String ITEM_FORM = "itemForm";
    public static final String ANCESTORS = "ancestors";
    public static final String DESCENDANTS = "descendants";
    private static List s_xsl = new ArrayList();

    public ContentType() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public ContentType(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public ContentType(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    protected ContentType(String type) {
        super(type);
    }

    public ContentType(DataObject obj) {
        super(obj);
    }

    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    protected void beforeSave() {
        if (this.getMode() == null) {
            this.setMode("default");
        }
        super.beforeSave();
    }

    public String getAssociatedObjectType() {
        return (String)this.get(OBJECT_TYPE);
    }

    public void setAssociatedObjectType(String objType) {
        this.set(OBJECT_TYPE, objType);
    }

    public String getLabel() {
        return (String)this.get(LABEL);
    }

    public void setLabel(String label) {
        this.set(LABEL, label);
    }

    public String getDescription() {
        return (String)this.get(DESCRIPTION);
    }

    public void setDescription(String description) {
        this.set(DESCRIPTION, description);
    }

    public String getClassName() {
        return (String)this.get(CLASSNAME);
    }

    public void setClassName(String className) {
        this.set(CLASSNAME, className);
    }

    public Boolean isInternal() {
        return "I".equalsIgnoreCase((String)this.get(MODE));
    }

    public Boolean isHidden() {
        return "H".equalsIgnoreCase((String)this.get(MODE));
    }

    public void setMode(String mode) {
        if (mode != null && !mode.isEmpty()) {
            this.set(MODE, mode.toUpperCase().substring(0, 1));
        } else {
            this.set(MODE, "default".toUpperCase().substring(0, 1));
        }
    }

    public String getMode() {
        return (String)this.get(MODE);
    }

    public AuthoringKit getAuthoringKit() {
        DataObject kit = (DataObject)this.get(AUTHORING_KIT);
        if (kit == null) {
            return null;
        }
        return new AuthoringKit(kit);
    }

    public AuthoringKit createAuthoringKit() {
        return this.createAuthoringKit(null);
    }

    public AuthoringKit createAuthoringKit(String createComponent) {
        if (this.getAuthoringKit() == null) {
            AuthoringKit kit = new AuthoringKit();
            kit.setContentType(this);
            if (createComponent != null) {
                kit.setCreateComponent(createComponent);
            }
            return kit;
        }
        throw new RuntimeException("An AuthorigKit exists for this ContentType.");
    }

    public BigDecimal getItemFormID() {
        return (BigDecimal)this.get(ITEM_FORM_ID);
    }

    public void setItemFormID(BigDecimal itemFormID) {
        this.set(ITEM_FORM_ID, itemFormID);
    }

    public PersistentForm getItemForm() throws DataObjectNotFoundException {
        DataObject pForm = (DataObject)this.get(ITEM_FORM);
        if (pForm == null) {
            return null;
        }
        return new PersistentForm(pForm);
    }

    public void addAncestor(BigDecimal newAncestor) {
        String ancestors = (String)this.get(ANCESTORS);
        if (ancestors == null) {
            ancestors = newAncestor.toString();
        } else if (!ancestors.contains(newAncestor.toString())) {
            ancestors = ancestors.length() == 0 ? newAncestor.toString() : ancestors + "/" + newAncestor.toString();
        }
        this.set(ANCESTORS, ancestors);
    }

    public void delAncestor(BigDecimal ancestor) {
        String ancestors = (String)this.get(ANCESTORS);
        if (ancestors != null && ancestors.length() > 0) {
            ancestors.replace(ancestor.toString(), "");
            ancestors.replace("//", "/");
            if (ancestors.equals("/")) {
                ancestors = "";
            }
        }
        this.set(ANCESTORS, ancestors);
    }

    public String getAncestors() {
        return (String)this.get(ANCESTORS);
    }

    public void addDescendants(BigDecimal newDescendant) {
        if (this.getID().equals(newDescendant)) {
            return;
        }
        String descendants = (String)this.get(DESCENDANTS);
        if (descendants == null) {
            descendants = newDescendant.toString();
        } else if (!descendants.contains(newDescendant.toString())) {
            descendants = descendants.length() == 0 ? newDescendant.toString() : descendants + "/" + newDescendant.toString();
        }
        this.set(DESCENDANTS, descendants);
    }

    public String getDescendants() {
        return (String)this.get(DESCENDANTS);
    }

    public void delDescendants(BigDecimal descendant) {
        String descendants = (String)this.get(DESCENDANTS);
        if (descendants != null && descendants.length() > 0) {
            descendants.replace(descendant.toString(), "");
            descendants.replace("//", "/");
            if (descendants.equals("/")) {
                descendants = "";
            }
        }
        this.set(DESCENDANTS, descendants);
    }

    public static ContentType findByAssociatedObjectType(String objType) throws DataObjectNotFoundException {
        ContentTypeCollection types = ContentType.getAllContentTypes();
        types.addFilter("associatedObjectType = :type").set("type", (Object)objType);
        if (types.next()) {
            ContentType type = types.getContentType();
            types.close();
            return type;
        }
        types.close();
        throw new DataObjectNotFoundException("No matching content type for object type " + objType);
    }

    public static ContentTypeCollection getAllContentTypes() {
        return ContentType.getAllContentTypes(true, true);
    }

    public static ContentTypeCollection getAllContentTypes(boolean hidden) {
        return ContentType.getAllContentTypes(true, hidden);
    }

    public static ContentTypeCollection getUserDefinedContentTypes() {
        return ContentType.getAllContentTypes(false, true);
    }

    private static ContentTypeCollection getAllContentTypes(boolean internal, boolean hidden) {
        DataCollection da = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        ContentTypeCollection types = new ContentTypeCollection(da);
        if (!internal) {
            types.addFilter("mode != 'I'");
        }
        if (!hidden) {
            types.addFilter("mode != 'H'");
        }
        return types;
    }

    public static ContentTypeCollection getRegisteredContentTypes() {
        String query = "com.arsdigita.cms.registeredContentTypes";
        DataQuery dq = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.registeredContentTypes");
        DataQueryDataCollectionAdapter dc = new DataQueryDataCollectionAdapter(dq, "type");
        return new ContentTypeCollection((DataCollection)dc);
    }

    public static ContentTypeCollection getDescendantsOf(ContentType ct) {
        ContentTypeCollection ctc = ContentType.getRegisteredContentTypes();
        FilterFactory ff = ctc.getFilterFactory();
        CompoundFilter or = ff.or();
        or.addFilter(ff.equals("id", (Object)ct.getID().toString()));
        try {
            StringTokenizer strTok = new StringTokenizer(ct.getDescendants(), "/");
            while (strTok.hasMoreElements()) {
                or.addFilter(ff.equals("id", (Object)((String)strTok.nextElement())));
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        ctc.addFilter((Filter)or);
        return ctc;
    }

    public static void registerXSLFile(ContentType type, String path) {
        s_xsl.add(new XSLEntry(type, path));
    }

    public static void unregisterXSLFile(ContentType type, String path) {
        s_xsl.remove(new XSLEntry(type, path));
    }

    public static Iterator getXSLFileURLs() {
        return new EntryIterator(s_xsl.iterator());
    }

    private static class XSLEntry {
        private ContentType m_type;
        private String m_path;

        public XSLEntry(ContentType type, String path) {
            this.m_type = type;
            this.m_path = path;
        }

        public ContentType getType() {
            return this.m_type;
        }

        public String getPath() {
            return this.m_path;
        }

        public boolean equals(Object o) {
            if (!(o instanceof XSLEntry)) {
                return false;
            }
            XSLEntry e = (XSLEntry)o;
            return this.m_path.equals(e.m_path) && this.m_type.equals((Object)e.m_type);
        }

        public int hashCode() {
            return this.m_path.hashCode() + this.m_type.hashCode();
        }
    }

    private static class EntryIterator
    implements Iterator {
        private Iterator m_inner;

        public EntryIterator(Iterator inner) {
            this.m_inner = inner;
        }

        @Override
        public boolean hasNext() {
            return this.m_inner.hasNext();
        }

        public Object next() {
            XSLEntry entry = (XSLEntry)this.m_inner.next();
            String path = entry.getPath();
            try {
                return new URL(Web.getConfig().getDefaultScheme(), Web.getConfig().getHost().getName(), Web.getConfig().getHost().getPort(), path);
            }
            catch (MalformedURLException ex) {
                throw new UncheckedWrapperException("path malformed" + path, (Throwable)ex);
            }
        }

        @Override
        public void remove() {
            this.m_inner.remove();
        }
    }
}

