/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.lifecycle.LifecycleDefinition;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import java.math.BigDecimal;

public class ContentTypeLifecycleDefinition
extends DomainObject {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.ContentTypeLifecycleDefinition";
    protected static final String SECTION_ID = "sectionId";
    protected static final String CONTENT_TYPE_ID = "contentTypeId";
    protected static final String LIFECYCLE_DEFINITION_ID = "lifecycleDefinitionId";

    protected ContentTypeLifecycleDefinition() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    protected ContentTypeLifecycleDefinition(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    protected ContentTypeLifecycleDefinition(DataObject obj) {
        super(obj);
    }

    protected BigDecimal getContentSectionID() {
        return (BigDecimal)this.get(SECTION_ID);
    }

    protected void setContentSection(ContentSection section) {
        this.set(SECTION_ID, section.getID());
    }

    protected BigDecimal getContentTypeID() {
        return (BigDecimal)this.get(CONTENT_TYPE_ID);
    }

    protected void setContentType(ContentType type) {
        this.set(CONTENT_TYPE_ID, type.getID());
    }

    protected BigDecimal getLifecycleDefinitionID() {
        return (BigDecimal)this.get(LIFECYCLE_DEFINITION_ID);
    }

    protected void setLifecycleDefinition(LifecycleDefinition definition) {
        this.set(LIFECYCLE_DEFINITION_ID, definition.getID());
    }

    public static LifecycleDefinition getLifecycleDefinition(ContentSection section, ContentType type) {
        try {
            OID oid = new OID(BASE_DATA_OBJECT_TYPE);
            oid.set(SECTION_ID, (Object)section.getID());
            oid.set(CONTENT_TYPE_ID, (Object)type.getID());
            ContentTypeLifecycleDefinition assn = new ContentTypeLifecycleDefinition(oid);
            BigDecimal lifecycleDefinitionID = assn.getLifecycleDefinitionID();
            return new LifecycleDefinition(new OID("com.arsdigita.cms.LifecycleDefinition", (Object)lifecycleDefinitionID));
        }
        catch (DataObjectNotFoundException e) {
            return null;
        }
    }

    public static boolean updateLifecycleDefinition(ContentSection section, ContentType type, LifecycleDefinition lifecycle) {
        try {
            OID oid = new OID(BASE_DATA_OBJECT_TYPE);
            oid.set(SECTION_ID, (Object)section.getID());
            oid.set(CONTENT_TYPE_ID, (Object)type.getID());
            ContentTypeLifecycleDefinition assn = new ContentTypeLifecycleDefinition(oid);
            assn.setLifecycleDefinition(lifecycle);
            assn.save();
            return false;
        }
        catch (DataObjectNotFoundException e) {
            ContentTypeLifecycleDefinition assn = new ContentTypeLifecycleDefinition();
            assn.setContentSection(section);
            assn.setContentType(type);
            assn.setLifecycleDefinition(lifecycle);
            assn.save();
            return true;
        }
    }

    public static boolean removeLifecycleDefinition(ContentSection section, ContentType type) {
        try {
            OID oid = new OID(BASE_DATA_OBJECT_TYPE);
            oid.set(SECTION_ID, (Object)section.getID());
            oid.set(CONTENT_TYPE_ID, (Object)type.getID());
            ContentTypeLifecycleDefinition assn = new ContentTypeLifecycleDefinition(oid);
            assn.delete();
            return true;
        }
        catch (DataObjectNotFoundException e) {
            return false;
        }
    }
}

