/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.ContentBundle;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectTraversal;
import com.arsdigita.domain.DomainObjectTraversalAdapter;
import com.arsdigita.domain.DomainObjectXMLRenderer;
import com.arsdigita.globalization.GlobalizationHelper;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Element;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class CustomizableContentItemXMLRenderer
extends DomainObjectXMLRenderer {
    private static final Logger s_log = Logger.getLogger(CustomizableContentItemXMLRenderer.class);
    private int m_pageSize = 20;
    private String m_order;
    private List<String> m_filters = new ArrayList<String>();

    public CustomizableContentItemXMLRenderer(Element root) {
        super(root);
    }

    public void setPageSize(int pageSize) {
        this.m_pageSize = pageSize;
    }

    public void setOrder(String order) {
        this.m_order = order;
    }

    public void setFilters(List<String> filters) {
        this.m_filters = filters;
    }

    public void addFilter(String filter) {
        this.m_filters.add(filter);
    }

    public void walk(DomainObject dobj, String context, DomainObjectTraversalAdapter adapter) {
        super.walk(dobj, context, adapter);
    }

    protected void walk(DomainObjectTraversalAdapter adapter, DomainObject obj, String path, String context, DomainObject linkObject) {
        Object nObj = obj;
        if (nObj instanceof ContentBundle) {
            nObj = ((ContentBundle)obj).getInstance(GlobalizationHelper.getNegotiatedLocale(), true);
        }
        super.walk(adapter, nObj, path, context, linkObject);
    }

    protected void walkDataAssociations(DomainObjectTraversalAdapter adapter, DomainObject obj, String path, String context, Property prop, String propName, Object propValue) {
        s_log.debug((Object)String.format("%s is a DataAssociation", prop.getName()));
        if (this.m_pageSize <= 0) {
            s_log.debug((Object)"pageSize is 0 or less, not using Paginator.");
            super.walkDataAssociations(adapter, obj, path, context, prop, propName, propValue);
        } else {
            s_log.debug((Object)String.format("Rendering DataAssociation using a paginator with a page size of %d", this.m_pageSize));
            this.beginAssociation(obj, path, prop);
            DataAssociationCursor daCursor = ((DataAssociation)propValue).getDataAssociationCursor();
            if (daCursor.size() == 0L) {
                s_log.debug((Object)"No items to show, finishing assoication and returning.");
                this.endAssociation(obj, path, prop);
                return;
            }
            s_log.debug((Object)"Walking daCursor...");
            s_log.debug((Object)String.format("daCursor.size() = %d", daCursor.size()));
            if (this.m_order != null) {
                daCursor.addOrder(this.m_order);
            }
            for (String filter : this.m_filters) {
                daCursor.addFilter(filter);
            }
            URL requestUrl = Web.getContext().getRequestURL();
            String pageNumberValue = requestUrl.getParameter("pageNumber");
            long pageNumber = pageNumberValue == null ? 1L : Long.parseLong(pageNumberValue);
            long objectCount = daCursor.size();
            int pageCount = (int)Math.ceil((double)objectCount / (double)this.m_pageSize);
            if (pageNumber < 1L) {
                pageNumber = 1L;
            }
            if (pageNumber > (long)pageCount) {
                pageNumber = pageCount == 0 ? 1L : (long)pageCount;
            }
            long begin = (pageNumber - 1L) * (long)this.m_pageSize;
            int count = (int)Math.min((long)this.m_pageSize, objectCount - begin);
            long end = begin + (long)count;
            s_log.debug((Object)"Calculted the following values for the paginator:");
            s_log.debug((Object)String.format("pageNumber  = %d", pageNumber));
            s_log.debug((Object)String.format("objectCount = %d", objectCount));
            s_log.debug((Object)String.format("pageCount   = %d", pageCount));
            s_log.debug((Object)String.format("begin       = %d", begin));
            s_log.debug((Object)String.format("count       = %d", count));
            s_log.debug((Object)String.format("end         = %d", end));
            if (count != 0) {
                daCursor.setRange(new Integer((int)begin + 1), new Integer((int)end + 1));
            }
            Element paginator = new Element("nav:paginator", "http://ccm.redhat.com/navigation");
            this.getCurrentElement().addContent(paginator);
            ParameterMap map = new ParameterMap();
            if (requestUrl.getParameterMap() != null) {
                for (String key : requestUrl.getParameterMap().keySet()) {
                    if (key.equals("pageNumber")) continue;
                    map.setParameterValues(key, requestUrl.getParameterValues(key));
                }
            }
            paginator.addAttribute("pageParam", "pageNumber");
            paginator.addAttribute("baseURL", URL.there((String)requestUrl.getPathInfo(), (ParameterMap)map).toString());
            paginator.addAttribute("pageNumber", new Long(pageNumber).toString());
            paginator.addAttribute("pageCount", new Long(pageCount).toString());
            paginator.addAttribute("pageSize", new Long(this.m_pageSize).toString());
            paginator.addAttribute("objectBegin", new Long(begin + 1L).toString());
            paginator.addAttribute("objectEnd", new Long(end).toString());
            paginator.addAttribute("objectCount", new Long(objectCount).toString());
            int index = 0;
            while (daCursor.next()) {
                DataObject dobj = daCursor.getDataObject();
                ACSObject object = null;
                object = (ACSObject)DomainObjectFactory.newInstance((DataObject)dobj);
                DataObject link = daCursor.getLink();
                DomainObjectTraversal.LinkDomainObject linkObj = null;
                if (link != null) {
                    linkObj = new DomainObjectTraversal.LinkDomainObject((DomainObjectTraversal)this, link);
                }
                this.walk(adapter, DomainObjectFactory.newInstance((DataObject)daCursor.getDataObject()), this.appendToPath(path, propName), context, (DomainObject)linkObj);
                ++index;
            }
            this.endAssociation(obj, path, prop);
        }
    }

    protected String getStableURL(DataObject dobj, ACSObject obj) {
        OID oid = new OID((String)dobj.get("objectType"), dobj.get("id"));
        return String.format("/redirect/?oid=%s", oid.toString());
    }
}

