/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainService;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.Assert;
import com.arsdigita.util.Classes;
import com.arsdigita.util.Tracer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

class DomainCopier
extends DomainService {
    private static Logger s_log = Logger.getLogger(DomainCopier.class);
    private final HashMap m_copied = new HashMap();
    protected final TraversedSet m_traversed = new TraversedSet();
    final Tracer m_trace = new Tracer(DomainCopier.class);

    public DomainObject copy(DomainObject source) {
        this.m_trace.enter("copy", (Object)source);
        OID sourceOID = source.getOID();
        DomainObject already = (DomainObject)this.m_copied.get(sourceOID);
        if (already == null) {
            if (s_log.isInfoEnabled()) {
                s_log.info((Object)("Copying " + source));
            }
            Class<?> clacc = source.getClass();
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Using class " + clacc.getName()));
            }
            DomainObject target = null;
            if (source instanceof ACSObject) {
                String type = ((ACSObject)source).getSpecificObjectType();
                target = (DomainObject)Classes.newInstance(clacc, (Class[])new Class[]{String.class}, (Object[])new Object[]{type});
            } else {
                Assert.fail((String)("Cannot copy " + source + "; it is not an " + "ACSObject"));
            }
            Assert.exists(target, DomainObject.class);
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Created empty copy shell " + target));
            }
            this.m_copied.put(sourceOID, target);
            this.copyData(source, target);
            this.m_trace.exit("copy", (Object)target);
            return target;
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)"There is already a copy; returning it");
        }
        this.m_trace.exit("copy", (Object)already);
        return already;
    }

    protected void copyData(DomainObject source, DomainObject target) {
        ObjectType type = source.getObjectType();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Using object type " + type.getName()));
        }
        Iterator iter = type.getProperties();
        ArrayList<Property> attributes = new ArrayList<Property>();
        ArrayList<Property> roles = new ArrayList<Property>();
        ArrayList<Property> collections = new ArrayList<Property>();
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            if (prop.isAttribute()) {
                attributes.add(prop);
                continue;
            }
            if (prop.isCollection()) {
                collections.add(prop);
                continue;
            }
            roles.add(prop);
        }
        iter = attributes.iterator();
        while (iter.hasNext()) {
            this.copyProperty(source, target, (Property)iter.next());
        }
        iter = roles.iterator();
        while (iter.hasNext()) {
            this.copyProperty(source, target, (Property)iter.next());
        }
        iter = collections.iterator();
        while (iter.hasNext()) {
            this.copyProperty(source, target, (Property)iter.next());
        }
    }

    protected void copyProperty(DomainObject source, DomainObject target, Property prop) {
        this.m_trace.enter("copyProperty", (Object)source, (Object)target, (Object)prop);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Considering property " + prop + " for copying"));
        }
        if (prop.isKeyProperty()) {
            s_log.debug((Object)"The property is one of the key properties; skipping it");
        } else {
            s_log.debug((Object)"Copying is enabled; proceeding");
            if (prop.isAttribute()) {
                this.copyAttribute(source, target, prop);
            } else {
                this.copyRole(source, target, prop);
            }
        }
        this.m_trace.exit("copyProperty");
    }

    protected void copyAttribute(DomainObject source, DomainObject target, Property prop) {
        this.m_trace.enter("copyAttribute", (Object)source, (Object)target, (Object)prop);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Copying attribute " + prop + " by value"));
        }
        String name = prop.getName();
        DomainCopier.set((DomainObject)target, (String)name, (Object)DomainCopier.get((DomainObject)source, (String)name));
        this.m_trace.exit("copyAttribute");
    }

    protected void copyRole(DomainObject source, DomainObject target, Property prop) {
        this.m_trace.enter("copyRole", (Object)source, (Object)target, (Object)prop);
        String name = prop.getName();
        if (this.m_traversed.contains(source, prop)) {
            s_log.debug((Object)"The role belongs to a link that has already been traversed; skipping it");
        } else {
            this.m_traversed.add(source, prop);
            if (prop.isCollection()) {
                s_log.debug((Object)"The property is a 0..n association");
                this.copyCollection(source, target, prop);
            } else if (prop.isRequired()) {
                s_log.debug((Object)"The property is a 1..1 association");
                DataObject data = (DataObject)DomainCopier.get((DomainObject)source, (String)name);
                Assert.exists((Object)data, DataObject.class);
                DomainObject domain = this.domain(data);
                this.m_traversed.add(domain, prop.getAssociatedProperty());
                DomainCopier.set((DomainObject)target, (String)name, (Object)this.copy(source, target, domain, prop));
            } else if (prop.isNullable()) {
                s_log.debug((Object)"The property is a 0..1 association");
                DataObject data = (DataObject)DomainCopier.get((DomainObject)source, (String)name);
                if (data == null) {
                    DomainCopier.set((DomainObject)target, (String)name, null);
                } else {
                    DomainObject domain = this.domain(data);
                    this.m_traversed.add(domain, prop.getAssociatedProperty());
                    DomainCopier.set((DomainObject)target, (String)name, (Object)this.copy(source, target, this.domain(data), prop));
                }
            } else {
                Assert.fail((String)"Unknown property type");
            }
        }
        this.m_trace.exit("copyRole");
    }

    protected void copyCollection(DomainObject source, DomainObject target, Property prop) {
        this.m_trace.enter("copyCollection", (Object)source, (Object)target, (Object)prop);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Copying collection " + prop));
        }
        String name = prop.getName();
        DataAssociation sass = (DataAssociation)DomainCopier.get((DomainObject)source, (String)name);
        DataAssociationCursor scursor = sass.cursor();
        Property reverse = prop.getAssociatedProperty();
        while (scursor.next()) {
            DomainObject selem = this.domain(scursor.getDataObject());
            this.m_traversed.add(selem, reverse);
            DomainObject telem = this.copy(source, target, selem, prop);
            DataObject tgtLink = null;
            if (telem != null) {
                tgtLink = DomainCopier.add((DomainObject)target, (String)name, (DomainObject)telem);
            }
            if (tgtLink == null) continue;
            this.copyData(new WrapperDomainObject(scursor.getLink()), new WrapperDomainObject(tgtLink));
        }
        this.m_trace.exit("copyCollection");
    }

    protected DomainObject copy(DomainObject source, DomainObject target, DomainObject object, Property prop) {
        this.m_trace.enter("copy", (Object)object, (Object)prop);
        if (prop.isComponent()) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"The property is a component; copying by value");
            }
            DomainObject copy = this.copy(object);
            this.m_trace.exit("copy", (Object)copy);
            return copy;
        }
        s_log.debug((Object)"The property is not a component; copying by reference");
        this.m_trace.exit("copy", (Object)object);
        return object;
    }

    public DomainObject getCopy(OID oid) {
        return (DomainObject)this.m_copied.get(oid);
    }

    protected DomainObject domain(DataObject data) {
        Assert.exists((Object)data, DataObject.class);
        DomainObject domain = DomainObjectFactory.newInstance((DataObject)data);
        Assert.exists((Object)domain, DomainObject.class);
        return domain;
    }

    protected final class WrapperDomainObject
    extends DomainObject {
        public WrapperDomainObject(DataObject dobj) {
            super(dobj);
        }

        public WrapperDomainObject(OID oid) {
            super(oid);
        }
    }

    protected static class TraversedSet
    extends HashSet {
        protected TraversedSet() {
        }

        void add(DomainObject object, Property prop) {
            Assert.exists((Object)object, DomainObject.class);
            if (prop != null) {
                this.add(object.getOID() + "." + prop.getName());
            }
        }

        boolean contains(DomainObject object, Property prop) {
            Assert.exists((Object)object, DomainObject.class);
            Assert.exists((Object)prop, Property.class);
            return this.contains(object.getOID() + "." + prop.getName());
        }
    }
}

