/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.BinaryAsset;
import com.arsdigita.cms.FileAssetCollection;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Locale;

public class FileAsset
extends BinaryAsset {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.FileAsset";
    public static final String CONTENT = "content";
    public static final String HEIGHT = "height";
    public static final String LENGTH = "length";
    public static final String WIDTH = "width";

    public FileAsset() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public FileAsset(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public FileAsset(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public FileAsset(DataObject obj) {
        super(obj);
    }

    public FileAsset(String type) {
        super(type);
    }

    @Override
    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public BigDecimal getWidth() {
        return (BigDecimal)this.get(WIDTH);
    }

    public void setWidth(BigDecimal width) {
        this.set(WIDTH, width);
    }

    public BigDecimal getHeight() {
        return (BigDecimal)this.get(HEIGHT);
    }

    public void setHeight(BigDecimal height) {
        this.set(HEIGHT, height);
    }

    @Override
    public byte[] getContent() {
        return (byte[])this.get(CONTENT);
    }

    @Override
    protected void setContent(byte[] content) {
        this.set(CONTENT, content);
        this.setLength();
    }

    public Long getLength() {
        this.setLength();
        return (Long)this.get(LENGTH);
    }

    public void setLength(Long length) {
        this.set(LENGTH, length);
    }

    public void setLength() {
        Long length = new Long(super.getSize());
        this.setLength(length);
    }

    public void loadFromFile(String fileName, File file, String defaultMimeType) throws IOException {
        MimeType mime = MimeType.guessMimeTypeFromFile((String)fileName);
        if (mime == null && defaultMimeType != null) {
            mime = MimeType.loadMimeType((String)defaultMimeType);
        }
        this.setMimeType(mime);
        int i = fileName.lastIndexOf("/");
        if (i > 0) {
            fileName = fileName.substring(i + 1);
        }
        if ((i = fileName.lastIndexOf("\\")) > 0) {
            fileName = fileName.substring(i + 1);
        }
        this.setName(fileName);
        FileInputStream in = new FileInputStream(file);
        this.readBytes(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToFile(File file) throws IOException {
        FileOutputStream fs = new FileOutputStream(file);
        try {
            fs.write(this.getContent());
        }
        finally {
            if (null != fs) {
                fs.close();
            }
        }
    }

    public static FileAssetCollection getAllFiles() {
        DataCollection da = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        return new FileAssetCollection(da);
    }

    public static FileAssetCollection getFilesByKeyword(String keyword, String context) {
        FileAssetCollection c = FileAsset.getAllFiles();
        c.addOrder("name");
        Filter f = c.addFilter("name like ('%' || :keyword || '%')");
        f.set("keyword", (Object)keyword);
        f = c.addFilter("version = :version");
        f.set("version", (Object)context);
        return c;
    }

    public static FileAssetCollection getFilesByKeyword(String keyword) {
        return FileAsset.getFilesByKeyword(keyword, "draft");
    }

    @Override
    protected void beforeSave() {
        if (null == this.getLanguage()) {
            this.setLanguage(Locale.getDefault().getLanguage());
        }
        super.beforeSave();
    }
}

