/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.DomainCopier;
import com.arsdigita.cms.ObjectCopier;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.metadata.Property;
import org.apache.log4j.Logger;

public class LanguageAwareObjectCopier
extends ObjectCopier {
    private static final Logger logger = Logger.getLogger(LanguageAwareObjectCopier.class);
    private String language;

    public LanguageAwareObjectCopier(String language) {
        this.language = language;
    }

    @Override
    protected void copyCollection(DomainObject source, DomainObject target, Property prop) {
        if (source instanceof ContentPage) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Copying collection " + prop));
            }
            String name = prop.getName();
            DataAssociation sass = (DataAssociation)LanguageAwareObjectCopier.get((DomainObject)source, (String)name);
            DataAssociationCursor scursor = sass.cursor();
            Property reverse = prop.getAssociatedProperty();
            while (scursor.next()) {
                DomainObject selem = this.domain(scursor.getDataObject());
                this.m_traversed.add(selem, reverse);
                Object telem = this.copy(source, target, selem, prop);
                if (telem instanceof ContentPage && ((ContentPage)telem).getContentBundle() != null) {
                    telem = ((ContentPage)telem).getContentBundle().getInstance(this.language);
                }
                DataObject tgtLink = null;
                if (telem != null) {
                    tgtLink = LanguageAwareObjectCopier.add((DomainObject)target, (String)name, (DomainObject)telem);
                }
                if (tgtLink == null) continue;
                this.copyData((DomainCopier)this.new DomainCopier.WrapperDomainObject(scursor.getLink()), (DomainCopier)this.new DomainCopier.WrapperDomainObject(tgtLink));
            }
        } else {
            super.copyCollection(source, target, prop);
        }
    }
}

