/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.LoaderConfig;
import com.arsdigita.cms.Service;
import com.arsdigita.cms.Workspace;
import com.arsdigita.cms.contentsection.ContentSectionConfig;
import com.arsdigita.cms.contentsection.ContentSectionSetup;
import com.arsdigita.cms.contenttypes.XMLContentTypeHandler;
import com.arsdigita.cms.portlet.ContentDirectoryPortlet;
import com.arsdigita.cms.portlet.ContentItemPortlet;
import com.arsdigita.cms.portlet.ContentSectionsPortlet;
import com.arsdigita.cms.portlet.TaskPortlet;
import com.arsdigita.cms.util.Util;
import com.arsdigita.formbuilder.util.FormbuilderSetup;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.loader.PackageLoader;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.runtime.ScriptContext;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.StringArrayParameter;
import com.arsdigita.web.Application;
import com.arsdigita.web.ApplicationType;
import com.arsdigita.xml.XML;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.xml.sax.helpers.DefaultHandler;

public class Loader
extends PackageLoader {
    private static final Logger s_log = Logger.getLogger(Loader.class);
    private static final LoaderConfig s_conf = LoaderConfig.getInstance();
    private final Parameter m_contentSectionNames = new StringArrayParameter("com.arsdigita.cms.loader.section_names", 1, (Object)new String[]{"content"});
    private ArrayList m_content_type_list = new ArrayList();

    public Loader() {
        s_log.debug((Object)"CMS.loader (Constructor) invoked");
        this.register(this.m_contentSectionNames);
        s_log.debug((Object)"CMS.loader (Constructor) completed");
    }

    public void run(ScriptContext ctx) {
        s_log.debug((Object)"CMS.loader.run() invoked");
        new KernelExcursion(){

            public void excurse() {
                this.setEffectiveParty(Kernel.getSystemParty());
                ApplicationType appType = Loader.loadWorkspaceApplicationType();
                Loader.setupDefaultWorkspaceApplicationInstance(appType);
                appType = Loader.loadServiceApplicationType();
                Loader.setupDefaultServiceApplicationInstance(appType);
                Loader.this.loadContentTypeDefinitions(s_conf.getCTDefFiles());
                Loader.this.loadContentSection((String[])Loader.this.get(Loader.this.m_contentSectionNames));
                s_log.debug((Object)"CMS.loader going to load portlets");
                ContentDirectoryPortlet.loadPortletType();
                ContentItemPortlet.loadPortletType();
                ContentSectionsPortlet.loadPortletType();
                TaskPortlet.loadPortletType();
                FormbuilderSetup fbs = new FormbuilderSetup();
                fbs.setup(s_conf.getWidgetTypes(), s_conf.getProcessListenerTypes(), s_conf.getDataQueries());
            }
        }.run();
    }

    public static ApplicationType loadWorkspaceApplicationType() {
        s_log.debug((Object)"Creating CMS Workspace...");
        ApplicationType type = new ApplicationType("Content Center", "com.arsdigita.cms.Workspace");
        type.setDescription("The content center workspace for content creators.");
        type.save();
        s_log.debug((Object)"CMS Workspace type created.");
        return type;
    }

    public static void setupDefaultWorkspaceApplicationInstance(ApplicationType workspaceType) {
        s_log.debug((Object)"Creating CMS Workspace instance ...");
        Workspace app = (Workspace)Application.createApplication((String)"com.arsdigita.cms.Workspace", (String)"content-center", (String)"Content Center", null);
        app.setDescription("The default CMS workspace instance.");
        app.save();
        s_log.debug((Object)"CMS Workspace instance content-center created.");
        s_log.debug((Object)"Done loading CMS Workspace.");
    }

    public static ApplicationType loadServiceApplicationType() {
        s_log.debug((Object)"Loading CMS Servce Package...");
        ApplicationType type = new ApplicationType("CMS Service", "com.arsdigita.cms.Service");
        type.setDescription("Services to store global resources and assets.");
        type.save();
        return type;
    }

    public static void setupDefaultServiceApplicationInstance(ApplicationType serviceType) {
        Service app = (Service)Application.createApplication((ApplicationType)serviceType, (String)"cms-service", (String)"CMS Service Instance", null);
        app.setDescription("The default CMS service instance.");
        app.save();
        s_log.debug((Object)"Done creating CMS Service Package.");
    }

    private void loadContentSection(String[] sectionNames) {
        ApplicationType type = new ApplicationType("Content Section", "com.arsdigita.cms.ContentSection");
        type.setDescription("The CMS Content Section application.");
        type.save();
        Loader.createPrivileges();
        for (int i = 0; i < sectionNames.length; ++i) {
            String sectionName = sectionNames[i];
            s_log.debug((Object)("Creating content section on /" + sectionName));
            Util.validateURLParameter("name", sectionName);
            ContentSectionConfig conf = new ContentSectionConfig();
            conf.load();
            ContentSectionSetup.setupContentSectionAppInstance(sectionName, conf.getDefaultRoles(), conf.getDefaultWorkflows(), s_conf.isPubliclyViewable(), s_conf.getItemResolverClass(), s_conf.getTemplateResolverClass(), this.m_content_type_list, s_conf.getUseSectionCategories(), s_conf.getCategoryFileList());
        }
    }

    private void loadContentTypeDefinitions(List ctDefFiles) {
        s_log.debug((Object)"Loading content type definitions ...");
        if (ctDefFiles != null) {
            XMLContentTypeHandler handler = new XMLContentTypeHandler();
            for (String xmlFile : ctDefFiles) {
                s_log.debug((Object)("Processing contentTypes in: " + xmlFile));
                XML.parseResource((String)xmlFile, (DefaultHandler)handler);
            }
            for (ContentType ct : handler.getContentTypes()) {
                if (ct.isInternal().booleanValue()) continue;
                this.m_content_type_list.add(ct.getClassName());
            }
        }
        s_log.debug((Object)"Done loading content type definitions.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createPrivileges() {
        s_log.debug((Object)"Creating Privileges...");
        String CMS_PRIVILEGES = "com.arsdigita.cms.getPrivileges";
        String PRIVILEGE = "privilege";
        DataQuery dq = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.getPrivileges");
        try {
            while (dq.next()) {
                String privilege = (String)dq.get("privilege");
                s_log.debug((Object)String.format("privilege = %s", privilege));
                if (PrivilegeDescriptor.get((String)privilege) != null) continue;
                PrivilegeDescriptor.createPrivilege((String)privilege);
            }
        }
        finally {
            dq.close();
        }
        s_log.debug((Object)"Done creating Privileges.");
    }
}

