/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.publishToFile.QueueManager;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainServiceInterfaceExposer;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

class PublishedLink
extends DomainObject {
    private static final Logger s_log = Logger.getLogger(PublishedLink.class);
    static final String SOURCE_MASTER_ITEM = "pending";
    static final String PENDING_SOURCE = "pendingSource";
    static final String PROPERTY_NAME = "propertyName";
    static final String DRAFT_TARGET = "draftTarget";
    static final String LINK_ATTRIBUTES = "linkAttributes";
    static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.PublishedLink";

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    protected PublishedLink() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    protected PublishedLink(DataObject data) {
        super(data);
    }

    protected PublishedLink(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    static PublishedLink create(ContentItem sourceMasterItem, DomainObject linkSource, String propertyName, ContentItem linkTarget, ContentItem sourceObject) {
        OID oid = new OID(BASE_DATA_OBJECT_TYPE);
        oid.set(SOURCE_MASTER_ITEM, (Object)DomainServiceInterfaceExposer.getDataObject((DomainObject)sourceMasterItem));
        oid.set(PROPERTY_NAME, (Object)propertyName);
        oid.set(DRAFT_TARGET, (Object)DomainServiceInterfaceExposer.getDataObject((DomainObject)linkTarget));
        if (linkSource instanceof ACSObject) {
            oid.set(PENDING_SOURCE, (Object)DomainServiceInterfaceExposer.getDataObject((DomainObject)linkSource));
        } else {
            Assert.fail((String)("Cannot set PublishedLink source " + linkSource + "; it is not an " + "ACSObject"));
        }
        PublishedLink link = null;
        try {
            link = new PublishedLink(oid);
        }
        catch (DataObjectNotFoundException e) {
            link = new PublishedLink(SessionManager.getSession().create(oid));
        }
        if (sourceObject != null && sourceObject.getObjectType().getProperty(propertyName).isCollection()) {
            DataCollection coll = (DataCollection)sourceObject.get(propertyName + "@link");
            while (coll.next()) {
                DataObject linkObj = coll.getDataObject();
                if (!linkTarget.getOID().equals((Object)((DataObject)linkObj.getOID().get(propertyName)).getOID())) continue;
                link.saveLinkAttributes(linkObj);
                coll.close();
            }
        }
        return link;
    }

    ContentItem getSourceMasterItem() {
        DataObject item = (DataObject)this.get(SOURCE_MASTER_ITEM);
        return item == null ? null : (ContentItem)DomainObjectFactory.newInstance((DataObject)item);
    }

    DomainObject getLinkSource() {
        DataObject item = (DataObject)this.get(PENDING_SOURCE);
        return item == null ? null : DomainObjectFactory.newInstance((DataObject)item);
    }

    String getPropertyName() {
        return (String)this.get(PROPERTY_NAME);
    }

    ContentItem getLinkTarget() {
        DataObject item = (DataObject)this.get(DRAFT_TARGET);
        return item == null ? null : (ContentItem)DomainObjectFactory.newInstance((DataObject)item);
    }

    public static void updateLiveLinks(ContentItem item) {
        Session session = SessionManager.getSession();
        HashSet itemsToRefresh = new HashSet();
        ContentItem draftItem = item.getDraftVersion();
        DataCollection linksToItem = session.retrieve(BASE_DATA_OBJECT_TYPE);
        linksToItem.addEqualsFilter("draftTarget.id", (Object)draftItem.getID());
        linksToItem.addEqualsFilter("pending.version", (Object)"live");
        PublishedLink.updateLiveLinksFromCollection(linksToItem, itemsToRefresh);
        linksToItem.close();
        DataCollection linksFromItem = session.retrieve(BASE_DATA_OBJECT_TYPE);
        linksFromItem.addEqualsFilter("pending.id", (Object)item.getID());
        PublishedLink.updateLiveLinksFromCollection(linksFromItem, null);
        linksFromItem.close();
        for (OID oid : itemsToRefresh) {
            ContentItem refreshItem = (ContentItem)DomainObjectFactory.newInstance((OID)oid);
            if (!refreshItem.canPublishToFS()) continue;
            QueueManager.queueRepublish(refreshItem);
        }
    }

    private static void updateLiveLinksFromCollection(DataCollection coll, Set itemsToRefresh) {
        while (coll.next()) {
            DataObject master = (DataObject)coll.get(SOURCE_MASTER_ITEM);
            DataObject src = (DataObject)coll.get(PENDING_SOURCE);
            src.specialize((String)src.get("objectType"));
            String propertyName = (String)coll.get(PROPERTY_NAME);
            byte[] linkAttributes = (byte[])coll.get(LINK_ATTRIBUTES);
            Assert.exists((Object)src, DataObject.class);
            Assert.exists((Object)propertyName, String.class);
            DataObject target = null;
            DataObject draftTarget = (DataObject)coll.get(DRAFT_TARGET);
            DataAssociationCursor targetVersions = ((DataAssociation)draftTarget.get("slaveVersions")).cursor();
            targetVersions.addEqualsFilter("version", (Object)"live");
            if (targetVersions.next()) {
                target = targetVersions.getDataObject();
            }
            targetVersions.close();
            if (target == null) continue;
            ObjectType ot = src.getObjectType();
            Property prop = ot.getProperty(propertyName);
            Assert.exists((Object)prop, (String)(propertyName + " for type " + ot.getQualifiedName() + ", ID: " + src.get("id")));
            if (prop.isCollection()) {
                DataAssociation da = (DataAssociation)src.get(propertyName);
                PublishedLink.setLinkAttributesForLiveLink(da.add(target), linkAttributes);
            } else {
                src.set(propertyName, (Object)target);
            }
            if (itemsToRefresh == null || master == null) continue;
            itemsToRefresh.add(master.getOID());
        }
    }

    public static void refreshOnUnpublish(ContentItem item) {
        Session session = SessionManager.getSession();
        HashSet<OID> itemsToRefresh = new HashSet<OID>();
        DataCollection linksToItem = session.retrieve(BASE_DATA_OBJECT_TYPE);
        linksToItem.addEqualsFilter("draftTarget.id", (Object)item.getID());
        linksToItem.addEqualsFilter("pending.version", (Object)"live");
        while (linksToItem.next()) {
            DataObject master = (DataObject)linksToItem.get(SOURCE_MASTER_ITEM);
            if (master == null) continue;
            itemsToRefresh.add(master.getOID());
        }
        for (OID oid : itemsToRefresh) {
            ContentItem refreshItem = (ContentItem)DomainObjectFactory.newInstance((OID)oid);
            if (!refreshItem.canPublishToFS()) continue;
            QueueManager.queueRepublish(refreshItem);
        }
    }

    private void saveLinkAttributes(DataObject linkObj) {
        Iterator properties = linkObj.getObjectType().getDeclaredProperties();
        HashMap<String, Object> linkAttributes = new HashMap<String, Object>();
        while (properties.hasNext()) {
            Property prop = (Property)properties.next();
            String key = prop.getName();
            if (!prop.isAttribute() || prop.isKeyProperty()) continue;
            Object value = linkObj.get(key);
            linkAttributes.put(key, value);
        }
        if (linkAttributes.size() > 0) {
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            try {
                ObjectOutputStream out = new ObjectOutputStream(data);
                out.writeObject(linkAttributes);
            }
            catch (IOException ex) {
                throw new UncheckedWrapperException((Throwable)ex);
            }
            this.set(LINK_ATTRIBUTES, data.toByteArray());
        }
    }

    private static void setLinkAttributesForLiveLink(DataObject link, byte[] linkAttributes) {
        if (linkAttributes != null) {
            ByteArrayInputStream data = null;
            ObjectInputStream in = null;
            HashMap attributes = null;
            data = new ByteArrayInputStream(linkAttributes);
            try {
                in = new ObjectInputStream(data);
                try {
                    attributes = (HashMap)in.readObject();
                }
                catch (ClassNotFoundException ex) {
                    s_log.error((Object)"Class HashMap not found? WTF?");
                    return;
                }
            }
            catch (IOException ex) {
                s_log.error((Object)"Can't read HashMap from database");
                return;
            }
            if (attributes != null) {
                for (String propertyName : attributes.keySet()) {
                    Object value = attributes.get(propertyName);
                    if (!link.getObjectType().hasDeclaredProperty(propertyName) || link.getSession() == null) continue;
                    link.set(propertyName, value);
                }
            }
        }
    }
}

