/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.RelationAttribute;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.SessionManager;

public class RelationAttributeCollection
extends DomainCollection {
    public static String ATTRIBUTE = "attribute";
    public static String KEY = "attr_key";
    public static String LANGUAGE = "lang";
    public static String NAME = "name";
    public static String DESCRIPTION = "description";
    private Filter m_attributeFilter = null;
    private Filter m_keyFilter = null;
    private Filter m_languageFilter = null;

    public RelationAttributeCollection() {
        super(SessionManager.getSession().retrieve("com.arsdigita.cms.RelationAttribute"));
    }

    public RelationAttributeCollection(String attribute) {
        this();
        this.addAttributeFilter(attribute);
        this.addOrder(KEY + ", " + LANGUAGE);
    }

    public RelationAttributeCollection(String attribute, String key) {
        this(attribute);
        this.addKeyFilter(key);
    }

    public RelationAttributeCollection(DataCollection dataCollection) {
        super(dataCollection);
    }

    public RelationAttribute getRelationAttribute() {
        return new RelationAttribute(this.m_dataCollection.getDataObject());
    }

    public final void addAttributeFilter(String attribute) {
        this.m_attributeFilter = this.addEqualsFilter(ATTRIBUTE, attribute);
    }

    public boolean removeAttributeFilter(String attribute) {
        boolean retVal = false;
        retVal = this.removeFilter(this.m_attributeFilter);
        if (retVal) {
            this.m_attributeFilter = null;
        }
        return retVal;
    }

    public final void addKeyFilter(String key) {
        this.m_keyFilter = this.addEqualsFilter(KEY, key);
    }

    public boolean removeKeyFilter(String key) {
        boolean retVal = false;
        retVal = this.removeFilter(this.m_keyFilter);
        if (retVal) {
            this.m_keyFilter = null;
        }
        return retVal;
    }

    public void addLanguageFilter(String language) {
        this.m_languageFilter = this.addEqualsFilter(LANGUAGE, language);
    }

    public boolean removeLanguageFilter(String language) {
        boolean retVal = false;
        retVal = this.removeFilter(this.m_languageFilter);
        if (retVal) {
            this.m_languageFilter = null;
        }
        return retVal;
    }

    public void removeAllFilters() {
        this.removeAllFilters();
    }

    public final String getKey() {
        if (this.isBeforeFirst()) {
            this.next();
        }
        return (String)this.get(KEY);
    }

    public final String getLanguage() {
        if (this.isBeforeFirst()) {
            this.next();
        }
        return (String)this.get(LANGUAGE);
    }

    public RelationAttribute getRelationAttribute(String key, String language) {
        if (!this.isBeforeFirst() && key.equals(this.getKey()) && language.equals(this.getLanguage())) {
            return this.getRelationAttribute();
        }
        this.rewind();
        while (this.next()) {
            if (!this.getKey().equals(key) || !this.getLanguage().equals(language)) continue;
            return this.getRelationAttribute();
        }
        return null;
    }

    public String getName() {
        if (this.isBeforeFirst()) {
            this.next();
        }
        return this.getRelationAttribute().getName();
    }

    public String getDescription() {
        if (this.isBeforeFirst()) {
            this.next();
        }
        return this.getRelationAttribute().getDescription();
    }

    public boolean hasLanguage(String language) {
        boolean retVal = false;
        this.addLanguageFilter(language);
        if (this.size() > 0L) {
            retVal = true;
        }
        this.removeLanguageFilter(language);
        return retVal;
    }
}

