/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.ImageAsset;
import com.arsdigita.cms.ImageAssetCollection;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.mimetypes.ImageMimeType;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import org.apache.log4j.Logger;

public class ReusableImageAsset
extends ImageAsset {
    private static final Logger s_log = Logger.getLogger(ReusableImageAsset.class);
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.ReusableImageAsset";

    public ReusableImageAsset() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public ReusableImageAsset(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public ReusableImageAsset(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public ReusableImageAsset(DataObject obj) {
        super(obj);
    }

    public ReusableImageAsset(String type) {
        super(type);
    }

    @Override
    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    @Override
    public BigDecimal getWidth() {
        return (BigDecimal)this.get("width");
    }

    @Override
    public void setWidth(BigDecimal width) {
        this.set("width", width);
    }

    @Override
    public BigDecimal getHeight() {
        return (BigDecimal)this.get("height");
    }

    @Override
    public void setHeight(BigDecimal height) {
        this.set("height", height);
    }

    @Override
    protected byte[] getContent() {
        return (byte[])this.get("content");
    }

    @Override
    protected void setContent(byte[] content) {
        this.set("content", content);
    }

    @Override
    public void loadFromFile(String fileName, File file, String defaultMimeType) throws IOException {
        MimeType mime = MimeType.guessMimeTypeFromFile((String)fileName);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Mime type is " + (null == mime ? "null" : mime.getMimeType())));
        }
        RenderedOp image = JAI.create((String)"FileLoad", (Object)file.getPath());
        int width = image.getWidth();
        int height = image.getHeight();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Width: " + width));
            s_log.debug((Object)("Height: " + height));
        }
        if (s_log.isDebugEnabled()) {
            String[] props = image.getPropertyNames();
            for (int i = 0; i < props.length; ++i) {
                String prop = props[i];
                s_log.debug((Object)(prop + ": " + image.getProperty(prop)));
            }
        }
        this.setWidth(new BigDecimal(width));
        this.setHeight(new BigDecimal(height));
        if (mime == null || !(mime instanceof ImageMimeType)) {
            mime = MimeType.loadMimeType((String)defaultMimeType);
        }
        this.setMimeType(mime);
        int i = fileName.lastIndexOf("/");
        if (i > 0) {
            fileName = fileName.substring(i + 1);
        }
        if ((i = fileName.lastIndexOf("\\")) > 0) {
            fileName = fileName.substring(i + 1);
        }
        this.setName(fileName);
        FileInputStream in = new FileInputStream(file);
        this.readBytes(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToFile(File file) throws IOException {
        FileOutputStream fs = new FileOutputStream(file);
        try {
            fs.write(this.getContent());
        }
        finally {
            if (null != fs) {
                fs.close();
            }
        }
    }

    public static ImageAssetCollection getAllReusableImages() {
        DataCollection da = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        da.addFilter(String.format("%s = '%s'", "isDeleted", "0"));
        da.addFilter(String.format("%s = '%s'", "objectType", BASE_DATA_OBJECT_TYPE));
        return new ImageAssetCollection(da);
    }

    public static ImageAssetCollection getReusableImagesByKeyword(String keyword, String context) {
        Filter f;
        ImageAssetCollection c = ReusableImageAsset.getAllReusableImages();
        c.addOrder("name");
        if (keyword != null && keyword.length() >= 1) {
            f = c.addFilter("lower(name) like lower('%' || :keyword || '%')");
            f.set("keyword", (Object)keyword);
        }
        f = c.addFilter("version = :version");
        f.set("version", (Object)context);
        return c;
    }

    public static ImageAssetCollection getReusableImagesByKeyword(String keyword) {
        return ReusableImageAsset.getReusableImagesByKeyword(keyword, "draft");
    }
}

