/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.SectionTemplateCollection;
import com.arsdigita.cms.Template;
import com.arsdigita.cms.TemplateMapping;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class SectionTemplateMapping
extends TemplateMapping {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.SectionTemplateMapping";
    public static final String SECTION = "section";
    public static final String CONTENT_TYPE = "contentType";
    private static final Logger logger = Logger.getLogger(SectionTemplateMapping.class);

    public SectionTemplateMapping() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public SectionTemplateMapping(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public SectionTemplateMapping(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public SectionTemplateMapping(DataObject obj) {
        super(obj);
    }

    public SectionTemplateMapping(String type) {
        super(type);
        this.setDefault(Boolean.FALSE);
        this.setUseContext("public");
    }

    @Override
    public final ContentSection getContentSection() {
        return (ContentSection)DomainObjectFactory.newInstance((DataObject)((DataObject)this.get(SECTION)));
    }

    public final void setContentSection(ContentSection sec) {
        Assert.exists((Object)((Object)sec));
        this.setAssociation(SECTION, (DomainObject)sec);
    }

    @Override
    public ACSObject getParent() {
        return this.getContentType();
    }

    public final ContentType getContentType() {
        return (ContentType)DomainObjectFactory.newInstance((DataObject)((DataObject)this.get(CONTENT_TYPE)));
    }

    public final void setContentType(ContentType t) {
        Assert.exists((Object)((Object)t));
        this.setAssociation(CONTENT_TYPE, (DomainObject)t);
    }

    @Override
    public Boolean isDefault() {
        return (Boolean)this.get("isDefault");
    }

    @Override
    public void setDefault(Boolean b) {
        Assert.exists((Object)b);
        this.set("isDefault", b);
    }

    protected static SectionTemplateMapping getMapping(ContentSection section, ContentType type, Template template, String useContext) {
        return SectionTemplateMapping.getMapping(section, type, template, useContext, MimeType.loadMimeType((String)"text/x-jsp"));
    }

    protected static SectionTemplateMapping getMapping(ContentSection section, ContentType type, Template template, String useContext, MimeType mimeType) {
        SectionTemplateCollection c = SectionTemplateMapping.getTemplates(section, type, useContext);
        c.addEqualsFilter("template.id", template.getID());
        String mimeString = null;
        if (mimeType != null) {
            mimeString = mimeType.getMimeType();
        }
        if (!c.next()) {
            return null;
        }
        SectionTemplateMapping m = (SectionTemplateMapping)c.getDomainObject();
        Assert.isTrue((!c.next() ? 1 : 0) != 0);
        c.close();
        return m;
    }

    protected static Template getDefaultTemplate(ContentSection section, ContentType type, String useContext, MimeType mimeType) {
        SectionTemplateCollection c = SectionTemplateMapping.getDefaultTemplates(section, type, useContext);
        String mimeString = null;
        if (mimeType != null) {
            mimeString = mimeType.getMimeType();
        }
        c.addEqualsFilter("template.mimeType.mimeType", mimeString);
        if (!c.next()) {
            return null;
        }
        SectionTemplateMapping m = (SectionTemplateMapping)c.getDomainObject();
        Assert.isTrue((!c.next() ? 1 : 0) != 0);
        c.close();
        return m.getTemplate();
    }

    protected static Template getDefaultTemplate(ContentSection section, ContentType type, String useContext) {
        SectionTemplateCollection c = SectionTemplateMapping.getTemplates(section, type, useContext);
        c.addEqualsFilter("isDefault", new Boolean(true));
        if (!c.next()) {
            return null;
        }
        SectionTemplateMapping m = (SectionTemplateMapping)c.getDomainObject();
        Assert.isTrue((!c.next() ? 1 : 0) != 0);
        c.close();
        return m.getTemplate();
    }

    protected static SectionTemplateCollection getDefaultTemplates(ContentSection section, ContentType type, String useContext) {
        SectionTemplateCollection c = SectionTemplateMapping.getTemplates(section, type, useContext);
        c.addEqualsFilter("isDefault", new Boolean(true));
        return c;
    }

    protected static SectionTemplateCollection getTemplates(ContentSection section, ContentType type, String useContext) {
        SectionTemplateCollection c = SectionTemplateMapping.getTemplates(section, type);
        c.addEqualsFilter("useContext", useContext);
        return c;
    }

    protected static SectionTemplateCollection getTemplates(ContentSection section, ContentType type) {
        SectionTemplateCollection c = SectionTemplateMapping.getTemplates(section);
        c.addEqualsFilter("contentType.id", type.getID());
        return c;
    }

    protected static SectionTemplateCollection getTemplates(ContentSection section) {
        DataCollection da = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        SectionTemplateCollection c = new SectionTemplateCollection(da);
        c.addEqualsFilter("section.id", section.getID());
        c.addOrder("contentType.label");
        c.addOrder("useContext");
        c.addOrder("template.name");
        return c;
    }
}

