/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.BinaryAsset;
import com.arsdigita.cms.ImageAsset;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.web.Application;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class Service
extends Application {
    private static final Logger s_log = Logger.getLogger(Service.class);
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.Service";
    public static final String PRIMARY_URL_STUB = "cms-service";

    public Service(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public Service(BigDecimal key) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)key));
    }

    public Service(DataObject dataObject) {
        super(dataObject);
    }

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public static String getURL() {
        return "/cms-service/";
    }

    public static String getAssetURL(BinaryAsset asset) {
        return Service.getAssetURL(asset.getID());
    }

    public static String getAssetURL(BigDecimal assetId) {
        StringBuilder buf = new StringBuilder(Service.getURL());
        buf.append("stream/asset?");
        buf.append("asset_id").append("=").append(assetId);
        return buf.toString();
    }

    public static String getImageURL(ImageAsset asset) {
        StringBuilder buf = new StringBuilder(Service.getURL());
        buf.append("stream/image/?");
        buf.append("image_id").append("=").append(asset.getID());
        return buf.toString();
    }

    public static String getLogoutURL() {
        StringBuilder buf = new StringBuilder(Service.getURL());
        buf.append("logout");
        return buf.toString();
    }

    public static Service create(String urlName, String title, Application parent) {
        Service app = (Service)Application.createApplication((String)BASE_DATA_OBJECT_TYPE, (String)urlName, (String)title, (Application)parent);
        app.save();
        return app;
    }

    public String getServletPath() {
        return "/templates/servlet/cms-service";
    }
}

