/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Service;
import com.arsdigita.cms.dispatcher.ResourceHandler;
import com.arsdigita.cms.dispatcher.SimpleCache;
import com.arsdigita.developersupport.DeveloperSupport;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Application;
import com.arsdigita.web.ApplicationFileResolver;
import com.arsdigita.web.BaseApplicationServlet;
import com.arsdigita.web.Web;
import com.arsdigita.xml.XML;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.xml.sax.helpers.DefaultHandler;

public class ServiceServlet
extends BaseApplicationServlet {
    private static Logger s_log = Logger.getLogger((String)ServiceServlet.class.getName());
    private static final String MAP_FILE = "WEB-INF/resources/cms-service-map.xml";
    private static HashMap s_pageClasses = new HashMap();
    private static SimpleCache s_pages = new SimpleCache();
    private ArrayList m_trailingSlashList = new ArrayList();
    private String m_templatePath;
    private ApplicationFileResolver m_resolver;

    protected void doInit() {
        if (s_log.isDebugEnabled()) {
            s_log.info((Object)"starting doInit method");
        }
        this.requireTrailingSlash("");
        this.readFromFile(MAP_FILE);
        this.m_templatePath = ContentSection.getConfig().getTemplateRoot();
        Assert.exists((Object)this.m_templatePath, String.class);
        Assert.isTrue((boolean)this.m_templatePath.startsWith("/"), (String)"template-path must start with '/'");
        Assert.isTrue((!this.m_templatePath.endsWith("/") ? 1 : 0) != 0, (String)"template-path must not end with '/'");
        this.m_resolver = Web.getConfig().getApplicationFileResolver();
    }

    protected void doService(HttpServletRequest sreq, HttpServletResponse sresp, Application app) throws ServletException, IOException {
        if (s_log.isDebugEnabled()) {
            s_log.info((Object)"starting doService method");
        }
        DeveloperSupport.startStage((String)"ServiceServlet.doService");
        Service service = (Service)app;
        RequestContext ctx = DispatcherHelper.getRequestContext();
        String url = ctx.getRemainingURLPart();
        String originalUrl = ctx.getOriginalURL();
        String requestUri = sreq.getRequestURI();
        if (this.m_trailingSlashList.contains(url) && !originalUrl.endsWith("/")) {
            DispatcherHelper.sendRedirect((HttpServletRequest)sreq, (HttpServletResponse)sresp, (String)(originalUrl + "/"));
            return;
        }
        ResourceHandler page = this.getResource(url);
        if (page == null) {
            String[] tokens = url.split("/");
            StringBuilder altUrlBuilder = new StringBuilder(47);
            for (int i = 0; i < tokens.length - 1; ++i) {
                altUrlBuilder.append(tokens[i]);
                altUrlBuilder.append('/');
            }
            page = this.getResource(altUrlBuilder.toString());
        }
        if (page != null) {
            page.init();
            page.dispatch(sreq, sresp, ctx);
        } else {
            RequestDispatcher rd;
            if (s_log.isInfoEnabled()) {
                s_log.info((Object)"NO page registered to serve the requst url.");
            }
            if ((rd = this.m_resolver.resolve(this.m_templatePath, sreq, sresp, app)) != null) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Got dispatcher " + rd));
                }
                sreq = DispatcherHelper.restoreOriginalRequest((HttpServletRequest)sreq);
                rd.forward((ServletRequest)sreq, (ServletResponse)sresp);
            } else {
                sresp.sendError(404, requestUri + " not found on this server.");
            }
        }
        DeveloperSupport.endStage((String)"ServiceServlet.doService");
        if (s_log.isDebugEnabled()) {
            s_log.info((Object)"doService method completed");
        }
    }

    protected ResourceHandler getResource(String url) throws ServletException {
        String pageClassName;
        ResourceHandler page = (ResourceHandler)s_pages.get(url);
        if (page == null && (pageClassName = (String)s_pageClasses.get(url)) != null) {
            Class<?> pageClass;
            try {
                pageClass = Class.forName(pageClassName);
            }
            catch (ClassNotFoundException e) {
                s_log.error((Object)"error fetching class for ResourceHandler", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
            try {
                page = (ResourceHandler)pageClass.newInstance();
            }
            catch (InstantiationException e) {
                s_log.error((Object)"error instantiating a ResourceHandler", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                s_log.error((Object)"error instantiating a ResourceHandler", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
            page.init();
            s_pages.put(url, page);
        }
        return page;
    }

    private void readFromFile(String file) {
        XML.parseResource((String)file, (DefaultHandler)new PageClassConfigHandler(s_pageClasses));
    }

    public void requireTrailingSlash(String url) {
        this.m_trailingSlashList.add(url);
    }

    protected static class PageClassConfigHandler
    extends DefaultHandler {
        private Map m_map;
        private StringBuffer m_buffer;
        private String m_url;
        private String m_className;

        public PageClassConfigHandler(Map map) {
            this.m_map = map;
            this.m_buffer = new StringBuffer();
        }

        @Override
        public void characters(char[] ch, int start, int len) {
            for (int i = 0; i < len; ++i) {
                this.m_buffer.append(ch[start + i]);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qn) {
            if (qn.equals("url")) {
                this.m_url = this.m_buffer.toString().trim();
            } else if (qn.equals("page-class")) {
                this.m_className = this.m_buffer.toString().trim();
            } else if (qn.equals("url-mapping")) {
                this.m_map.put(this.m_url, this.m_className);
            }
            this.m_buffer = new StringBuffer();
        }
    }
}

