/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.Template;
import com.arsdigita.cms.TemplateManager;
import com.arsdigita.cms.TemplateManagerFactory;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class StandalonePage
extends ContentPage {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.StandalonePage";
    public static final String TEMPLATE = "template";
    private static Logger s_log = Logger.getLogger(StandalonePage.class);

    public StandalonePage() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public StandalonePage(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public StandalonePage(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public StandalonePage(DataObject obj) {
        super(obj);
    }

    public StandalonePage(String type) {
        super(type);
    }

    public final Template getTemplate() {
        return (Template)DomainObjectFactory.newInstance((DataObject)((DataObject)this.get(TEMPLATE)));
    }

    public final void setTemplate(Template t) {
        this.setAssociation(TEMPLATE, (DomainObject)t);
    }

    public final String getBody() {
        Template t = this.getTemplate();
        if (t == null) {
            return null;
        }
        String text = t.getText();
        return text;
    }

    public final void setBody(String text, MimeType mime) {
        Template t = this.getTemplate();
        boolean isNew = false;
        if (t == null) {
            isNew = true;
            t = new Template();
            t.setName(this.getName() + "_body");
            t.setMimeType(mime);
            t.save();
        }
        t.setText(text);
        if (isNew) {
            this.save();
            t.setParent((ACSObject)this);
            t.save();
        }
    }

    public final void setBody(String text) {
        this.setBody(text, MimeType.loadMimeType((String)"text/x-jsp"));
    }

    @Override
    public void setLive(ContentItem version) {
        Template t = this.getTemplate();
        Assert.exists((Object)t);
        if (version != null) {
            t.createLiveVersion();
        }
        super.setLive(version);
    }

    protected void afterSave() {
        super.afterSave();
        TemplateManager m = TemplateManagerFactory.getInstance();
        Template oldTemplate = m.getTemplate(this, "public");
        Template newTemplate = this.getTemplate();
        if (!newTemplate.equals(oldTemplate)) {
            m.addTemplate(this, newTemplate, "public");
        }
    }
}

