/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.TextAsset;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class Template
extends TextAsset {
    private static Logger s_log = Logger.getLogger(Template.class);
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.Template";
    public static final String LABEL = "label";
    public static final String IS_PUBLISHABLE = "isPublishable";
    public static final String JSP_MIME_TYPE = "text/x-jsp";
    public static final String XSL_MIME_TYPE = "text/xml";
    public static final Map SUPPORTED_MIME_TYPES = new HashMap();

    public Template() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public Template(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public Template(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public Template(DataObject obj) {
        super(obj);
    }

    public Template(String type) {
        super(type);
        MimeType mime = MimeType.loadMimeType((String)JSP_MIME_TYPE);
        this.setMimeType(mime);
        ContentType t = null;
        t = ContentType.findByAssociatedObjectType(BASE_DATA_OBJECT_TYPE);
        this.setContentType(t);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.get(IS_PUBLISHABLE) == null) {
            this.setPublishable(true);
        }
    }

    @Override
    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public String getLabel() {
        return (String)this.get(LABEL);
    }

    public void setLabel(String label) {
        this.set(LABEL, label);
    }

    @Override
    public String getDisplayName() {
        String result = this.getLabel();
        return result != null ? result : super.getDisplayName();
    }

    public Boolean isPublishable() {
        return (Boolean)this.get(IS_PUBLISHABLE);
    }

    public void setPublishable(Boolean isPublishable) {
        this.set(IS_PUBLISHABLE, isPublishable);
    }

    public void setPublishable(boolean isPublishable) {
        this.set(IS_PUBLISHABLE, new Boolean(isPublishable));
    }

    @Override
    public String getPath() {
        String path = this.getPathNoJsp();
        if (!path.endsWith(".jsp")) {
            path = path + ".jsp";
        }
        return path;
    }

    static {
        s_log.debug((Object)"Static initalizer is starting...");
        SUPPORTED_MIME_TYPES.put(JSP_MIME_TYPE, GlobalizationUtil.globalize("mime_type_jsp"));
        SUPPORTED_MIME_TYPES.put(XSL_MIME_TYPE, GlobalizationUtil.globalize("mime_type_xsl"));
        s_log.debug((Object)"Static initalizer finished.");
    }
}

