/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.TemplateContextCollection;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.SessionManager;

public class TemplateContext
extends DomainObject {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.TemplateContext";
    public static final String CONTEXT = "context";
    public static final String LABEL = "label";
    public static final String DESCRIPTION = "description";

    public TemplateContext() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public TemplateContext(DataObject obj) {
        super(obj);
    }

    public static TemplateContext create(String context, String label, String description) {
        TemplateContext tc = new TemplateContext();
        tc.setContext(context);
        tc.setLabel(label);
        tc.setDescription(description);
        return tc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TemplateContext retrieve(String context) throws DataObjectNotFoundException {
        DataCollection da = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        da.setParameter(CONTEXT, (Object)context);
        try {
            if (da.next()) {
                TemplateContext templateContext = (TemplateContext)DomainObjectFactory.newInstance((DataObject)da.getDataObject());
                return templateContext;
            }
        }
        finally {
            da.close();
        }
        throw new DataObjectNotFoundException("cannot find template context " + context);
    }

    public static TemplateContextCollection retrieveAll() {
        DataCollection da = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        TemplateContextCollection c = new TemplateContextCollection(da);
        return c;
    }

    public String getContext() {
        return (String)this.get(CONTEXT);
    }

    public void setContext(String context) {
        this.set(CONTEXT, context);
    }

    public String getLabel() {
        return (String)this.get(LABEL);
    }

    public void setLabel(String label) {
        this.set(LABEL, label);
    }

    public String getDescription() {
        return (String)this.get(DESCRIPTION);
    }

    public void setDescription(String description) {
        this.set(DESCRIPTION, description);
    }
}

