/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Folder;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class UserHomeFolderMap
extends ACSObject {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.UserHomeFolderMap";
    private static final Logger s_log = Logger.getLogger(UserHomeFolderMap.class);
    public static final String USER_ID = "userID";
    public static final String SECTION_ID = "sectionID";
    public static final String HOME_FOLDER = "homeFolder";
    public static final String HOME_SECTION = "homeSection";
    public static final String HOME_FOLDER_USER = "homeFolderUser";

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public UserHomeFolderMap(DataObject dataObj) {
        super(dataObj);
    }

    public UserHomeFolderMap() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public UserHomeFolderMap(String typeName) {
        super(typeName);
    }

    public UserHomeFolderMap(ObjectType type) {
        super(type);
    }

    public UserHomeFolderMap(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public BigDecimal getUserID() {
        return (BigDecimal)this.get(USER_ID);
    }

    public void setUserID(BigDecimal userID) {
        this.set(USER_ID, userID);
    }

    public BigDecimal getSectionID() {
        return (BigDecimal)this.get(SECTION_ID);
    }

    public void setSectionID(BigDecimal sectionID) {
        this.set(SECTION_ID, sectionID);
    }

    public Folder getHomeFolder() {
        DataObject object = (DataObject)this.get(HOME_FOLDER);
        if (object == null) {
            return null;
        }
        return new Folder(object);
    }

    public void setHomeFolder(Folder folder) {
        this.setAssociation(HOME_FOLDER, (DomainObject)folder);
    }

    public ContentSection getHomeSection() {
        DataObject object = (DataObject)this.get(HOME_SECTION);
        if (object == null) {
            return null;
        }
        return new ContentSection(object);
    }

    public void setHomeSection(ContentSection section) {
        this.setAssociation(HOME_SECTION, (DomainObject)section);
    }

    public User getHomeFolderUser() {
        DataObject object = (DataObject)this.get(HOME_FOLDER_USER);
        if (object == null) {
            return null;
        }
        return new User(object);
    }

    public void setHomeFolderUser(User user) {
        this.setAssociation(HOME_FOLDER_USER, (DomainObject)user);
    }

    public static UserHomeFolderMap findUserHomeFolderMap(User user, ContentSection section) {
        DataCollection maps = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        maps.addEqualsFilter(USER_ID, (Object)user.getID());
        maps.addEqualsFilter(SECTION_ID, (Object)section.getID());
        UserHomeFolderMap map = null;
        if (maps.next()) {
            map = new UserHomeFolderMap(maps.getDataObject());
        }
        maps.close();
        return map;
    }

    public static UserHomeFolderMap findOrCreateUserHomeFolderMap(User user, ContentSection section) {
        UserHomeFolderMap map = UserHomeFolderMap.findUserHomeFolderMap(user, section);
        if (map == null) {
            map = new UserHomeFolderMap();
            map.setHomeFolderUser(user);
            map.setHomeSection(section);
        }
        return map;
    }
}

