/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ObjectCopier;
import com.arsdigita.cms.PublishedLink;
import com.arsdigita.cms.lifecycle.Lifecycle;
import com.arsdigita.cms.lifecycle.LifecycleService;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.Assert;
import java.util.HashSet;
import org.apache.log4j.Logger;

class VersionCopier
extends ObjectCopier {
    private static Logger s_log = Logger.getLogger(VersionCopier.class);
    private final Lifecycle m_lifecycle;
    private boolean m_once = false;
    private long m_start = 0L;
    private final HashSet m_traversedComponents = new HashSet();
    private OID m_topLevelSourceOID = null;

    VersionCopier(Lifecycle lifecycle) {
        this.m_lifecycle = lifecycle;
    }

    VersionCopier() {
        this.m_lifecycle = null;
    }

    @Override
    public ContentItem copyItem(ContentItem item) {
        this.m_trace.enter("copyItem", (Object)item);
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)("Publishing " + item));
            this.m_start = System.currentTimeMillis();
        }
        if (Assert.isEnabled()) {
            Assert.isFalse((boolean)this.m_once);
            this.m_once = true;
        }
        this.m_topLevelSourceOID = item.getOID();
        ContentItem version = this.createVersion(item);
        if (this.m_lifecycle != null) {
            LifecycleService.setLifecycle((ACSObject)version, this.m_lifecycle);
        }
        this.m_trace.exit("copyItem", (Object)version);
        if (Assert.isEnabled()) {
            this.m_once = false;
        }
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)("Done publishing " + item + " (" + (System.currentTimeMillis() - this.m_start) + " millis)"));
        }
        return version;
    }

    @Override
    public int getCopyType() {
        return 1;
    }

    @Override
    public DomainObject copy(DomainObject object) {
        if (object != null) {
            this.m_traversedComponents.add(object);
        }
        return super.copy(object);
    }

    @Override
    protected DomainObject copy(DomainObject source, DomainObject target, DomainObject object, Property prop) {
        this.m_trace.enter("copy", (Object)object, (Object)prop);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Copying property " + prop + " of " + object));
        }
        Assert.exists((Object)source, DomainObject.class);
        Assert.exists((Object)target, DomainObject.class);
        Assert.exists((Object)object, DomainObject.class);
        Assert.exists((Object)prop, Property.class);
        if (object instanceof ContentItem) {
            s_log.debug((Object)"The property is a content item");
            ContentItem item = (ContentItem)object;
            if (Assert.isEnabled()) {
                item.assertDraft();
            }
            if (prop.isComponent()) {
                s_log.debug((Object)"The property is a component; creating a live or pending version");
                ContentItem copy = this.createVersion(item);
                this.m_trace.exit("copy", (Object)copy);
                return copy;
            }
            if (this.m_traversedComponents.contains(object)) {
                DomainObject copy = this.copy(object);
                this.m_trace.exit("copy", (Object)copy);
                return copy;
            }
            if (prop.isRequired()) {
                Assert.fail((String)"1..1 associations to non-component top-level ContentItems are not allowed");
                return null;
            }
            s_log.debug((Object)"The property is not a component; creating PublishedLink for the item");
            if (source instanceof ContentItem) {
                PublishedLink.create((ContentItem)this.getCopy(this.m_topLevelSourceOID), target, prop.getName(), item, (ContentItem)source);
            } else {
                PublishedLink.create((ContentItem)this.getCopy(this.m_topLevelSourceOID), target, prop.getName(), item, null);
            }
            this.m_trace.exit("copy", null);
            return null;
        }
        s_log.debug((Object)"The property is not a content item; using domain object copier");
        DomainObject copy = super.copy(source, target, object, prop);
        this.m_trace.exit("copy", (Object)copy);
        return copy;
    }

    private ContentItem createVersion(ContentItem item) {
        this.m_trace.enter("createVersion", (Object)item);
        if (Assert.isEnabled()) {
            item.assertDraft();
        }
        ContentItem version = (ContentItem)this.copy((DomainObject)item);
        s_log.debug((Object)"The copy is pending; associating it with the draft item");
        version.setVersion("pending");
        item.addPendingVersion(version);
        version.copyServicesFrom(item);
        this.m_trace.exit("createVersion", (Object)version);
        return version;
    }
}

