/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainService;
import com.arsdigita.domain.InstantiatorNotFoundException;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.metadata.Property;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

class VersionUpdater
extends DomainService {
    private static Logger s_log = Logger.getLogger(VersionUpdater.class);
    protected Set m_visited = new HashSet();
    String m_newVersion;

    protected VersionUpdater(String newVersion) {
        this.m_newVersion = newVersion;
    }

    public void updateItemVersion(ContentItem item) {
        this.updateSingleObject(VersionUpdater.getDataObject((DomainObject)item));
    }

    protected void updateChildren(DataObject src) {
        ObjectType type = src.getOID().getObjectType();
        Iterator i = type.getProperties();
        while (i.hasNext()) {
            String propName;
            Object data;
            Property prop = (Property)i.next();
            if (!prop.isRole() || !prop.isComponent() || (data = src.get(propName = prop.getName())) == null) continue;
            if (data instanceof DataObject) {
                this.updateSingleObject((DataObject)data);
                continue;
            }
            if (data instanceof DataAssociation) {
                DataAssociationCursor daCursor = ((DataAssociation)data).getDataAssociationCursor();
                while (daCursor.next()) {
                    this.updateSingleObject(daCursor.getDataObject());
                }
                continue;
            }
            throw new IllegalStateException("Warning: unsupported property type " + data.getClass().getName());
        }
    }

    protected void updateSingleObject(DataObject src) {
        if (this.m_visited.contains(src.getOID())) {
            return;
        }
        this.m_visited.add(src.getOID());
        ContentItem item = null;
        try {
            DomainObject obj = DomainObjectFactory.newInstance((DataObject)src);
            if (obj instanceof ContentItem) {
                item = (ContentItem)obj;
            }
        }
        catch (InstantiatorNotFoundException instantiatorNotFoundException) {
            // empty catch block
        }
        if (item != null && !this.m_newVersion.equals(item.getVersion())) {
            item.setVersion(this.m_newVersion);
            item.save();
        }
        this.updateChildren(src);
    }
}

