/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.ContentSection;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.web.Application;
import com.arsdigita.web.ApplicationCollection;
import com.arsdigita.web.ApplicationType;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class Workspace
extends Application {
    private static final Logger s_log = Logger.getLogger(ContentSection.class);
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.Workspace";
    public static final String PACKAGE_KEY = "content-center";
    public static final String INSTANCE_NAME = "Content Center";

    public Workspace(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public Workspace(BigDecimal key) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)key));
    }

    public Workspace(DataObject dataObject) {
        super(dataObject);
    }

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public static Workspace create(String urlName, String title, Application parent) {
        Workspace app = (Workspace)Application.createApplication((String)BASE_DATA_OBJECT_TYPE, (String)urlName, (String)title, (Application)parent);
        app.save();
        return app;
    }

    public static Application getInstance() {
        ApplicationType workspaceType = ApplicationType.retrieveApplicationTypeForApplication((String)BASE_DATA_OBJECT_TYPE);
        if (workspaceType == null) {
            return null;
        }
        ApplicationCollection apps = Application.retrieveAllApplications();
        apps.addEqualsFilter("resourceType.id", (Object)workspaceType.getID());
        if (!apps.next()) {
            return null;
        }
        Application result = apps.getApplication();
        apps.close();
        return result;
    }

    public static String getURL() {
        Application app = Workspace.getInstance();
        if (app == null) {
            return null;
        }
        String url = app.getPrimaryURL();
        return url;
    }

    public String getServletPath() {
        return "/templates/servlet/content-center";
    }
}

