/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.Workspace;
import com.arsdigita.cms.WorkspaceSetup;
import com.arsdigita.cms.dispatcher.ResourceHandler;
import com.arsdigita.cms.dispatcher.SimpleCache;
import com.arsdigita.developersupport.DeveloperSupport;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.kernel.security.UserContext;
import com.arsdigita.kernel.security.Util;
import com.arsdigita.ui.login.LoginHelper;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Application;
import com.arsdigita.web.ApplicationFileResolver;
import com.arsdigita.web.BaseApplicationServlet;
import com.arsdigita.web.LoginSignal;
import com.arsdigita.web.Web;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class WorkspaceServlet
extends BaseApplicationServlet {
    private static Logger s_log = Logger.getLogger((String)WorkspaceServlet.class.getName());
    public static final String DEFAULT_MAP_FILE = "/WEB-INF/resources/content-center-old-map.xml";
    private static HashMap s_pageClasses = WorkspaceSetup.getURLToClassMap();
    private static HashMap s_pageURLs = WorkspaceSetup.getClassToURLMap();
    private static SimpleCache s_pages = new SimpleCache();
    private ArrayList m_trailingSlashList = new ArrayList();
    private String m_templatePath;
    private ApplicationFileResolver m_resolver;

    protected void doInit() {
        if (s_log.isDebugEnabled()) {
            s_log.info((Object)"starting doInit method");
        }
        this.m_trailingSlashList = new ArrayList();
        this.requireTrailingSlash("");
        this.m_templatePath = "/templates/ccm-cms/content-center";
        Assert.exists((Object)this.m_templatePath, String.class);
        Assert.isTrue((boolean)this.m_templatePath.startsWith("/"), (String)"template-path must start with '/'");
        Assert.isTrue((!this.m_templatePath.endsWith("/") ? 1 : 0) != 0, (String)"template-path must not end with '/'");
        this.m_resolver = Web.getConfig().getApplicationFileResolver();
    }

    protected void doService(HttpServletRequest sreq, HttpServletResponse sresp, Application app) throws ServletException, IOException {
        if (s_log.isDebugEnabled()) {
            s_log.info((Object)"starting doService method");
        }
        DeveloperSupport.startStage((String)"ContentCenterServlet.doService");
        Workspace workspace = (Workspace)app;
        RequestContext ctx = DispatcherHelper.getRequestContext();
        String url = ctx.getRemainingURLPart();
        String originalUrl = ctx.getOriginalURL();
        String requestUri = sreq.getRequestURI();
        if (this.m_trailingSlashList.contains(url) && !originalUrl.endsWith("/")) {
            DispatcherHelper.sendRedirect((HttpServletResponse)sresp, (String)(originalUrl + "/"));
            return;
        }
        ResourceHandler page = this.getResource(url);
        if (page != null) {
            this.checkUserAccess(sreq, sresp);
            page.init();
            page.dispatch(sreq, sresp, ctx);
        } else {
            RequestDispatcher rd;
            if (s_log.isInfoEnabled()) {
                s_log.info((Object)"NO page registered to serve the requst url.");
            }
            if ((rd = this.m_resolver.resolve(this.m_templatePath, sreq, sresp, app)) != null) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Got dispatcher " + rd));
                }
                sreq = DispatcherHelper.restoreOriginalRequest((HttpServletRequest)sreq);
                rd.forward((ServletRequest)sreq, (ServletResponse)sresp);
            } else {
                sresp.sendError(404, requestUri + " not found on this server.");
            }
        }
        DeveloperSupport.endStage((String)"ContentCenterServlet.doService");
        if (s_log.isDebugEnabled()) {
            s_log.info((Object)"doService method completed");
        }
    }

    public static String getURLStubForClass(String classname) {
        s_log.debug((Object)("Getting URL Stub for : " + classname));
        for (String classname2 : s_pageURLs.keySet()) {
            s_log.debug((Object)("key: " + classname + " value: " + (String)s_pageURLs.get(classname2)));
        }
        String url = (String)s_pageURLs.get(classname);
        return url;
    }

    protected ResourceHandler getResource(String url) throws ServletException {
        String pageClassName;
        ResourceHandler page = (ResourceHandler)s_pages.get(url);
        if (page == null && (pageClassName = (String)s_pageClasses.get(url)) != null) {
            Class<?> pageClass;
            try {
                pageClass = Class.forName(pageClassName);
            }
            catch (ClassNotFoundException e) {
                s_log.error((Object)"error fetching class for ResourceHandler", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
            try {
                page = (ResourceHandler)pageClass.newInstance();
            }
            catch (InstantiationException e) {
                s_log.error((Object)"error instantiating a ResourceHandler", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                s_log.error((Object)"error instantiating a ResourceHandler", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
            page.init();
            s_pages.put(url, page);
        }
        return page;
    }

    protected void addResource(String url, String className) {
        s_pageClasses.put(url, className);
        s_pageURLs.put(className, url);
    }

    public static void releaseResource(String url) {
        s_pages.remove(url);
    }

    protected void checkUserAccess(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (!Web.getUserContext().isLoggedIn()) {
            throw new LoginSignal(request);
        }
    }

    protected void redirectToLoginPage(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        String url = Util.getSecurityHelper().getLoginURL(req) + "?" + "return_url" + "=" + UserContext.encodeReturnURL((HttpServletRequest)req);
        try {
            LoginHelper.sendRedirect((HttpServletRequest)req, (HttpServletResponse)resp, (String)url);
        }
        catch (IOException e) {
            s_log.error((Object)"IO Exception", (Throwable)e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    private void requireTrailingSlash(String url) {
        this.m_trailingSlashList.add(url);
    }
}

