/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.util.PageClassConfigHandler;
import com.arsdigita.runtime.ConfigError;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class WorkspaceSetup {
    private static Logger s_log = Logger.getLogger(WorkspaceSetup.class);
    final String m_workspaceURL;
    final String m_contentCenterMap;
    private static HashMap s_pageClasses = new HashMap();
    private static HashMap s_pageURLs = new HashMap();

    public WorkspaceSetup(String workspaceURL, String contentCenterMap) {
        this.m_workspaceURL = workspaceURL;
        this.m_contentCenterMap = contentCenterMap;
    }

    public static HashMap getURLToClassMap() {
        return s_pageClasses;
    }

    public static HashMap getClassToURLMap() {
        return s_pageURLs;
    }

    public void run() {
        this.setupContentCenter();
    }

    private void setupContentCenter() throws ConfigError {
        PageClassConfigHandler handler = new PageClassConfigHandler(s_pageClasses, s_pageURLs);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream input = loader.getResourceAsStream(this.m_contentCenterMap.substring(1));
        if (input == null) {
            throw new IllegalStateException(this.m_contentCenterMap + " not found");
        }
        InputSource source = new InputSource(input);
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser parser = spf.newSAXParser();
            parser.parse(source, (DefaultHandler)handler);
        }
        catch (ParserConfigurationException e) {
            throw new UncheckedWrapperException("error parsing dispatcher config", (Throwable)e);
        }
        catch (SAXException e) {
            throw new UncheckedWrapperException("error parsing dispatcher config", (Throwable)e);
        }
        catch (IOException e) {
            throw new UncheckedWrapperException("error parsing dispatcher config", (Throwable)e);
        }
    }
}

