/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contentitem;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Folder;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;
import org.apache.oro.text.perl.Perl5Util;

public class ContentItemHelper {
    private static final Logger s_log = Logger.getLogger(ContentItemHelper.class);
    private static final String DEFAULT_LANG = "en";
    private String m_name;
    private Folder m_parent;
    private ContentSection m_section;
    private int m_cloneCount;
    protected ContentItem m_item;
    protected String m_language;
    private String m_contentType;
    private Class m_contentTypeClass;

    public ContentItemHelper(ContentSection section) {
        this.m_section = section;
        this.m_parent = section.getRootFolder();
        this.m_cloneCount = 0;
        this.m_language = DEFAULT_LANG;
    }

    public void setContentSection(ContentSection section) {
        this.m_section = section;
    }

    public ContentSection getContentSection() {
        return this.m_section;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setContentType(String type) {
        this.m_contentType = type;
    }

    public String getContentType() {
        return this.m_contentType;
    }

    public void setParent(Folder parent) {
        this.m_parent = parent;
        if (this.m_item != null) {
            this.m_item.setParent((ACSObject)parent);
        }
    }

    public Folder getParent() {
        return this.m_parent;
    }

    public void setCloneCount(int cloneCount) {
        this.m_cloneCount = cloneCount;
    }

    public int getCloneCount() {
        return this.m_cloneCount;
    }

    public ContentItem getContentItem() {
        return this.m_item;
    }

    public void setContentItem(ContentItem item) {
        this.m_item = item;
    }

    public void setLanguage(String lang) {
        this.m_language = lang;
    }

    public void setBodyText(String body) {
        s_log.warn((Object)"Body Text not set");
    }

    public ContentItem create() {
        return this.createContentItem(false);
    }

    public ContentItem create(boolean save) {
        return this.createContentItem(save);
    }

    public ContentItem createContentItem() {
        return this.createContentItem(false);
    }

    public void save() {
        this.m_item.setParent((ACSObject)this.getParent());
        this.m_item.save();
        s_log.debug((Object)("Done saving item :" + this.m_item.getName() + " " + this.m_item));
    }

    protected ContentItem createContentItem(boolean save) {
        try {
            this.m_contentTypeClass = Class.forName(this.getContentType());
        }
        catch (ClassNotFoundException e) {
            throw new UncheckedWrapperException((Throwable)e);
        }
        this.m_item = this.getContentItemByName(this.getName(), this.getParent());
        if (this.m_item == null) {
            this.m_item = this.createNewContentItem();
        }
        s_log.debug((Object)"Done calling create new on Content item");
        if (save) {
            s_log.debug((Object)"Trying to prematurely save Content item");
            this.save();
        }
        Assert.exists((Object)this.m_item);
        s_log.debug((Object)"Successfully created content item");
        return this.m_item;
    }

    protected ContentItem createNewContentItem() {
        ContentItem l_item;
        try {
            this.m_contentTypeClass = Class.forName(this.getContentType());
            s_log.debug((Object)("Creating item with type: " + this.m_contentTypeClass.getClass().getName() + " Name: " + this.getName() + " parent: " + this.getParent().getName()));
            l_item = (ContentItem)this.m_contentTypeClass.newInstance();
            l_item.setName(this.getName());
            l_item.setLanguage(this.m_language);
            l_item.setContentSection(this.getContentSection());
        }
        catch (InstantiationException e) {
            s_log.warn((Object)"New Exception", (Throwable)e);
            throw new UncheckedWrapperException("InstantiationException", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            s_log.warn((Object)"New Exception", (Throwable)e);
            throw new UncheckedWrapperException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            s_log.warn((Object)"New Exception", (Throwable)e);
            throw new UncheckedWrapperException((Throwable)e);
        }
        Assert.exists((Object)l_item);
        return l_item;
    }

    public void set(String methodName, String argClass, String value) {
        Assert.exists((Object)this.m_item);
        Assert.exists((Object)this.m_contentTypeClass);
        if (methodName != null) {
            s_log.debug((Object)("setting property with : " + methodName));
        }
        if (argClass != null) {
            s_log.debug((Object)("property class is : " + argClass));
        } else {
            s_log.debug((Object)"missing argClass");
        }
        if (value != null) {
            s_log.debug((Object)("value is : " + value));
        }
        if (methodName != null || argClass != null || value != null) {
            try {
                Assert.exists((Object)argClass);
                Class[] args = new Class[]{Class.forName(argClass)};
                s_log.debug((Object)"npe2?");
                Method method = this.m_contentTypeClass.getMethod(methodName, args);
                s_log.debug((Object)"npe3?");
                Object[] argv = this.getArgClassArray(args[0], value);
                s_log.debug((Object)"npe4?");
                method.invoke((Object)this.m_item, argv);
                s_log.debug((Object)"npe5?");
            }
            catch (IllegalAccessException e) {
                throw new UncheckedWrapperException((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new UncheckedWrapperException((Throwable)e);
            }
            catch (Exception e) {
                s_log.error((Object)"Unchecked Exception", (Throwable)e);
                throw new UncheckedWrapperException((Throwable)e);
            }
        }
    }

    private Object[] getArgClassArray(Class argClass, String value) throws IllegalArgumentException {
        if (argClass.equals(String.class)) {
            Object[] returnArray = new Object[]{value};
            return returnArray;
        }
        if (argClass.equals(Double.class)) {
            Object[] returnArray = new Object[]{Double.valueOf(value)};
            return returnArray;
        }
        throw new IllegalArgumentException("Do not know how to instantiate specified class");
    }

    protected ContentItem getContentItemByName(String name, Folder parent) {
        Assert.exists((Object)parent);
        ContentItem item = null;
        Folder.ItemCollection items = parent.getItems();
        items.addNameFilter(name);
        s_log.debug((Object)("Looking for: " + name));
        if (!items.isEmpty()) {
            while (items.next()) {
                item = items.getContentItem();
                s_log.debug((Object)("Found: " + item.getName() + " " + item));
            }
        }
        return item;
    }

    private String generateName(String name) {
        Perl5Util re = new Perl5Util();
        String title = re.substitute("s/ /-/g", name);
        return title.toLowerCase();
    }

    public ContentItem cloneItem(int count, Folder parent) {
        return this.cloneItem(count, parent, true);
    }

    protected ContentItem cloneItem(int count, Folder parent, boolean save) {
        Assert.exists((Object)this.m_item);
        String name = this.m_item.getName() + "_" + count;
        return this.cloneItem(name, parent, save);
    }

    protected ContentItem cloneItem(String name, Folder parent, boolean save) {
        ContentItem clone = this.getContentItemByName(name, parent);
        if (clone == null) {
            clone = this.m_item.copy(parent, true);
            clone.setName(name);
            s_log.debug((Object)("creating clone: " + clone.getName() + " parent: " + parent.getName()));
        }
        if (save) {
            clone.save();
        }
        Assert.exists((Object)clone);
        return clone;
    }

    protected ContentItem newCloneItem(String name, Folder parent) {
        ContentItem clone = this.m_item.copy();
        clone.copyServicesFrom(this.m_item);
        clone.setName(name);
        clone.setContentSection(this.getContentSection());
        clone.setParent((ACSObject)parent);
        s_log.debug((Object)("creating clone: " + clone.getName() + " parent: " + parent.getName()));
        return clone;
    }

    public String cloneName(int count) {
        Assert.exists((Object)this.m_item);
        return this.m_item.getName() + "_" + count;
    }
}

