/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contentitem;

import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.categorization.CategoryPurpose;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.contentitem.ContentBundleHelper;
import com.arsdigita.kernel.ACSObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public class ContentPageHelper
extends ContentBundleHelper {
    private Category m_category;
    private List m_categories = new LinkedList();
    private Random m_random;
    private static final Logger s_log = Logger.getLogger(ContentPageHelper.class);

    public ContentPageHelper(ContentSection section) {
        super(section);
        this.m_category = section.getRootCategory();
        CategoryPurpose nav = CategoryPurpose.getPurpose((String)"navigation");
        if (null != nav) {
            s_log.debug((Object)("purpose key " + nav.getKey() + " name " + nav.getName()));
            for (Category cat : nav.getCategories()) {
                CategoryCollection scions = cat.getDescendants();
                while (scions.next()) {
                    this.m_categories.add(scions.getCategory());
                }
                scions.close();
            }
        }
        if (this.m_categories.size() == 0) {
            s_log.debug((Object)"Category list is empty, adding root");
            this.m_categories.add(this.m_category);
        }
        this.m_random = new Random();
    }

    @Override
    public void setBodyText(String body) {
    }

    public ContentPage getContentPage() {
        ContentItem l_item = super.getContentItem();
        if (l_item != null) {
            return (ContentPage)l_item;
        }
        return null;
    }

    @Override
    public ContentItem create() {
        return this.createContentPage();
    }

    public ContentPage createContentPage() {
        return this.createContentPage(false);
    }

    public ContentPage createContentPage(boolean save) {
        ContentPage m_page = (ContentPage)super.createContentItem(save);
        return m_page;
    }

    @Override
    public void save() {
        super.save();
        Category cat = this.getCategory();
        cat.addChild((ACSObject)this.getContentPage());
        cat.save();
    }

    @Override
    public ContentItem cloneItem(String name, Folder parent, boolean save) {
        ContentPage page = (ContentPage)super.cloneItem(name, parent, save);
        page.save();
        Category cat = this.getRandomCategory();
        cat.addChild((ACSObject)page);
        cat.save();
        return page;
    }

    public Category getRandomCategory() {
        int index = this.m_random.nextInt(this.m_categories.size());
        s_log.debug((Object)("getting category index : " + index + " out of: " + this.m_categories.size()));
        return (Category)this.m_categories.get(index);
    }

    public void setCategory(Category category) {
        this.m_category = category;
        ContentPage page = this.getContentPage();
        if (page != null) {
            this.m_category.addChild((ACSObject)page);
            this.m_category.save();
        }
    }

    public Category getCategory() {
        return this.m_category;
    }
}

