/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contentsection;

import com.arsdigita.runtime.AbstractConfig;
import com.arsdigita.util.parameter.BooleanParameter;
import com.arsdigita.util.parameter.IntegerParameter;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.StringArrayParameter;
import com.arsdigita.util.parameter.StringParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public final class ContentSectionConfig
extends AbstractConfig {
    private List m_defaultRoles;
    private List m_defaultWorkflows;
    private static final Logger s_log = Logger.getLogger(ContentSectionConfig.class);
    private static ContentSectionConfig s_config;
    private final Parameter m_taskAlerts = new StringArrayParameter("com.arsdigita.cms.section.task_alerts", 1, (Object)new String[]{"Authoring:enable:finish:rollback", "Approval:enable:finish:rollback", "Deploy:enable:finish:rollback"});
    private final Parameter m_sendOverdueAlerts = new BooleanParameter("com.arsdigita.cms.section.send_overdue_alerts", 1, (Object)false);
    private final Parameter m_taskDuration = new IntegerParameter("com.arsdigita.cms.section.task_duration", 1, (Object)new Integer(96));
    private final Parameter m_alertInterval = new IntegerParameter("com.arsdigita.cms.section.alert_interval", 1, (Object)new Integer(24));
    private final Parameter m_maxAlerts = new IntegerParameter("com.arsdigita.cms.section.max_alerts", 1, (Object)new Integer(5));
    private final Parameter m_newContentSectionName = new StringParameter("com.arsdigita.cms.section.new_section_name", 0, null);
    private final BooleanParameter m_isPublic = new BooleanParameter("com.arsdigita.cms.section.is_public", 1, (Object)true);
    private final Parameter m_contentTypeList = new StringArrayParameter("com.arsdigita.cms.section.ctypes_list", 1, (Object)new String[0]);
    private final Parameter m_itemResolverClass = new StringParameter("com.arsdigita.cms.section.item_resolver_class", 0, null);
    private final Parameter m_templateResolverClass = new StringParameter("com.arsdigita.cms.section.template_resolver_class", 0, null);
    private final Parameter m_useSectionCategories = new BooleanParameter("com.arsdigita.cms.section.use_section_categories", 1, (Object)false);
    private final Parameter m_categoryFileList = new StringArrayParameter("com.arsdigita.cms.section.categories_toload", 1, (Object)new String[]{"/WEB-INF/resources/article-categories.xml", "/WEB-INF/resources/navigation-categories.xml"});

    public static synchronized ContentSectionConfig getInstance() {
        if (s_config == null) {
            s_config = new ContentSectionConfig();
            s_config.load();
        }
        return s_config;
    }

    public ContentSectionConfig() {
        this.register(this.m_taskAlerts);
        this.register(this.m_sendOverdueAlerts);
        this.register(this.m_taskDuration);
        this.register(this.m_alertInterval);
        this.register(this.m_maxAlerts);
        this.register(this.m_newContentSectionName);
        this.register((Parameter)this.m_isPublic);
        this.register(this.m_itemResolverClass);
        this.register(this.m_templateResolverClass);
        this.register(this.m_contentTypeList);
        this.register(this.m_useSectionCategories);
        this.register(this.m_categoryFileList);
    }

    public final String[] getTaskAlerts() {
        return (String[])this.get(this.m_taskAlerts);
    }

    public Boolean getSendOverdueAlerts() {
        return (boolean)((Boolean)this.get(this.m_sendOverdueAlerts));
    }

    public Integer getTaskDuration() {
        return (int)((Integer)this.get(this.m_taskDuration));
    }

    public Integer getAlertInterval() {
        return (Integer)this.get(this.m_alertInterval);
    }

    public Integer getMaxAlerts() {
        return (Integer)this.get(this.m_maxAlerts);
    }

    public String getNewContentSectionName() {
        return (String)this.get(this.m_newContentSectionName);
    }

    public List getDefaultRoles() {
        final List<String> AUTH_PRIVS = Arrays.asList("new_item", "read_item", "preview_item", "edit_item", "categorize_items");
        final List<String> EDIT_PRIVS = Arrays.asList("new_item", "read_item", "preview_item", "edit_item", "categorize_items", "delete_item", "approve_item");
        final List<String> PUBL_PRIVS = Arrays.asList("new_item", "read_item", "preview_item", "edit_item", "categorize_items", "delete_item", "approve_item", "publish");
        final List<String> MNGR_PRIVS = Arrays.asList("new_item", "read_item", "preview_item", "edit_item", "categorize_items", "delete_item", "approve_item", "publish", "staff_admin", "content_type_admin", "lifecycle_admin", "workflow_admin", "category_admin");
        final List<String> TRST_PRIVS = Arrays.asList("new_item", "read_item", "preview_item", "edit_item", "categorize_items", "delete_item", "approve_item", "publish", "apply_alternate_workflows");
        this.m_defaultRoles = new ArrayList();
        this.m_defaultRoles.add(new ArrayList(){
            {
                this.add("Author");
                this.add("Creates new content");
                this.add(AUTH_PRIVS);
            }
        });
        this.m_defaultRoles.add(new ArrayList(){
            {
                this.add("Editor");
                this.add("Reviews and approves the author's work");
                this.add(EDIT_PRIVS);
            }
        });
        this.m_defaultRoles.add(new ArrayList(){
            {
                this.add("Publisher");
                this.add("Deploys the content to the web site");
                this.add(PUBL_PRIVS);
            }
        });
        this.m_defaultRoles.add(new ArrayList(){
            {
                this.add("Manager");
                this.add("Manages the overall content section");
                this.add(MNGR_PRIVS);
            }
        });
        this.m_defaultRoles.add(new ArrayList(){
            {
                this.add("Trusted User");
                this.add("A trusted user is allowed to create and publish items without review");
                this.add(TRST_PRIVS);
            }
        });
        return this.m_defaultRoles;
    }

    public List getDefaultWorkflows() {
        if (this.m_defaultWorkflows == null) {
            this.m_defaultWorkflows = new ArrayList();
            this.m_defaultWorkflows.add(new HashMap<String, Object>(){
                {
                    this.put("name", "Redigierte Ver\u00f6ffentlichung");
                    this.put("description", "A process that involves creating and approving content.");
                    this.put("isDefault", "true");
                    this.put("tasks", new ArrayList(){
                        {
                            this.add(new HashMap<String, Object>(){
                                {
                                    this.put("name", "Verfassen");
                                    this.put("description", "Create content.");
                                    this.put("type", "Author");
                                    this.put("role", new ArrayList<String>(){
                                        {
                                            this.add("Author");
                                        }
                                    });
                                }
                            });
                            this.add(new HashMap<String, Object>(){
                                {
                                    this.put("name", "\u00dcberpr\u00fcfen");
                                    this.put("description", "Approve content.");
                                    this.put("type", "Edit");
                                    this.put("role", new ArrayList<String>(){
                                        {
                                            this.add("Editor");
                                        }
                                    });
                                    this.put("dependOn", new ArrayList<String>(){
                                        {
                                            this.add("Verfassen");
                                        }
                                    });
                                }
                            });
                            this.add(new HashMap<String, Object>(){
                                {
                                    this.put("name", "Ver\u00f6ffentlichen");
                                    this.put("description", "Deploy content.");
                                    this.put("type", "Deploy");
                                    this.put("role", new ArrayList<String>(){
                                        {
                                            this.add("Publisher");
                                        }
                                    });
                                    this.put("dependOn", new ArrayList<String>(){
                                        {
                                            this.add("\u00dcberpr\u00fcfen");
                                        }
                                    });
                                }
                            });
                        }
                    });
                }
            });
            this.m_defaultWorkflows.add(new HashMap<String, Object>(){
                {
                    this.put("name", "Direkte Ver\u00f6ffentlichung");
                    this.put("description", "Create and publish content without review");
                    this.put("isDefault", "false");
                    this.put("tasks", new ArrayList(){
                        {
                            this.add(new HashMap<String, Object>(){
                                {
                                    this.put("name", "Verfassen");
                                    this.put("description", "Create content.");
                                    this.put("type", "Author");
                                    this.put("role", new ArrayList<String>(){
                                        {
                                            this.add("Author");
                                            this.add("Trusted User");
                                        }
                                    });
                                }
                            });
                            this.add(new HashMap<String, Object>(){
                                {
                                    this.put("name", "Ver\u00f6ffentlichen");
                                    this.put("description", "Deploy content.");
                                    this.put("type", "Deploy");
                                    this.put("role", new ArrayList<String>(){
                                        {
                                            this.add("Publisher");
                                            this.add("Trusted User");
                                        }
                                    });
                                    this.put("dependOn", new ArrayList<String>(){
                                        {
                                            this.add("Verfassen");
                                        }
                                    });
                                }
                            });
                        }
                    });
                }
            });
        }
        return this.m_defaultWorkflows;
    }

    public Boolean isPubliclyViewable() {
        return (boolean)((Boolean)this.get((Parameter)this.m_isPublic));
    }

    public String getItemResolverClass() {
        return (String)this.get(this.m_itemResolverClass);
    }

    public String getTemplateResolverClass() {
        return (String)this.get(this.m_templateResolverClass);
    }

    public final boolean getUseSectionCategories() {
        return (Boolean)this.get(this.m_useSectionCategories);
    }

    public List getCategoryFileList() {
        String[] catFiles = (String[])this.get(this.m_categoryFileList);
        return Arrays.asList(catFiles);
    }

    public List getContentSectionsContentTypes() {
        String[] taskAlerts = (String[])this.get(this.m_contentTypeList);
        return Arrays.asList(taskAlerts);
    }
}

