/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contentsection;

import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.RootCategoryCollection;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ContentTypeLifecycleDefinition;
import com.arsdigita.cms.ContentTypeWorkflowTemplate;
import com.arsdigita.cms.Template;
import com.arsdigita.cms.TemplateManagerFactory;
import com.arsdigita.cms.contentsection.ContentSectionConfig;
import com.arsdigita.cms.lifecycle.LifecycleDefinition;
import com.arsdigita.cms.lifecycle.PhaseDefinition;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.cms.workflow.CMSTask;
import com.arsdigita.cms.workflow.CMSTaskType;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.PartyCollection;
import com.arsdigita.kernel.Role;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.runtime.ConfigError;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.workflow.simple.Task;
import com.arsdigita.workflow.simple.WorkflowTemplate;
import com.arsdigita.xml.XML;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public final class ContentSectionSetup {
    private static Logger s_log = Logger.getLogger(ContentSectionSetup.class);
    private HashMap<String, Role> m_roles = new HashMap();
    private LifecycleDefinition m_lcd;
    private WorkflowTemplate m_wf;
    final ContentSection m_section;

    public ContentSectionSetup(ContentSection section) {
        Assert.exists((Object)((Object)section), ContentSection.class);
        this.m_section = section;
    }

    public static ContentSection setupContentSectionAppInstance(String name, List defaultRoles, List defaultWorkflows, Boolean isPubliclyViewable, String itemResolverClassName, String templateResolverClassName, List sectionContentTypes, Boolean useSectionCategories, List categoryFileList) {
        s_log.info((Object)("Creating content section on /" + name));
        ContentSection section = ContentSection.create(name);
        ContentSectionSetup setup = new ContentSectionSetup(section);
        setup.registerRoles(defaultRoles);
        setup.registerWorkflowTemplates(defaultWorkflows);
        setup.registerViewers(isPubliclyViewable);
        setup.registerPublicationCycles();
        setup.registerResolvers(itemResolverClassName, templateResolverClassName);
        setup.registerContentTypes(sectionContentTypes);
        if (useSectionCategories.booleanValue()) {
            Iterator files = categoryFileList.iterator();
            while (files.hasNext()) {
                setup.registerCategories((String)files.next());
            }
        }
        setup.registerAlerts();
        section.save();
        return section;
    }

    public void registerRoles(List<List> roles) {
        for (List role : roles) {
            String name = (String)role.get(0);
            String desc = (String)role.get(1);
            List privileges = (List)role.get(2);
            s_log.info((Object)("Creating role " + name));
            Role newRole = this.registerRole(name, desc, privileges);
            this.m_roles.put(name, newRole);
        }
    }

    private Role registerRole(String name, String desc, List privileges) {
        Role role = this.m_section.getStaffGroup().createRole(name);
        role.setDescription(desc);
        role.save();
        for (String priv : privileges) {
            s_log.info((Object)("Granting privilege cms_" + priv));
            role.grantPermission((ACSObject)this.m_section, PrivilegeDescriptor.get((String)("cms_" + priv)));
            if (!priv.equals("category_admin") && !priv.equals("categorize_items")) continue;
            RootCategoryCollection coll = Category.getRootCategories((ACSObject)this.m_section);
            while (coll.next()) {
                if (priv.equals("category_admin")) {
                    role.grantPermission((ACSObject)coll.getCategory(), PrivilegeDescriptor.ADMIN);
                    continue;
                }
                role.grantPermission((ACSObject)coll.getCategory(), Category.MAP_DESCRIPTOR);
            }
        }
        PartyCollection partyColl = Party.retrieveAllParties();
        partyColl.filter("Site-wide Administrators");
        if (partyColl.next()) {
            role.add(partyColl.getParty());
        }
        partyColl.close();
        return role;
    }

    public void registerViewers(Boolean pub) {
        Role viewers = this.m_section.getViewersGroup().createRole("Content Reader");
        viewers.setDescription("Can view published pages within this section");
        viewers.save();
        viewers.grantPermission((ACSObject)this.m_section, PrivilegeDescriptor.get((String)"cms_read_item"));
        String email = Boolean.TRUE.equals(pub) ? "public@nullhost" : "registered@nullhost";
        Party viewer = this.retrieveParty(email);
        if (viewer == null) {
            throw new ConfigError((String)GlobalizationUtil.globalize("cms.installer.cannot_find_group_for_email").localize() + email);
        }
        s_log.info((Object)("Adding " + email + " to viewers role"));
        viewers.getGroup().addMemberOrSubgroup(viewer);
        viewers.save();
    }

    private Party retrieveParty(String email) {
        PartyCollection parties = Party.retrieveAllParties();
        parties.filter(email);
        if (parties.next()) {
            Party party = parties.getParty();
            parties.close();
            return party;
        }
        return null;
    }

    public void registerResolvers(String itemResolverClassName, String templateResolverClassName) {
        if (itemResolverClassName != null && itemResolverClassName.length() > 0) {
            this.m_section.setItemResolverClass(itemResolverClassName);
            s_log.info((Object)("Registering " + itemResolverClassName + " as the item resolver class"));
        } else {
            this.m_section.setItemResolverClass(ContentSection.getConfig().getDefaultItemResolverClass().getName());
            s_log.info((Object)("Registering " + itemResolverClassName + " as the item resolver class"));
        }
        if (templateResolverClassName != null && templateResolverClassName.length() > 0) {
            this.m_section.setTemplateResolverClass(templateResolverClassName);
            s_log.info((Object)("Registering " + templateResolverClassName + " as the template resolver class"));
        } else {
            this.m_section.setTemplateResolverClass(ContentSection.getConfig().getDefaultTemplateResolverClass().getName());
            s_log.info((Object)("Registering " + templateResolverClassName + " as the template resolver class"));
        }
        this.m_section.save();
    }

    public void registerPublicationCycles() throws ConfigError {
        LifecycleDefinition lcd = new LifecycleDefinition();
        lcd.setLabel((String)GlobalizationUtil.globalize("cms.installer.simple_publication").localize());
        lcd.setDescription("A one-phase lifecycle for items.");
        lcd.save();
        PhaseDefinition pd = lcd.addPhaseDefinition("Live", "The first phase. It lasts forever.", new Integer(0), null, null);
        pd.save();
        lcd.save();
        this.m_lcd = lcd;
        this.m_section.addLifecycleDefinition(lcd);
        this.m_section.save();
    }

    private void registerWorkflowTemplates(List workflows) {
        Iterator workflowsIter = workflows.iterator();
        while (workflowsIter.hasNext()) {
            CMSTask newTask2;
            HashMap<String, CMSTask> newTasks = new HashMap<String, CMSTask>();
            HashMap workflow = (HashMap)workflowsIter.next();
            WorkflowTemplate wf = new WorkflowTemplate();
            wf.setLabel((String)workflow.get("name"));
            wf.setDescription((String)workflow.get("description"));
            wf.save();
            for (HashMap task : (List)workflow.get("tasks")) {
                newTask2 = new CMSTask();
                newTask2.setLabel((String)task.get("name"));
                newTask2.setDescription((String)task.get("description"));
                newTask2.setTaskType(CMSTaskType.retrieveByName((String)task.get("type")));
                if (task.containsKey("role")) {
                    Iterator roleIter = ((List)task.get("role")).iterator();
                    while (roleIter.hasNext()) {
                        Role role = this.m_roles.get(roleIter.next());
                        if (role == null) continue;
                        newTask2.assignGroup(role.getGroup());
                    }
                }
                newTask2.save();
                newTasks.put((String)task.get("name"), newTask2);
            }
            for (HashMap task : (List)workflow.get("tasks")) {
                newTask2 = (CMSTask)((Object)newTasks.get((String)task.get("name")));
                if (task.containsKey("dependOn")) {
                    Iterator dependOnIter = ((List)task.get("dependOn")).iterator();
                    while (dependOnIter.hasNext()) {
                        CMSTask dependOn = (CMSTask)((Object)newTasks.get(dependOnIter.next()));
                        if (dependOn == null) continue;
                        newTask2.addDependency((Task)dependOn);
                    }
                }
                newTask2.save();
            }
            for (CMSTask newTask2 : newTasks.values()) {
                wf.addTask((Task)newTask2);
            }
            wf.save();
            this.m_section.addWorkflowTemplate(wf);
            this.m_section.save();
            if (this.m_wf != null && (!workflow.containsKey("isDefault") || !workflow.get("isDefault").equals("true"))) continue;
            this.m_section.setDefaultWorkflowTemplate(wf);
            this.m_wf = wf;
        }
    }

    public void registerWorkflowTemplates() throws ConfigError {
        ContentSectionConfig config = new ContentSectionConfig();
        config.load();
        this.registerWorkflowTemplates(config.getDefaultWorkflows());
    }

    public void registerContentTypes(List types) {
        for (Object obj : types) {
            if (obj instanceof String) {
                this.registerContentType((String)obj);
                continue;
            }
            List list = (List)obj;
            String name = (String)list.get(0);
            String file = (String)list.get(1);
            ContentType type = this.registerContentType(name);
            this.registerTemplate(type, file);
        }
    }

    ContentType registerContentType(String name) {
        ContentType type = null;
        try {
            type = ContentType.findByAssociatedObjectType(name);
        }
        catch (DataObjectNotFoundException ex) {
            throw new UncheckedWrapperException((String)GlobalizationUtil.globalize("cms.installer.cannot_find_content_type").localize() + name, (Throwable)ex);
        }
        s_log.info((Object)("Adding type " + name + " to " + this.m_section.getDisplayName()));
        this.m_section.addContentType(type);
        s_log.info((Object)("Setting the default lifecycle for " + name + " to " + this.m_lcd.getLabel()));
        ContentTypeLifecycleDefinition.updateLifecycleDefinition(this.m_section, type, this.m_lcd);
        this.m_lcd.save();
        s_log.info((Object)("Setting the default workflow template for " + name + " to " + this.m_wf.getLabel()));
        ContentTypeWorkflowTemplate.updateWorkflowTemplate(this.m_section, type, this.m_wf);
        this.m_wf.save();
        return type;
    }

    void registerTemplate(ContentType type, String filename) {
        int pos1 = filename.lastIndexOf("/");
        int pos2 = filename.lastIndexOf(".");
        if (pos2 == -1) {
            pos2 = filename.length();
        }
        String label = filename.substring(pos1 + 1, pos2);
        String typename = type.getClassName();
        int pos3 = typename.lastIndexOf(".");
        String name = typename.substring(pos3 + 1, typename.length()) + "-" + label;
        Template temp = new Template();
        temp.setContentSection(this.m_section);
        temp.setName(name);
        temp.setLabel(label);
        temp.setParent((ACSObject)this.m_section.getTemplatesFolder());
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream stream = loader.getResourceAsStream(filename.substring(1));
        if (stream == null) {
            throw new IllegalStateException((String)GlobalizationUtil.globalize("cms.installer.cannot_find_file").localize() + filename);
        }
        BufferedReader input = new BufferedReader(new InputStreamReader(stream));
        StringBuilder body = new StringBuilder();
        while (true) {
            String line;
            try {
                line = input.readLine();
            }
            catch (IOException ex) {
                throw new UncheckedWrapperException((String)GlobalizationUtil.globalize("cms.installer.cannot_read_line_of_data").localize(), (Throwable)ex);
            }
            if (line == null) break;
            body.append(line);
            body.append("\n");
        }
        temp.setText(body.toString());
        temp.save();
        TemplateManagerFactory.getInstance().addTemplate(this.m_section, type, temp, "public");
        temp.publish(this.m_lcd, new Date());
    }

    public void registerCategories(String filename) {
        if (filename == null) {
            s_log.info((Object)"not loading any categories");
            return;
        }
        s_log.info((Object)("loading categories from " + filename));
        XML.parseResource((String)filename, (DefaultHandler)new CategoryHandler(this.m_section));
    }

    public void registerAlerts() {
        Role alert = this.m_section.getStaffGroup().createRole("Alert Recipient");
        alert.setDescription("Receive alerts regarding expiration of pubished content");
        alert.save();
    }

    private class CategoryHandler
    extends DefaultHandler {
        private Stack m_cats = new Stack();
        private ContentSection m_section;

        public CategoryHandler(ContentSection section) {
            this.m_section = section;
        }

        @Override
        public void startElement(String uri, String local, String qName, Attributes attrs) {
            if ("categories".equals(qName)) {
                String name = attrs.getValue("name");
                if (name == null) {
                    name = "Root";
                }
                String description = attrs.getValue("description");
                String context = attrs.getValue("context");
                Category root = Category.getRootForObject((ACSObject)this.m_section, (String)context);
                if (root == null) {
                    root = new Category();
                }
                root.setName(name);
                root.setDescription(description);
                if (root.isNew()) {
                    Category.setRootForObject((ACSObject)this.m_section, (Category)root, (String)context);
                }
                this.m_cats.push(root);
                PermissionService.setContext((ACSObject)root, (ACSObject)this.m_section);
            } else if ("category".equals(qName)) {
                String name = attrs.getValue("name");
                String description = attrs.getValue("description");
                String url = attrs.getValue("url");
                if (description == null) {
                    description = name;
                }
                s_log.debug((Object)("creating category '" + name + "'"));
                Category cat = new Category(name, description, url);
                cat.save();
                Category parent = null;
                try {
                    parent = (Category)this.m_cats.peek();
                }
                catch (EmptyStackException ex) {
                    throw new UncheckedWrapperException("no root category", (Throwable)ex);
                }
                parent.addChild((ACSObject)cat);
                parent.save();
                cat.setDefaultParentCategory(parent);
                cat.save();
                this.m_cats.push(cat);
            }
        }

        @Override
        public void endElement(String uri, String local, String qName) {
            if ("category".equals(qName)) {
                this.m_cats.pop();
            } else if ("categories".equals(qName)) {
                this.m_cats.pop();
            }
        }
    }
}

