/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contentsection;

import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentSectionCollection;
import com.arsdigita.cms.contentsection.ContentSectionConfig;
import com.arsdigita.cms.contentsection.ContentSectionSetup;
import com.arsdigita.cms.workflow.CMSTask;
import com.arsdigita.cms.workflow.UnfinishedTaskNotifier;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.kernel.ACSObjectInstantiator;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.runtime.CompoundInitializer;
import com.arsdigita.runtime.ContextCloseEvent;
import com.arsdigita.runtime.ContextInitEvent;
import com.arsdigita.runtime.DomainInitEvent;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Initializer
extends CompoundInitializer {
    private static Logger s_log = Logger.getLogger(Initializer.class);
    private static final ContentSectionConfig s_conf = ContentSectionConfig.getInstance();
    private static Vector s_unfinishedTimers = new Vector();

    public void init(DomainInitEvent evt) {
        s_log.debug((Object)"contentsection.Initializer.init(DomainInitEvent) invoked");
        super.init(evt);
        evt.getFactory();
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.cms.ContentSection", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dobj) {
                return new ContentSection(dobj);
            }
        });
        this.checkForNewContentSection();
        s_log.debug((Object)"contentsection.Initializer.init(DomainInitEvent) completed");
    }

    public void init(ContextInitEvent evt) {
        s_log.debug((Object)"content section ContextInitEvent started");
        super.init(evt);
        ContentSectionCollection sections = ContentSection.getAllSections();
        while (sections.next()) {
            ContentSection section = sections.getContentSection();
            this.initializeTaskAlerts(section, s_conf.getTaskAlerts());
            Timer unfinishedTimer = this.startNotifierTask(section, s_conf.getSendOverdueAlerts(), s_conf.getTaskDuration(), s_conf.getAlertInterval(), s_conf.getMaxAlerts());
            if (unfinishedTimer == null) continue;
            s_unfinishedTimers.addElement(unfinishedTimer);
        }
        sections.close();
        s_log.debug((Object)"content section ContextInitEvent completed");
    }

    public void close(ContextCloseEvent evt) {
        s_log.debug((Object)"content section ContextCloseEvent started");
        Timer unfinishedTimer = null;
        if (s_unfinishedTimers.size() > 0) {
            Enumeration el = s_unfinishedTimers.elements();
            while (el.hasMoreElements()) {
                unfinishedTimer = (Timer)el.nextElement();
                if (unfinishedTimer != null) {
                    unfinishedTimer.cancel();
                }
                unfinishedTimer = null;
            }
        }
        s_log.debug((Object)"content section ContextCloseEvent completed");
    }

    private void checkForNewContentSection() {
        String newSectionName = s_conf.getNewContentSectionName();
        if (newSectionName != null && !newSectionName.isEmpty()) {
            ContentSectionCollection sections = ContentSection.getAllSections();
            sections.addEqualsFilter("primaryURL", "/" + newSectionName + "/");
            if (sections.next()) {
                s_log.warn((Object)("Content section " + newSectionName + " already exists, skipping creation task.\n" + "You may delete the entry from configuration file."));
                ContentSection section = sections.getContentSection();
                sections.close();
            } else {
                s_log.info((Object)("Content section " + newSectionName + " in " + " doesn't exist, creating it."));
                TransactionContext txn = SessionManager.getSession().getTransactionContext();
                txn.beginTxn();
                ContentSectionSetup.setupContentSectionAppInstance(newSectionName, s_conf.getDefaultRoles(), s_conf.getDefaultWorkflows(), s_conf.isPubliclyViewable(), s_conf.getItemResolverClass(), s_conf.getTemplateResolverClass(), s_conf.getContentSectionsContentTypes(), s_conf.getUseSectionCategories(), s_conf.getCategoryFileList());
                txn.commitTxn();
            }
        }
    }

    public void initializeTaskAlerts(ContentSection section, String[] taskAlerts) {
        if (taskAlerts != null) {
            int n = taskAlerts.length;
            for (int i = 0; i < n; ++i) {
                StringTokenizer tok = new StringTokenizer(taskAlerts[i], ":");
                try {
                    String taskName = tok.nextToken();
                    while (tok.hasMoreTokens()) {
                        String operation = tok.nextToken();
                        CMSTask.addAlert(section, taskName, operation);
                    }
                    continue;
                }
                catch (NoSuchElementException nsee) {
                    s_log.warn((Object)"Invalid task alerts definition");
                }
            }
        }
    }

    private Timer startNotifierTask(ContentSection section, Boolean sendOverdue, Integer duration, Integer alertInterval, Integer max) {
        Timer unfinished = null;
        if (sendOverdue.booleanValue()) {
            if (duration == null || alertInterval == null || max == null) {
                s_log.info((Object)"Not sending overdue task alerts, required initialization parameters were not specified");
                return null;
            }
            unfinished = new Timer(true);
            UnfinishedTaskNotifier notifier = new UnfinishedTaskNotifier(section, duration, alertInterval, max);
            unfinished.schedule((TimerTask)notifier, 300000L, 3600000L);
            s_log.info((Object)("Sending overdue alerts for tasks greater than " + duration + " hours old"));
        } else {
            s_log.info((Object)"Not sending overdue task alerts");
        }
        return unfinished;
    }
}

